/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.file;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class FileQueryServiceHelper {
    private static final Log LOG = LogFactory.getLog(FileQueryServiceHelper.class);

    public static Map<String, Object> queryAllFileBoByEmp(Map<String, Object> param) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("success", Boolean.TRUE);
        LinkedHashMap<String, Cloneable> resultData = new LinkedHashMap<String, Cloneable>(16);
        LinkedHashMap entityName = new LinkedHashMap(16);
        resultData.put("entityName", entityName);
        LinkedHashMap resultProp = new LinkedHashMap(16);
        resultData.put("prop", resultProp);
        ArrayList resultFile = new ArrayList(10);
        resultData.put("file", resultFile);
        LinkedHashMap resultFileMapTemp = new LinkedHashMap(16);
        resultData.put("fileMapTemp", resultFileMapTemp);
        result.put("data", resultData);
        try {
            FileQueryServiceHelper.validateParam(param, result);
            Object isSucc = result.get("success");
            if (isSucc != null && !((Boolean)isSucc).booleanValue()) {
                return result;
            }
            Map<String, Object> salaryFileResult = FileQueryServiceHelper.querySalaryFileBoByEmp(param);
            if (!FileQueryServiceHelper.adjustResult(result, salaryFileResult)) {
                return result;
            }
            FileQueryServiceHelper.combinResult(result, param, salaryFileResult, "salaryFile", "hsas_salaryfile");
            Map<String, Object> adjFileResult = FileQueryServiceHelper.queryAdjFileBoByEmp(param);
            if (!FileQueryServiceHelper.adjustResult(result, adjFileResult)) {
                return result;
            }
            FileQueryServiceHelper.combinResult(result, param, adjFileResult, "adjFile", "hcdm_adjfileinfo");
            Map<String, Object> taxFileResult = FileQueryServiceHelper.queryTaxFileBoByEmp(param);
            if (!FileQueryServiceHelper.adjustResult(result, taxFileResult)) {
                return result;
            }
            FileQueryServiceHelper.combinResult(result, param, taxFileResult, "taxFile", "itc_taxfile");
            Map<String, Object> sinsurFileResult = FileQueryServiceHelper.querySinsurFileBoByEmp(param);
            if (!FileQueryServiceHelper.adjustResult(result, sinsurFileResult)) {
                return result;
            }
            FileQueryServiceHelper.combinResult(result, param, sinsurFileResult, "sinsurFile", "hcsi_sinsurfile");
            resultFile.addAll(resultFileMapTemp.values());
            resultData.remove("fileMapTemp");
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...queryFile.error\uff1a", (Throwable)ex);
            String errorMsg = ex.getMessage();
            if (errorMsg != null && errorMsg.length() >= 100) {
                errorMsg = errorMsg.substring(0, 100) + "...";
            }
            result.put("message", errorMsg);
            result.put("success", Boolean.FALSE);
            resultData.remove("fileMapTemp");
        }
        return result;
    }

    private static void validateParam(Map<String, Object> param, Map<String, Object> result) {
        if (!(param.get("employees") instanceof List) || ((List)param.get("employees")).size() == 0) {
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"FileQueryServiceHelper_1", (String)"swc-hsbs-business", (Object[])new Object[0]));
            return;
        }
        try {
            List employees = (List)param.get("employees");
            ArrayList<Long> employeesNew = new ArrayList<Long>(10);
            for (Object empId : employees) {
                employeesNew.add(Long.parseLong(String.valueOf(empId)));
            }
            param.put("employees", employeesNew);
        }
        catch (Exception ex) {
            LOG.error("FileQueryServiceHelper...validateParam.error\uff1a", (Throwable)ex);
            result.put("success", Boolean.FALSE);
            result.put("message", ResManager.loadKDString((String)"\u53c2\u6570\u9519\u8bef\u3002", (String)"FileQueryServiceHelper_1", (String)"swc-hsbs-business", (Object[])new Object[0]));
            return;
        }
    }

    private static boolean adjustResult(Map<String, Object> result, Map<String, Object> fileResult) {
        if (!((Boolean)fileResult.get("success")).booleanValue()) {
            result.put("success", Boolean.FALSE);
            result.put("message", String.valueOf(fileResult.get("message")));
            LOG.error("FileQueryServiceHelper...queryFile.error\uff1a", result.get("message"));
            Map resultData = (Map)result.get("data");
            resultData.remove("fileMapTemp");
            return false;
        }
        return true;
    }

    private static void combinResult(Map<String, Object> result, Map<String, Object> param, Map<String, Object> fileResult, String fileType, String entityNum) {
        Map data = (Map)result.get("data");
        Map resultProp = (Map)data.get("prop");
        Map entityName = (Map)data.get("entityName");
        String selectProperties = String.valueOf(param.get("selectProperties"));
        List<String> props = Arrays.asList(selectProperties.replace(" ", "").replace(".id", "").replace(".number", "").replace(".name", "").split(","));
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNum);
        entityName.put(fileType, mainEntityType.getDisplayName().getLocaleValue());
        Map fieldProps = mainEntityType.getFields();
        LinkedHashMap<String, String> propNameMap = new LinkedHashMap<String, String>(16);
        for (Map.Entry prop : fieldProps.entrySet()) {
            String pkey = (String)prop.getKey();
            IDataEntityProperty propval = (IDataEntityProperty)prop.getValue();
            String propName = propval.getDisplayName().getLocaleValue();
            if (!props.contains(pkey)) continue;
            propNameMap.put(pkey, propName);
        }
        resultProp.put(fileType, propNameMap);
        List employees = (List)param.get("employees");
        List fileDatas = (List)fileResult.get("data");
        Map<Long, List<Map>> fileDataMap = fileDatas.stream().collect(Collectors.groupingBy(dy -> (Long)dy.get("employee_id")));
        Map resultFileMapTemp = (Map)data.get("fileMapTemp");
        LinkedHashMap<String, Object> empFile = null;
        List<Map<String, Object>> empFileData = null;
        for (Long empId : employees) {
            empFile = (LinkedHashMap<String, Object>)resultFileMapTemp.get(empId);
            if (empFile == null) {
                empFile = new LinkedHashMap<String, Object>();
                empFile.put("employee_id", empId);
                resultFileMapTemp.put(empId, empFile);
            }
            if ((empFileData = fileDataMap.get(empId)) != null && empFileData.size() >= 1) {
                for (Map map : empFileData) {
                    map.remove("employee_id");
                    if (!"administrator".equals(String.valueOf(map.get("modifier_name")))) continue;
                    map.put("modifier_name", null);
                }
                empFileData = FileQueryServiceHelper.distinctFileData(empFileData);
            }
            empFile.put(fileType, empFileData);
        }
    }

    private static List<Map<String, Object>> distinctFileData(List<Map<String, Object>> empFileData) {
        ArrayList<Map<String, Object>> afterData = new ArrayList<Map<String, Object>>(10);
        ArrayList<String> propKeys = new ArrayList<String>(10);
        propKeys.addAll(empFileData.get(0).keySet());
        HashSet<String> values = new HashSet<String>(16);
        for (Map<String, Object> fileData : empFileData) {
            StringBuilder sb = new StringBuilder();
            for (String pkey : propKeys) {
                sb.append(fileData.get(pkey));
            }
            if (!values.add(sb.toString())) continue;
            afterData.add(fileData);
        }
        return afterData;
    }

    private static Map<String, Object> querySalaryFileBoByEmp(Map<String, Object> param) {
        param.put("selectProperties", "number, org.name, payrollgroup.name, modifier.name");
        Object status = param.get("status");
        if (status == null) {
            param.put("status", Arrays.asList("A", "B", "C"));
        }
        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hsas", (String)"ISalaryFileService", (String)"querySalaryFileBoByEmp", (Object[])new Object[]{param});
        return result;
    }

    private static Map<String, Object> queryAdjFileBoByEmp(Map<String, Object> param) {
        param.put("selectProperties", "number, org.name, stdscm.name, modifier.name");
        Object status = param.get("status");
        if (status == null) {
            param.put("status", Arrays.asList("A", "B", "C"));
        }
        Map result = (Map)SWCMServiceUtils.invokeSWCService((String)"hcdm", (String)"IAdjFileInfoService", (String)"queryAdjFileBoByEmp", (Object[])new Object[]{param});
        return result;
    }

    private static Map<String, Object> queryTaxFileBoByEmp(Map<String, Object> param) {
        param.put("selectProperties", "number, org.name, taxunit.name, modifier.name");
        Object status = param.get("status");
        if (status == null) {
            param.put("status", Arrays.asList("A", "B", "C"));
        }
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"itc", (String)"itcTaxFileApiService", (String)"queryTaxFileBoByEmp", (Object[])new Object[]{param});
        return result;
    }

    private static Map<String, Object> querySinsurFileBoByEmp(Map<String, Object> param) {
        param.put("selectProperties", "number, org.name, welfarepayer.name, welfarepayertheory.name, modifier.name");
        Object status = param.get("status");
        if (status == null) {
            param.put("status", Arrays.asList("A", "B", "C"));
        }
        Map result = (Map)SWCMServiceUtils.invokeSITService((String)"hcsi", (String)"ISinsurFileService", (String)"querySinsurFileBoByEmp", (Object[])new Object[]{param});
        return result;
    }
}

