/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;

public class FileServiceHelper {
    private static final Log LOG = LogFactory.getLog(FileServiceHelper.class);
    private static final String KEY_SUCCESS = "success";
    private static final String KEY_MSG = "message";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> genSalaryFileRelateSet(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        try (TXHandle txHandle = TX.requiresNew();){
            if (result.containsKey(KEY_SUCCESS)) {
                HashMap<String, Object> hashMap = result;
                return hashMap;
            }
            Map<String, Object> datas = FileServiceHelper.genSalaryFileRelateSetCore(param);
            result.put(KEY_SUCCESS, Boolean.TRUE);
            result.put("data", datas);
        }
        return result;
    }

    private static Map<String, Object> genSalaryFileRelateSetCore(Map<String, Object> param) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        HashMap<String, Object> presetDataMap = new HashMap<String, Object>();
        DynamicObject setDy = FileServiceHelper.dealSalaryFileRelateSet(param, presetDataMap);
        FileServiceHelper.genFileRelatePreData(setDy, presetDataMap);
        result.put("presetDataMap", presetDataMap);
        return result;
    }

    public static void genRelatePreDataForButton(Object id) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
        DynamicObject dy = serviceHelper.queryOne(id);
        if (dy == null) {
            throw new KDBizException("data not exists!");
        }
        if (dy.getBoolean("isselfembedpage")) {
            return;
        }
        FileServiceHelper.genHisModelAppDefaultEvent(dy);
        HashMap<String, Object> presetDataMap = new HashMap<String, Object>();
        FileServiceHelper.genFileRelatePreData(dy, presetDataMap);
    }

    private static void genHisModelAppDefaultEvent(DynamicObject dy) {
        String sourceBizAppNumber = EntityMetadataCache.getDataEntityType((String)dy.getString("pagenumber")).getAppId();
        SWCDataServiceHelper appDefaultEventHelper = new SWCDataServiceHelper("hrcs_appdefaultevent");
        SWCDataServiceHelper entityobjectHelper = new SWCDataServiceHelper("bos_entityobject");
        QFilter entityFilter = new QFilter("id", "=", (Object)dy.getString("pagenumber"));
        DynamicObject entityDy = entityobjectHelper.queryOne("id,bizappid.id", entityFilter.toArray());
        String bizAppId = entityDy.getString("bizappid.id");
        QFilter qFilter = new QFilter("actionapp", "in", (Object)bizAppId);
        boolean isExists = appDefaultEventHelper.isExists(qFilter.toArray());
        if (!isExists) {
            DynamicObject appDefaultEventDy = appDefaultEventHelper.generateEmptyDynamicObject();
            appDefaultEventDy.set("actionapp", (Object)bizAppId);
            QFilter originalFilter = new QFilter("actionapp.number", "in", (Object)sourceBizAppNumber);
            DynamicObject originalDy = appDefaultEventHelper.queryOne("evententity", originalFilter.toArray());
            if (originalDy != null) {
                appDefaultEventDy.set("evententity", originalDy.get("evententity"));
                appDefaultEventHelper.saveOne(appDefaultEventDy);
            }
        }
    }

    private static void genFileRelatePreData(DynamicObject setDy, Map<String, Object> presetDataMap) {
        FileServiceHelper.genHRParameterConfig(setDy, presetDataMap);
        FileServiceHelper.genRelatePanelSet(setDy, presetDataMap);
    }

    private static void genRelatePanelSet(DynamicObject setDy, Map<String, Object> presetDataMap) {
        SWCDataServiceHelper relateHelper = new SWCDataServiceHelper("hsbs_relatepanelset");
        QFilter paramFilter = new QFilter("pageinfo", "=", setDy.get("pagenumber"));
        boolean paramisExists = relateHelper.isExists(paramFilter.toArray());
        if (paramisExists) {
            return;
        }
        String props = SWCHisBaseDataHelper.getSelectProperties((String)setDy.getString("pagenumber"));
        if (props.contains("datastatus")) {
            DynamicObject whiteDy = relateHelper.generateEmptyDynamicObject();
            whiteDy.set("number", setDy.get("pagenumber"));
            whiteDy.set("name", (Object)ResManager.loadKDString((String)"{0}\u5386\u53f2", (String)"FileServiceHelper_0", (String)"swc-hsbs-business", (Object[])new Object[]{setDy.get("pageembedflexname")}));
            whiteDy.set("pageinfo", setDy.get("pagenumber"));
            whiteDy.set("url", (Object)"hsas_salaryfileside");
            whiteDy.set("pagetype", (Object)"3");
            whiteDy.set("mainpropname", setDy.get("mainpropkey"));
            whiteDy.set("status", (Object)"C");
            whiteDy.set("enable", (Object)"1");
            String relatepageinfoId = setDy.getString("entitytype.relatepageinfo.id");
            Long entityTypeId = 1010L;
            if (relatepageinfoId.contains("hcdm")) {
                entityTypeId = 1020L;
            }
            whiteDy.set("entitytype", (Object)entityTypeId);
            whiteDy.set("index", (Object)setDy.getInt("index"));
            whiteDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            relateHelper.saveOne(whiteDy);
            ArrayList<Long> setIds = new ArrayList<Long>(10);
            setIds.add(whiteDy.getLong("id"));
            presetDataMap.put(relateHelper.getEntityName(), setIds);
        }
    }

    private static void genHRParameterConfig(DynamicObject setDy, Map<String, Object> presetDataMap) {
        SWCDataServiceHelper paramHelper = new SWCDataServiceHelper("hbss_parameterconfig");
        SWCDataServiceHelper whiteHelper = new SWCDataServiceHelper("hbss_paramwhitelist");
        SWCDataServiceHelper appHelper = new SWCDataServiceHelper("bos_devportal_bizapp");
        QFilter paramFilter = new QFilter("basedatafield", "=", setDy.get("pagenumber"));
        QFilter whiteFilter = new QFilter("basedata", "=", setDy.get("pagenumber"));
        boolean paramisExists = paramHelper.isExists(paramFilter.toArray());
        boolean whiteisExists = whiteHelper.isExists(whiteFilter.toArray());
        if (paramisExists || whiteisExists) {
            return;
        }
        DynamicObject whiteDy = whiteHelper.generateEmptyDynamicObject();
        whiteDy.set("basedata", setDy.get("pagenumber"));
        String bizAppId = EntityMetadataCache.getDataEntityType((String)setDy.getString("pagenumber")).getAppId();
        QFilter qFilter = new QFilter("number", "=", (Object)bizAppId);
        DynamicObject bizAppDy = appHelper.queryOne("id,number,bizcloud.id", qFilter.toArray());
        whiteDy.set("app", (Object)bizAppDy);
        String mainEntityId = setDy.getString("entitytype.relatepageinfo.id");
        whiteDy.set("refbasedata", (Object)mainEntityId);
        DynamicObjectCollection entrys = whiteHelper.generateEmptyEntryCollection(whiteDy, "entryentity");
        DynamicObject entry1 = entrys.addNew();
        entry1.set("paramtype", (Object)"audit");
        entry1.set("modifyenable", (Object)"0");
        entry1.set("defval", (Object)" ");
        DynamicObject entry2 = entrys.addNew();
        entry2.set("paramtype", (Object)"enable");
        entry2.set("modifyenable", (Object)"0");
        entry2.set("defval", (Object)" ");
        DynamicObject entry3 = entrys.addNew();
        entry3.set("paramtype", (Object)"log");
        entry3.set("modifyenable", (Object)"0");
        entry3.set("defval", (Object)" ");
        whiteHelper.saveOne(whiteDy);
        ArrayList<Long> setIds = new ArrayList<Long>(10);
        setIds.add(whiteDy.getLong("id"));
        presetDataMap.put(whiteHelper.getEntityName(), setIds);
    }

    private static DynamicObject dealSalaryFileRelateSet(Map<String, Object> param, Map<String, Object> presetDataMap) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsbs_filedetaildisplayset");
        DynamicObject setDy = serviceHelper.queryOne(SWCHisBaseDataHelper.getSelectProperties((String)serviceHelper.getEntityName()), new QFilter[]{new QFilter("pagenumber", "=", param.get("pagenumber"))});
        if (setDy == null) {
            setDy = serviceHelper.generateEmptyDynamicObject();
            setDy.set("pagenumber", param.get("pagenumber"));
            setDy.set("pageembedflexkey", (Object)(String.valueOf(param.get("pagenumber")).replace("_", "") + "flex"));
            setDy.set("showtype", (Object)"1");
            setDy.set("dataquerytype", (Object)"1");
            setDy.set("enable", (Object)"1");
            setDy.set("isselfembedpage", (Object)"0");
            String pagenumber = setDy.getString("pagenumber");
            Long entityTypeId = 1928953284568275968L;
            if (pagenumber.contains("hcdm")) {
                entityTypeId = 1928954662615241728L;
            }
            setDy.set("entitytype", (Object)entityTypeId);
            DynamicObject setLastDy = serviceHelper.queryOne("index", null, "index desc");
            if (setLastDy == null) {
                setDy.set("index", (Object)1000);
            } else {
                setDy.set("index", (Object)(setLastDy.getInt("index") + 10));
            }
            setDy.set("creator", (Object)RequestContext.get().getCurrUserId());
            SWCDataServiceHelper entityHelper = new SWCDataServiceHelper("bos_entityobject");
            DynamicObject entityDy = entityHelper.queryOne("name", new QFilter[]{new QFilter("number", "=", param.get("pagenumber"))});
            if (entityDy != null) {
                setDy.set("pageembedflexname", (Object)entityDy.getString("name"));
            } else {
                setDy.set("pageembedflexname", param.get("pagenumber"));
            }
            serviceHelper.saveOne(setDy);
            ArrayList<Long> setIds = new ArrayList<Long>(10);
            setIds.add(setDy.getLong("id"));
            presetDataMap.put(serviceHelper.getEntityName(), setIds);
        }
        return setDy;
    }
}

