/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.formula;

import java.util.Stack;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FuncDefineSplitHelper {
    private static final String LEFTBRACE = "{";
    private static final String RIGHTBRACE = "}";
    private static final char EMPTY = ' ';
    private static final String EMPTYSTRING = " ";
    private static final String COMMA = ",";
    private static final String LPARENTHESES = "(";
    private static final String RPARENTHESES = ")";

    public static String createMethodExp(String funcExp) {
        funcExp = funcExp.replace("\\t", "    ");
        String[] lines = funcExp.split("\\r?\\n");
        String lineText = null;
        StringBuilder methodStr = new StringBuilder();
        boolean firstLeftBrace = false;
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            int index;
            lineText = lines[i].trim();
            if (SWCStringUtils.isEmpty((String)lineText)) continue;
            if (firstLeftBrace) {
                if (methodStr.length() == 0) {
                    methodStr.append(lineText);
                    continue;
                }
                methodStr.append('\n').append(lineText);
                continue;
            }
            int len = lineText.length();
            for (index = 0; index < len; ++index) {
                String ch = String.valueOf(lineText.charAt(index));
                if (!SWCStringUtils.equals((String)ch, (String)LEFTBRACE)) continue;
                firstLeftBrace = true;
                break;
            }
            if (index >= len - 1) continue;
            methodStr.append(lineText.substring(index + 1, len));
        }
        return methodStr.toString();
    }

    public static String formatMethodExp(String funcExp) throws Exception {
        funcExp = funcExp.replace("\\t", "    ");
        String[] lines = funcExp.split("\\r?\\n");
        String lineText = null;
        StringBuilder methodStr = new StringBuilder();
        Stack<String> leftBraceStack = new Stack<String>();
        boolean isHaveFirstLeftBrace = false;
        int size = lines.length;
        for (int i = 0; i < size; ++i) {
            lineText = lines[i].trim();
            if (SWCStringUtils.isEmpty((String)lineText)) continue;
            isHaveFirstLeftBrace = FuncDefineSplitHelper.parseLineText(methodStr, lineText, leftBraceStack, isHaveFirstLeftBrace);
        }
        if (!leftBraceStack.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5b58\u5728\u9519\u8bef\uff0c\u5b58\u5728\u591a\u4f59\u7684\u5de6\u5927\u62ec\u53f7\u201c{\u201d\u3002", (String)"FuncDefineSplitHelper_0", (String)"swc-hsbs-business", (Object[])new Object[0]));
        }
        return methodStr.toString().trim();
    }

    private static boolean parseLineText(StringBuilder methodStr, String lineText, Stack<String> leftBraceStack, boolean isHaveFirstLeftBrace) throws Exception {
        int len = lineText.length();
        int index = 0;
        int fromIndex = 0;
        int toIndex = 0;
        while (index < len) {
            String ch = String.valueOf(lineText.charAt(index));
            if (SWCStringUtils.equals((String)ch, (String)LEFTBRACE)) {
                if (fromIndex < index) {
                    toIndex = index;
                    methodStr.append(' ').append(lineText.substring(fromIndex, toIndex));
                }
                fromIndex = index;
                toIndex = index + 1;
                methodStr.append(' ').append(lineText.substring(fromIndex, toIndex)).append('\n');
                fromIndex = toIndex;
                if (isHaveFirstLeftBrace && leftBraceStack.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5b58\u5728\u9519\u8bef\uff0c\u7b2c\u4e00\u4e2a\u5de6\u5927\u62ec\u53f7\u201c{\u201d\u5fc5\u987b\u4e0e\u6700\u540e\u4e00\u4e2a\u53f3\u5927\u62ec\u53f7\u201c}\u201d\u5339\u914d\u3002", (String)"FuncDefineSplitHelper_2", (String)"swc-hsbs-business", (Object[])new Object[0]));
                }
                if (!isHaveFirstLeftBrace && leftBraceStack.isEmpty()) {
                    isHaveFirstLeftBrace = true;
                }
                leftBraceStack.push(ch);
                ++index;
                continue;
            }
            if (SWCStringUtils.equals((String)ch, (String)RIGHTBRACE)) {
                if (leftBraceStack.isEmpty()) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5b58\u5728\u9519\u8bef\uff0c\u5b58\u5728\u591a\u4f59\u7684\u53f3\u5927\u62ec\u53f7\u201c}\u201d\u3002", (String)"FuncDefineSplitHelper_1", (String)"swc-hsbs-business", (Object[])new Object[0]));
                }
                leftBraceStack.pop();
                if (fromIndex < index) {
                    toIndex = index;
                    methodStr.append(' ').append(lineText.substring(fromIndex, toIndex));
                }
                fromIndex = index;
                toIndex = index + 1;
                methodStr.append(lineText.substring(fromIndex, toIndex)).append('\n');
                fromIndex = toIndex;
                ++index;
                continue;
            }
            if (SWCStringUtils.equals((String)ch, (String)";")) {
                if (fromIndex < index) {
                    toIndex = index;
                    methodStr.append(' ').append(lineText.substring(fromIndex, toIndex));
                }
                fromIndex = index;
                toIndex = index + 1;
                methodStr.append(lineText.substring(fromIndex, toIndex)).append('\n');
                fromIndex = toIndex;
                ++index;
                continue;
            }
            if (SWCStringUtils.equals((String)ch, (String)LPARENTHESES) || SWCStringUtils.equals((String)ch, (String)RPARENTHESES) || SWCStringUtils.equals((String)ch, (String)COMMA)) {
                if (fromIndex < index) {
                    toIndex = index;
                    methodStr.append(' ').append(lineText.substring(fromIndex, toIndex));
                }
                fromIndex = index;
                toIndex = index + 1;
                methodStr.append(lineText.substring(fromIndex, toIndex));
                fromIndex = toIndex;
                ++index;
                continue;
            }
            if (SWCStringUtils.equals((String)ch, (String)EMPTYSTRING)) {
                if (fromIndex < index) {
                    toIndex = index;
                    methodStr.append(' ').append(lineText.substring(fromIndex, toIndex));
                    fromIndex = index + 1;
                } else {
                    fromIndex = index + 1;
                }
                ++index;
                continue;
            }
            ++index;
        }
        if (fromIndex < len) {
            methodStr.append(' ').append(lineText.substring(fromIndex, len));
        }
        return isHaveFirstLeftBrace;
    }
}

