/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.insurance.service;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.hr.hbp.business.servicehelper.HRBaseServiceHelper;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbs.common.enums.HSBSErrorInfoEnum;

public class SInsurBaseFetchCfgService {
    private static final Log log = LogFactory.getLog(SInsurBaseFetchCfgService.class);

    public static Map<String, Map<String, String>> getBaseFetchItemInfoByCfg(Collection<Long> insuranceBaseFetchCfgIds, int status) {
        return SInsurBaseFetchCfgService.getBaseFetchItemDetailByCfg(insuranceBaseFetchCfgIds, status, "id");
    }

    public static Map<String, Map<String, String>> getBaseFetchItemDetailByCfg(Collection<Long> insuranceBaseFetchCfgIds, int status, String fieldKey) {
        HRBaseServiceHelper baseFetchCfgHelper = new HRBaseServiceHelper("hsbs_sinsbsfetchcfg");
        QFilter filter = null;
        filter = 0 == status ? new QFilter("1", "=", (Object)1) : new QFilter("id", "in", insuranceBaseFetchCfgIds);
        DynamicObjectCollection baseCfgFetchDys = baseFetchCfgHelper.queryOriginalCollection("id,number,basefetchitem", filter.toArray());
        if (baseCfgFetchDys == null || baseCfgFetchDys.size() == 0) {
            return new HashMap<String, Map<String, String>>(0);
        }
        Map<String, Long> baseFetchCfgMap = baseCfgFetchDys.stream().filter(baseCfgFetchDy -> baseCfgFetchDy.getDynamicObjectType().getProperties().containsKey((Object)fieldKey)).collect(Collectors.toMap(baseCfgFetchDy -> baseCfgFetchDy.getString(fieldKey), baseCfgFetchDy -> baseCfgFetchDy.getLong("basefetchitem"), (oldVal, neweVal) -> oldVal));
        Map<Long, Map<String, String>> baseFetchItemInfo = SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus(baseFetchCfgMap.values(), 1);
        HashMap<String, Map<String, String>> baseFetchCfgInfo = new HashMap<String, Map<String, String>>(baseFetchItemInfo.size());
        for (Map.Entry<String, Long> baseFetchCfgInfoEntry : baseFetchCfgMap.entrySet()) {
            Map<String, String> baseFetchItemDetailInfo = baseFetchItemInfo.get(baseFetchCfgInfoEntry.getValue());
            if (baseFetchItemDetailInfo == null) continue;
            baseFetchCfgInfo.put(baseFetchCfgInfoEntry.getKey(), baseFetchItemDetailInfo);
        }
        return baseFetchCfgInfo;
    }

    public static Map<Long, Map<String, String>> getBaseFetchItemInfoByStatus(Collection<Long> inputInsuranceBaseFetchItemIds, int status) {
        HashMap<Long, Map<String, String>> resultMap = new HashMap<Long, Map<String, String>>(16);
        try {
            HRBaseServiceHelper baseFetchItemHelper = new HRBaseServiceHelper("sitbs_basefetchitem");
            QFilter qFilter = Integer.valueOf(0).equals(status) ? new QFilter("1", "=", (Object)1) : new QFilter("id", "in", inputInsuranceBaseFetchItemIds);
            DynamicObject[] baseFetchItemDys = baseFetchItemHelper.query("id,name,number", qFilter.toArray());
            if (baseFetchItemDys != null) {
                for (DynamicObject baseFetchItemDy : baseFetchItemDys) {
                    HashMap<String, String> filedMap = new HashMap<String, String>(16);
                    filedMap.put("number", baseFetchItemDy.getString("number"));
                    filedMap.put("name", baseFetchItemDy.getString("name"));
                    filedMap.put("id", baseFetchItemDy.getString("id"));
                    resultMap.put(baseFetchItemDy.getLong("id"), filedMap);
                }
            }
        }
        catch (Exception ex) {
            log.error("SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus: query base error, ", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
        }
        log.info("SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus: resultMap is {}", (Object)((Object)resultMap).toString());
        return resultMap;
    }

    public static Table<String, String, Object> getBaseFetchItemInfoByName(Collection<String> baseFetchItemNames) {
        HashBasedTable baseFetchItemInfoTable = HashBasedTable.create();
        try {
            HRBaseServiceHelper baseFetchItemHelper = new HRBaseServiceHelper("sitbs_basefetchitem");
            QFilter qFilter = new QFilter("name", "in", baseFetchItemNames);
            DynamicObject[] baseFetchItemDys = baseFetchItemHelper.query("id,name,number,status,enable", qFilter.toArray());
            if (baseFetchItemDys == null || baseFetchItemDys.length == 0) {
                return baseFetchItemInfoTable;
            }
            for (DynamicObject baseFetchItemDy : baseFetchItemDys) {
                String name = baseFetchItemDy.getString("name");
                String number = baseFetchItemDy.getString("number");
                if (name != null) {
                    baseFetchItemInfoTable.put((Object)name, (Object)"name", (Object)name);
                }
                if (number != null) {
                    baseFetchItemInfoTable.put((Object)name, (Object)"number", (Object)number);
                }
                baseFetchItemInfoTable.put((Object)name, (Object)"id", (Object)baseFetchItemDy.getLong("id"));
                baseFetchItemInfoTable.put((Object)name, (Object)"status", (Object)baseFetchItemDy.getString("status"));
                baseFetchItemInfoTable.put((Object)name, (Object)"enable", (Object)baseFetchItemDy.getString("enable"));
            }
        }
        catch (Exception ex) {
            log.error("SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus: query base error, ", (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", ex.toString()), new Object[0]);
        }
        return baseFetchItemInfoTable;
    }

    public static void updateBaseFetchItem(Collection<DynamicObject> baseFetchCfgDys, Table<String, String, Object> baseFetchItemInfoTable) {
        if (baseFetchCfgDys == null || baseFetchItemInfoTable == null) {
            return;
        }
        for (DynamicObject baseFetchCfgDy : baseFetchCfgDys) {
            Object baseFetchItemPkId;
            if (!baseFetchCfgDy.getDataEntityType().getProperties().containsKey((Object)"basefetchitemname") || !((baseFetchItemPkId = baseFetchItemInfoTable.get((Object)baseFetchCfgDy.getString("name"), (Object)"id")) instanceof Long)) continue;
            baseFetchCfgDy.set("basefetchitem", baseFetchItemPkId);
        }
    }

    public static Map<ExtendedDataEntity, String> getRepetitiveExtendedDataEntity(ExtendedDataEntity[] dataEntities, String operateKey) {
        HashBasedTable countryBaseFetchItemAndExEntityMap = HashBasedTable.create();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            boolean isHistorySave;
            DynamicObject cfgInfoDy = dataEntity.getDataEntity();
            boolean bl = isHistorySave = "changesave".equals(operateKey) || "auditconfirmchange".equals(operateKey) || "confirmchange".equals(operateKey);
            if ("enable".equals(operateKey) ? !"C".equals(cfgInfoDy.getString("status")) : !isHistorySave) continue;
            long countryId = cfgInfoDy.getLong("country.id");
            long baseFetchItemId = cfgInfoDy.getLong("basefetchitem");
            if (countryBaseFetchItemAndExEntityMap.get((Object)countryId, (Object)baseFetchItemId) != null) continue;
            countryBaseFetchItemAndExEntityMap.put((Object)countryId, (Object)baseFetchItemId, (Object)cfgInfoDy);
        }
        if (!countryBaseFetchItemAndExEntityMap.isEmpty()) {
            List<DynamicObject> insurCfgDys = SInsurBaseFetchCfgService.queryRepetitiveExtendedDataEntity((HashBasedTable<Long, Long, DynamicObject>)countryBaseFetchItemAndExEntityMap);
            for (DynamicObject insurCfgDy : insurCfgDys) {
                long countryId = insurCfgDy.getLong("country.id");
                long baseFetchItemId = insurCfgDy.getLong("basefetchitem");
                countryBaseFetchItemAndExEntityMap.put((Object)countryId, (Object)baseFetchItemId, (Object)insurCfgDy);
            }
        }
        LinkedHashMap<ExtendedDataEntity, String> errExtendedDataEntityMap = new LinkedHashMap<ExtendedDataEntity, String>(dataEntities.length);
        if (!countryBaseFetchItemAndExEntityMap.isEmpty()) {
            Map<Long, Map<String, String>> baseFetchItemInfo = SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus(countryBaseFetchItemAndExEntityMap.columnKeySet(), 1);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject insurCfgDy = dataEntity.getDataEntity();
                Long currBaseFetchCfgBoID = insurCfgDy.getLong("boid");
                long countryId = insurCfgDy.getLong("country.id");
                long baseFetchItemId = insurCfgDy.getLong("basefetchitem");
                DynamicObject storeBaseFetchItemCfgDy = (DynamicObject)countryBaseFetchItemAndExEntityMap.get((Object)countryId, (Object)baseFetchItemId);
                if (storeBaseFetchItemCfgDy == null || currBaseFetchCfgBoID.equals(storeBaseFetchItemCfgDy.getLong("boid"))) continue;
                String baseFetchItemName = (String)baseFetchItemInfo.getOrDefault(baseFetchItemId, Collections.emptyMap()).get("name");
                String errInfo = HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_ITEM_CFG_REPETITIVE.getInfo(new Object[]{baseFetchItemName, storeBaseFetchItemCfgDy.getString("name")});
                errExtendedDataEntityMap.put(dataEntity, errInfo);
            }
        }
        return errExtendedDataEntityMap;
    }

    public static List<DynamicObject> queryRepetitiveExtendedDataEntity(HashBasedTable<Long, Long, DynamicObject> countryBaseFetchItemAndExEntityMap) {
        if (countryBaseFetchItemAndExEntityMap == null || countryBaseFetchItemAndExEntityMap.isEmpty()) {
            return new ArrayList<DynamicObject>(0);
        }
        HRBaseServiceHelper helper = new HRBaseServiceHelper("hsbs_sinsbsfetchcfg");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        filter.and("country", "in", countryBaseFetchItemAndExEntityMap.rowMap().keySet());
        filter.and("basefetchitem", "in", countryBaseFetchItemAndExEntityMap.columnMap().keySet());
        DynamicObjectCollection sinsurCfgDys = helper.queryOriginalCollection("country.id,basefetchitem,name,boid", filter.toArray());
        if (sinsurCfgDys == null || sinsurCfgDys.size() == 0) {
            return new ArrayList<DynamicObject>(0);
        }
        Iterator iterator = sinsurCfgDys.iterator();
        while (iterator.hasNext()) {
            DynamicObject sinsurCfgDy = (DynamicObject)iterator.next();
            long countryId = sinsurCfgDy.getLong("country.id");
            long baseFetchItemId = sinsurCfgDy.getLong("basefetchitem");
            if (countryId != 0L && baseFetchItemId != 0L && countryBaseFetchItemAndExEntityMap.get((Object)countryId, (Object)baseFetchItemId) != null) continue;
            iterator.remove();
        }
        return sinsurCfgDys;
    }

    public static Map<Long, DynamicObject> getModifyNotAllowedCfgData(List<Long> cfgBoIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_sinsbsfetchcfg");
        QFilter filter = new QFilter("boid", "in", cfgBoIds);
        filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
        DynamicObject[] cfgData = helper.loadDynamicObjectArray(filter.toArray());
        if (cfgData == null) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(cfgData).collect(Collectors.toMap(cfgDy -> cfgDy.getLong("boid"), cfgDy -> cfgDy, (oldVal, newVal) -> oldVal));
    }
}

