/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.paybizproc;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;

public class PayBizProcHelper {
    public static void viewFlowChart(IFormView view, DynamicObjectCollection dyColl, String name) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("hsbs_paybizflowchart");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        String title = ResManager.loadKDString((String)"\u4f5c\u4e1a\u6d41\u7a0b", (String)"PayBizProcHelper_0", (String)"swc-hsbs-business", (Object[])new Object[0]);
        parameter.setCaption(title + " - " + name);
        parameter.setCustomParam("entry_node_next_map", PayBizProcHelper.getEntryNextMap(dyColl));
        parameter.setCustomParam("entry_node_info_map", PayBizProcHelper.getEntryInfo(dyColl));
        parameter.setClientParam("billId", (Object)"hsbs_paybizflowchart");
        parameter.setShowTitle(true);
        parameter.setShowFullScreen(true);
        view.showForm(parameter);
    }

    public static Map<String, List<Long>> getEntryNextMap(DynamicObjectCollection dyColl) {
        HashMap<String, List<Long>> entryNextMap = new HashMap<String, List<Long>>(dyColl.size());
        for (DynamicObject dyObj : dyColl) {
            ArrayList<Long> nextPayTasks = new ArrayList<Long>(10);
            long payTaskId = dyObj.getLong("paybizaction.id");
            block1: for (DynamicObject dyObj2 : dyColl) {
                DynamicObjectCollection mulBaseData = dyObj2.getDynamicObjectCollection("prepaybizaction");
                for (DynamicObject prepaybizaction : mulBaseData) {
                    if (prepaybizaction.getLong("fbasedataid_id") != payTaskId) continue;
                    nextPayTasks.add(dyObj2.getLong("paybizaction.id"));
                    continue block1;
                }
            }
            entryNextMap.put(String.valueOf(payTaskId), nextPayTasks);
        }
        return entryNextMap;
    }

    public static Map<Long, List<Long>> getEntryPreMap(DynamicObjectCollection dyColl) {
        HashMap<Long, List<Long>> nodeMap = new HashMap<Long, List<Long>>(dyColl.size());
        for (DynamicObject dyObj : dyColl) {
            ArrayList<Long> prePayTasks = new ArrayList<Long>(10);
            DynamicObjectCollection mulBaseData = dyObj.getDynamicObjectCollection("prepaybizaction");
            for (DynamicObject prepaybizaction : mulBaseData) {
                prePayTasks.add(prepaybizaction.getLong("fbasedataid_id"));
            }
            nodeMap.put(dyObj.getLong("paybizaction.id"), prePayTasks);
        }
        return nodeMap;
    }

    public static Map<Long, Map<String, Object>> getEntryInfo(DynamicObjectCollection dyColl) {
        HashMap<Long, Map<String, Object>> result = new HashMap<Long, Map<String, Object>>(dyColl.size());
        for (DynamicObject entry : dyColl) {
            long payTaskId = entry.getLong("paybizaction.id");
            String payTaskName = entry.getString("paybizaction.name");
            String payTaskNumber = entry.getString("paybizaction.number");
            HashMap<String, String> value = new HashMap<String, String>(2);
            value.put("payTaskName", payTaskName);
            value.put("payTaskNumber", payTaskNumber);
            result.put(payTaskId, value);
        }
        return result;
    }

    public static void setNodeLengthDoLoop(Long currentNode, List<Long> nextPayTasks, Map<String, List<Long>> entryNextMap, Map<Long, Integer> nodeLengthMap, Integer startLength) {
        Integer currNodeLength = nodeLengthMap.get(currentNode);
        if (currNodeLength == null) {
            nodeLengthMap.put(currentNode, startLength);
        } else {
            currNodeLength = startLength > currNodeLength ? startLength : currNodeLength;
            nodeLengthMap.put(currentNode, currNodeLength);
        }
        for (Long payTaskId : nextPayTasks) {
            List<Long> nextNextPayTasks = entryNextMap.get(String.valueOf(payTaskId));
            if (!nextNextPayTasks.isEmpty()) {
                PayBizProcHelper.setNodeLengthDoLoop(payTaskId, new ArrayList<Long>(nextNextPayTasks), entryNextMap, nodeLengthMap, startLength + 1);
                continue;
            }
            Integer endNodeLength = nodeLengthMap.get(payTaskId);
            if (endNodeLength == null) {
                nodeLengthMap.put(payTaskId, startLength);
                continue;
            }
            Integer n = startLength;
            Integer n2 = startLength = Integer.valueOf(startLength + 1);
            endNodeLength = startLength > endNodeLength ? startLength : endNodeLength;
            nodeLengthMap.put(payTaskId, endNodeLength);
        }
    }
}

