/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.salaryitem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCConstants;

public class SalaryItemUpdateOrgTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SalaryItemUpdateOrgTask.class);
    private static final String SQL = "select fdataid from t_hsbs_salaryitem_u where fuseorgid = 0";

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        DataSet dataSet = DB.queryDataSet((String)"SalaryItemUpdateOrgTask", (DBRoute)SWCConstants.SWC_ROUETE, (String)SQL);
        HashSet<Long> salaryItemIds = new HashSet<Long>(16);
        while (dataSet.hasNext()) {
            Row row = dataSet.next();
            salaryItemIds.add(row.getLong("fdataid"));
        }
        if (salaryItemIds.isEmpty()) {
            logger.info("salaryItemIds is empty");
            this.disableTask();
            return;
        }
        try {
            UpgradeResult upgradeResult = this.dealAndSaveData(salaryItemIds);
            if (upgradeResult.isSuccess()) {
                this.disableTask();
            } else {
                logger.info("error upgradeResult is :{}", (Object)upgradeResult.getErrorInfo());
            }
        }
        catch (Exception exception) {
            logger.error("update SalaryItem failed {}", (Object)exception.getMessage());
        }
    }

    private UpgradeResult dealAndSaveData(Set<Long> salaryItemIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter filter = new QFilter("id", "in", salaryItemIds);
        DynamicObject salaryItemArray = helper.query("id,status,createorg", new QFilter[]{filter});
        if (salaryItemIds.size() != ((DynamicObject[])salaryItemArray).length) {
            for (DynamicObject salaryItem : salaryItemArray) {
                salaryItemIds.remove(salaryItem.getLong("id"));
            }
            logger.info("can not find ids : {}", (Object)salaryItemIds.toString());
        }
        String entity = "hsbs_salaryitem";
        String tableName = "t_hsbs_salaryitem";
        HashMap<Long, Long> dataOrgMap = new HashMap<Long, Long>(16);
        for (DynamicObject salaryItem : salaryItemArray) {
            dataOrgMap.put(salaryItem.getLong("id"), salaryItem.getLong("createorg.id"));
        }
        boolean isTreeType = false;
        UpgradeResult upgradeResult = BaseDataServiceHelper.presetCtrlOrgUseRangData((String)"swc", (String)entity, (String)tableName, dataOrgMap, (boolean)isTreeType);
        if (upgradeResult.isSuccess()) {
            String deleteSql = "delete from t_hsbs_salaryitem_u where fuseorgid = 0";
            DB.execute((DBRoute)SWCConstants.SWC_ROUETE, (String)deleteSql);
        }
        return upgradeResult;
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

