/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.salaryitem;

import java.util.HashMap;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;

public class SalaryItemUpdateTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(SalaryItemUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter filter = new QFilter("issyspreset", "=", (Object)"1");
        DynamicObject[] salaryItemArray = helper.query("id,createorg", new QFilter[]{filter});
        String entity = "hsbs_salaryitem";
        String tableName = "t_hsbs_salaryitem";
        HashMap<Long, Long> dataOrgMap = new HashMap<Long, Long>(16);
        for (DynamicObject salaryItem : salaryItemArray) {
            dataOrgMap.put(salaryItem.getLong("id"), salaryItem.getLong("createorg.id"));
        }
        boolean isTreeType = false;
        UpgradeResult result = BaseDataServiceHelper.presetCtrlOrgUseRangData((String)"swc", (String)entity, (String)tableName, dataOrgMap, (boolean)isTreeType);
        if (result.isSuccess()) {
            ScheduleManager serviceManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
            TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
            serviceManager.disableJob(taskInfo.getJobId());
            serviceManager.disableSchedule(taskInfo.getScheduleId());
        } else {
            logger.info("error result is :{}", (Object)result.getErrorInfo());
        }
    }
}

