/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.statistictag;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class StatisticsTagHelper {
    private static final String KEY_SUPERIOR_TAG_CACHE = "superiorTagCache";
    private static final String KEY_SUPERIOR_TAG_ID_SET = "superiorTagIdSet_%s";

    public static void removeCache(String sortCode) {
        ISWCAppCache appCache = SWCAppCache.get((String)KEY_SUPERIOR_TAG_CACHE);
        String key = String.format(Locale.ROOT, KEY_SUPERIOR_TAG_ID_SET, sortCode);
        appCache.remove(key);
    }

    public static QFilter getTagLevelFilterForStatisticTag() {
        Set<Long> effectiveTagLevelIdSet = StatisticsTagHelper.getEffectiveTagLevelIdSet();
        if (effectiveTagLevelIdSet == null) {
            return null;
        }
        return new QFilter("taglevel", "in", effectiveTagLevelIdSet);
    }

    public static QFilter getCountryFilterForStatisticTag() {
        QFilter countryDataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHLXNRR9KPZ", (String)"hsbs_statisticstag", (String)"country");
        if (countryDataFilter == null) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bd_country");
        DynamicObjectCollection datas = helper.queryOriginalCollection("id", new QFilter[]{countryDataFilter});
        return new QFilter("country", "in", datas.stream().map(data -> data.getLong("id")).collect(Collectors.toSet()));
    }

    public static Set<Long> getEffectiveTagLevelIdSet() {
        QFilter dataFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((String)"/UHLXNRR9KPZ", (String)"hsbs_statisticstag", (String)"taglevel");
        if (dataFilter == null) {
            return null;
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_taglevel");
        DynamicObjectCollection datas = helper.queryOriginalCollection("id", new QFilter[]{dataFilter});
        return datas.stream().map(data -> data.getLong("id")).collect(Collectors.toSet());
    }

    public static List<TreeNode> getStatisticsTagTreeNode(List<Long> orgIdList) {
        TreeNode root = new TreeNode("", "root", ResManager.loadKDString((String)"\u5168\u90e8", (String)"StatisticsTagHelper_0", (String)"swc-hsbs-business", (Object[])new Object[0]));
        root.setIsOpened(true);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(10);
        nodeList.add(root);
        List<DynamicObject> validStatisticsTagObjs = StatisticsTagHelper.getValidStatisticsObjs(orgIdList);
        if (SWCListUtils.isEmpty(validStatisticsTagObjs)) {
            return new ArrayList<TreeNode>(0);
        }
        HashMap<String, List<String>> dataIdMap = new HashMap<String, List<String>>(16);
        for (DynamicObject statisticsTagObj : validStatisticsTagObjs) {
            TreeNode node;
            long id = statisticsTagObj.getLong("id");
            String name = statisticsTagObj.getString("name");
            long parentId = statisticsTagObj.getLong("parent.id");
            List rootChildIdList = dataIdMap.computeIfAbsent("root", single -> new ArrayList(10));
            rootChildIdList.add(id + "");
            if (parentId == 0L) {
                node = new TreeNode("root", id + "", name);
            } else {
                List childIdList = dataIdMap.computeIfAbsent(parentId + "", single -> new ArrayList(10));
                childIdList.add(id + "");
                node = new TreeNode(parentId + "", id + "", name);
            }
            nodeList.add(node);
        }
        Map<String, TreeNode> nodeMap = nodeList.stream().collect(Collectors.toMap(v1 -> v1.getId(), Function.identity()));
        for (TreeNode node : nodeList) {
            StatisticsTagHelper.assembleNodeData(node, nodeMap, dataIdMap);
        }
        root.setData(dataIdMap.get("root"));
        return nodeList;
    }

    private static void assembleNodeData(TreeNode node, Map<String, TreeNode> nodeMap, Map<String, List<String>> dataIdMap) {
        String id = node.getId();
        String parentId = node.getParentid();
        if (SWCStringUtils.isNotEmpty((String)parentId)) {
            List<String> childList = dataIdMap.get(id);
            if (SWCListUtils.isEmpty(childList)) {
                return;
            }
            TreeNode parentNode = nodeMap.get(parentId);
            List parentChildList = dataIdMap.computeIfAbsent(parentId, single -> new ArrayList(10));
            parentChildList.addAll(childList);
            parentNode.setData(new HashSet(parentChildList));
            node.setData(childList);
            if (!SWCStringUtils.equals((String)"root", (String)parentId)) {
                StatisticsTagHelper.assembleNodeData(parentNode, nodeMap, dataIdMap);
            }
        }
    }

    public static List<DynamicObject> getValidStatisticsObjs(List<Long> orgIdList) {
        SWCDataServiceHelper helper;
        DynamicObjectCollection statisticsTagObjs;
        List authorizedDataRuleQFilter;
        QFilter baseDataFilter;
        QFilter filter = new QFilter("enable", "in", (Object)new String[]{"1", "0"});
        if (!SWCListUtils.isEmpty(orgIdList) && (baseDataFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_statisticstag", orgIdList, (boolean)true)) != null) {
            filter.and(baseDataFilter);
        }
        if ((authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"/UHLXNRR9KPZ", (String)"hsbs_statisticstag", (String)"47150e89000000ac")) != null) {
            authorizedDataRuleQFilter.forEach(arg_0 -> ((QFilter)filter).and(arg_0));
        }
        if (SWCListUtils.isEmpty((List)(statisticsTagObjs = (helper = new SWCDataServiceHelper("hsbs_statisticstag")).queryOriginalCollection("id,number,name,taglevel.id,parent.id,isleaf,enable,longnumber", new QFilter[]{filter}, "longnumber asc, number asc")))) {
            return new ArrayList<DynamicObject>(0);
        }
        Map<Long, DynamicObject> statisticsMap = statisticsTagObjs.stream().collect(Collectors.toMap(v1 -> v1.getLong("id"), Function.identity()));
        helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter itemFilter = new QFilter("statisticstag.id", "in", statisticsMap.keySet());
        DynamicObjectCollection itemObjs = helper.queryOriginalCollection("statisticstag.id", new QFilter[]{itemFilter});
        Set refTagIdSet = itemObjs.stream().map(single -> single.getLong("statisticstag.id")).collect(Collectors.toSet());
        ArrayList<Long> refTagIdList = new ArrayList<Long>(10);
        refTagIdList.addAll(refTagIdSet);
        for (Long tagId : refTagIdSet) {
            StatisticsTagHelper.addRefTagId(refTagIdList, (DynamicObject)statisticsMap.get(tagId), statisticsMap);
        }
        statisticsTagObjs.removeIf(single -> SWCStringUtils.equals((String)"0", (String)single.getString("enable")) && !refTagIdList.contains(single.getLong("id")));
        return statisticsTagObjs.stream().collect(Collectors.toList());
    }

    private static void addRefTagId(List<Long> tagIdList, DynamicObject tagObj, Map<Long, DynamicObject> statisticsMap) {
        long tagId;
        if (tagObj == null) {
            return;
        }
        long parentId = tagObj.getLong("parent.id");
        if (parentId > 0L) {
            StatisticsTagHelper.addRefTagId(tagIdList, statisticsMap.get(parentId), statisticsMap);
        }
        if (!tagIdList.contains(tagId = tagObj.getLong("id"))) {
            tagIdList.add(tagId);
        }
    }
}

