/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.business.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.schedule.ScheduleServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;

public class PaySubjectUpdateTask
extends AbstractTask {
    private static final Log LOG = LogFactory.getLog(PaySubjectUpdateTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        long startTime = System.currentTimeMillis();
        try {
            this.updatePaySubjectLaw();
            this.disableTask();
        }
        catch (Exception e) {
            LOG.error("PaySubjectUpdateTask execute error:", (Throwable)e);
        }
        LOG.info("PaySubjectUpdateTask total use time:{}", (Object)(System.currentTimeMillis() - startTime));
    }

    private void updatePaySubjectLaw() {
        LOG.info("start to deal PaySubject");
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
        QFilter statusTempFilter = new QFilter("status", "in", Arrays.asList("A", "B"));
        statusTempFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        statusTempFilter.and(new QFilter("lawentity", "!=", (Object)0L));
        DynamicObject[] query = helper.query("lawentity,boid,bsed,bsled", new QFilter[]{statusTempFilter});
        if (query != null && query.length > 0) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "delete", query});
        }
        this.deleteErrorData();
        this.dealEffectingData();
    }

    private void deleteErrorData() {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hbss_lawentityuse");
        QFilter filter = new QFilter("number", "=", (Object)"hsbs_paysubject");
        filter.and(new QFilter("opitemid", "=", (Object)0));
        DynamicObject[] query = helper.query("rellawentityid", new QFilter[]{filter});
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(10);
        SWCDataServiceHelper paySubjectHelper = new SWCDataServiceHelper("hsbs_paysubject");
        if (query != null && query.length > 0) {
            for (DynamicObject law : query) {
                DynamicObject paySubject = paySubjectHelper.generateEmptyDynamicObject();
                paySubject.set("lawentity", (Object)this.getDynamicObjectById("hbss_lawentity", law.getLong("rellawentityid")));
                list.add(paySubject);
            }
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "delete", list.toArray(new DynamicObject[0])});
        }
    }

    private void dealEffectingData() {
        DynamicObject[] objects;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_paysubject");
        QFilter hisFilter = new QFilter("iscurrentversion", "=", (Object)"0");
        QFilter filter = new QFilter("datastatus", "=", (Object)"1");
        filter.and(new QFilter("lawentity", "!=", (Object)0L));
        DynamicObjectCollection collection = helper.queryOriginalCollection("boid,lawentity.id", new QFilter[]{filter, hisFilter});
        Map<Long, Long> boIdLawMap = collection.stream().collect(Collectors.toMap(data -> data.getLong("boid"), data -> data.getLong("lawentity.id"), (o1, o2) -> o2));
        HashSet<Long> auditIdSet = new HashSet<Long>(16);
        HashSet<Long> deleteIdSet = new HashSet<Long>(16);
        SWCDataServiceHelper lawHelper = new SWCDataServiceHelper("hbss_lawentityuse");
        QFilter lawFilter = new QFilter("number", "=", (Object)"hsbs_paysubject");
        DynamicObject[] query = lawHelper.query("opitemid,rellawentityid", new QFilter[]{lawFilter});
        if (query != null && query.length > 0) {
            for (DynamicObject law : query) {
                Long id = law.getLong("opitemid");
                Long lawId = boIdLawMap.get(id);
                if (lawId != null && lawId.equals(law.getLong("rellawentityid"))) {
                    auditIdSet.add(id);
                    continue;
                }
                deleteIdSet.add(id);
            }
        }
        if ((objects = helper.query("lawentity,boid,bsed,bsled", new QFilter[]{filter = new QFilter("id", "in", deleteIdSet)})) != null && objects.length > 0) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "delete", objects});
        }
        Set<Long> boIdSet = boIdLawMap.keySet();
        boIdSet.removeAll(auditIdSet);
        filter = new QFilter("id", "in", boIdSet);
        objects = helper.query("lawentity,boid,bsed,bsled", new QFilter[]{filter});
        if (objects != null && objects.length > 0) {
            SWCMServiceUtils.invokeBizService((String)"hrmp", (String)"hbss", (String)"IHBSSService", (String)"relLawEntity", (Object[])new Object[]{"hsbs_paysubject", "audit", objects});
        }
    }

    private DynamicObject getDynamicObjectById(String entityName, Long id) {
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)entityName);
        return id == null || id == 0L ? null : new DynamicObject((DynamicObjectType)type, (Object)id);
    }

    private void disableTask() {
        ScheduleManager service = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        TaskInfo taskInfo = ScheduleServiceHelper.queryTask((String)this.taskId);
        service.disableJob(taskInfo.getJobId());
        service.disableSchedule(taskInfo.getScheduleId());
    }
}

