/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class BizItemService {
    public Map<Long, Integer> batchGetBizItemPropDataLen(List<Long> bizItemPropIdList) {
        HashMap<Long, Integer> propDataLenMap = new HashMap<Long, Integer>(16);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemprop");
        QFilter filter = new QFilter("id", "in", bizItemPropIdList);
        DynamicObjectCollection propColl = helper.queryOriginalCollection("id,datalength", new QFilter[]{filter});
        if (propColl == null || propColl.size() == 0) {
            return propDataLenMap;
        }
        for (DynamicObject proObj : propColl) {
            Integer dataLen = (Integer)proObj.get("datalength");
            if (dataLen == null) continue;
            propDataLenMap.put(proObj.getLong("id"), dataLen);
        }
        return propDataLenMap;
    }

    public Map<Long, List<Map<String, Object>>> getBizItemPropInfo(List<Long> bizItemIdList) {
        HashMap<Long, List<Map<String, Object>>> retMap = new HashMap<Long, List<Map<String, Object>>>(bizItemIdList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        String field = "bizitempropentry.bizitemprop,bizitempropentry.bizitemprop.number,bizitempropentry.bizitemprop.name,bizitempropentry.bizitemprop.datatype,bizitempropentry.bizitemprop.datalength,bizitempropentry.bizitemprop.scalelimit,bizitempropentry.bizitemprop.minvalue,bizitempropentry.bizitemprop.maxvalue,bizitempropentry.bizitemprop.earliestdate,bizitempropentry.bizitemprop.lastdate,bizitempropentry.bizitemprop.status,bizitempropentry.bizitemprop.enable";
        QFilter filter = new QFilter("id", "in", bizItemIdList);
        filter.and("isextprop", "=", (Object)true);
        filter.and("classification", "!=", (Object)"1");
        DynamicObject[] bizItemArray = helper.query(field, new QFilter[]{filter});
        if (bizItemArray == null || bizItemArray.length == 0) {
            return retMap;
        }
        for (DynamicObject bizItemObj : bizItemArray) {
            DynamicObjectCollection entryColl = bizItemObj.getDynamicObjectCollection("bizitempropentry");
            if (SWCObjectUtils.isEmpty((Object)entryColl)) continue;
            Long bizItemId = bizItemObj.getLong("id");
            ArrayList bizItemPropList = new ArrayList(10);
            for (DynamicObject entryObj : entryColl) {
                DynamicObject bizItemPropObj = entryObj.getDynamicObject("bizitemprop");
                if (SWCObjectUtils.isEmpty((Object)bizItemPropObj)) continue;
                String status = bizItemPropObj.getString("status");
                String enable = bizItemPropObj.getString("enable");
                if (!SWCStringUtils.equals((String)status, (String)"C") || !SWCStringUtils.equals((String)enable, (String)"1")) continue;
                HashMap<String, Object> bizItemPropMap = new HashMap<String, Object>(16);
                Long bizItemPropId = bizItemPropObj.getLong("id");
                String bizItemPropName = bizItemPropObj.getString("name");
                String bizItemPropNumber = bizItemPropObj.getString("number");
                bizItemPropMap.put("bizItemPropId", bizItemPropId);
                bizItemPropMap.put("bizItemPropName", bizItemPropName);
                bizItemPropMap.put("bizItemPropNumber", bizItemPropNumber);
                Long dataTypeId = bizItemPropObj.getLong("datatype.id");
                if (dataTypeId == 1030L) {
                    bizItemPropMap.put("dataType", "text");
                    bizItemPropMap.put("dataLength", bizItemPropObj.get("datalength"));
                } else if (dataTypeId == 1010L) {
                    bizItemPropMap.put("dataType", "decimal");
                    bizItemPropMap.put("scaleLimit", bizItemPropObj.get("scalelimit"));
                    bizItemPropMap.put("minValue", bizItemPropObj.get("minvalue"));
                    bizItemPropMap.put("maxValue", bizItemPropObj.get("maxvalue"));
                } else if (dataTypeId == 1050L) {
                    bizItemPropMap.put("dataType", "date");
                    bizItemPropMap.put("earliestDate", bizItemPropObj.get("earliestdate"));
                    bizItemPropMap.put("lastDate", bizItemPropObj.get("lastdate"));
                }
                bizItemPropList.add(bizItemPropMap);
            }
            if (bizItemPropList.size() <= 0) continue;
            retMap.put(bizItemId, bizItemPropList);
        }
        return retMap;
    }

    public void getBizItemGroupSubmitDate(Set<Long> bizItemIdSet, Map<Long, Map<String, Date>> bizItemGroupSubmitDateMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        QFilter filter = new QFilter("status", "in", (Object)"C");
        filter.and("enable", "in", (Object)"1");
        filter.and("entryentity.bizitem.id", "in", bizItemIdSet);
        DynamicObject[] submitValDatas = helper.query("entryentity.bizitem,entryentity.bizitem.id,entryentity.submitstartdate,entryentity.submitenddate", new QFilter[]{filter});
        if (submitValDatas == null || submitValDatas.length == 0) {
            return;
        }
        for (Long bizItemId : bizItemIdSet) {
            Map<String, Date> bizItemSubmitValMap = bizItemGroupSubmitDateMap.get(bizItemId);
            if (bizItemSubmitValMap == null) {
                bizItemSubmitValMap = new HashMap<String, Date>(3);
            }
            Date submitStartDate = bizItemSubmitValMap.get("submitStartDate");
            Date submitEndDate = bizItemSubmitValMap.get("submitEndDate");
            for (DynamicObject submitValData : submitValDatas) {
                DynamicObjectCollection entryColl = submitValData.getDynamicObjectCollection("entryentity");
                if (entryColl == null || entryColl.size() == 0) continue;
                for (DynamicObject entryObj : entryColl) {
                    long queryBizItemId = entryObj.getLong("bizitem.id");
                    if (queryBizItemId != bizItemId) continue;
                    Date queryStartDate = entryObj.getDate("submitstartdate");
                    Date queryEndDate = entryObj.getDate("submitenddate");
                    submitStartDate = this.getSubmitMinDate(submitStartDate, queryStartDate);
                    submitStartDate = this.getSubmitMinDate(submitStartDate, queryEndDate);
                    submitEndDate = this.getSubmitMaxDate(submitEndDate, queryStartDate);
                    submitEndDate = this.getSubmitMaxDate(submitEndDate, queryEndDate);
                }
            }
            bizItemSubmitValMap.put("submitStartDate", submitStartDate);
            bizItemSubmitValMap.put("submitEndDate", submitEndDate);
            bizItemGroupSubmitDateMap.put(bizItemId, bizItemSubmitValMap);
        }
    }

    public void getBizItemGroupSubmitVal(Set<Long> bizItemIdSet, Map<Long, Map<String, BigDecimal>> bizItemGroupSubmitValMap) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemgroup");
        QFilter filter = new QFilter("status", "in", (Object)"C");
        filter.and("enable", "in", (Object)"1");
        filter.and("entryentity.bizitem.id", "in", bizItemIdSet);
        DynamicObject[] submitValDatas = helper.query("entryentity.bizitem,entryentity.bizitem.id,entryentity.submitminvalue,entryentity.submitmaxvalue", new QFilter[]{filter});
        if (submitValDatas == null || submitValDatas.length == 0) {
            return;
        }
        for (Long bizItemId : bizItemIdSet) {
            Map<String, BigDecimal> bizItemSubmitValMap = bizItemGroupSubmitValMap.get(bizItemId);
            if (bizItemSubmitValMap == null) {
                bizItemSubmitValMap = new HashMap<String, BigDecimal>(3);
            }
            BigDecimal submitMinVal = bizItemSubmitValMap.get("submitMinValue");
            BigDecimal submitMaxVal = bizItemSubmitValMap.get("submitMaxValue");
            for (DynamicObject submitValData : submitValDatas) {
                DynamicObjectCollection entryColl = submitValData.getDynamicObjectCollection("entryentity");
                if (entryColl == null || entryColl.size() == 0) continue;
                for (DynamicObject entryObj : entryColl) {
                    long queryBizItemId = entryObj.getLong("bizitem.id");
                    if (queryBizItemId != bizItemId) continue;
                    BigDecimal queryMinVal = entryObj.getBigDecimal("submitminvalue");
                    BigDecimal queryMaxVal = entryObj.getBigDecimal("submitmaxvalue");
                    submitMinVal = this.getSubmitMinVal(submitMinVal, queryMinVal);
                    submitMinVal = this.getSubmitMinVal(submitMinVal, queryMaxVal);
                    submitMaxVal = this.getSubmitMaxVal(submitMaxVal, queryMinVal);
                    submitMaxVal = this.getSubmitMaxVal(submitMaxVal, queryMaxVal);
                }
            }
            bizItemSubmitValMap.put("submitMinValue", submitMinVal);
            bizItemSubmitValMap.put("submitMaxValue", submitMaxVal);
            bizItemGroupSubmitValMap.put(bizItemId, bizItemSubmitValMap);
        }
    }

    private Date getSubmitMaxDate(Date submitEndDate, Date queryDate) {
        if (submitEndDate == null && queryDate == null) {
            return submitEndDate;
        }
        if (submitEndDate != null && queryDate == null) {
            return submitEndDate;
        }
        if (submitEndDate == null && queryDate != null) {
            return queryDate;
        }
        if (queryDate.compareTo(submitEndDate) > 0) {
            return queryDate;
        }
        return submitEndDate;
    }

    private Date getSubmitMinDate(Date submitStartDate, Date queryDate) {
        if (submitStartDate == null && queryDate == null) {
            return submitStartDate;
        }
        if (submitStartDate != null && queryDate == null) {
            return submitStartDate;
        }
        if (submitStartDate == null && queryDate != null) {
            return queryDate;
        }
        if (queryDate.compareTo(submitStartDate) < 0) {
            return queryDate;
        }
        return submitStartDate;
    }

    private BigDecimal getSubmitMaxVal(BigDecimal submitMaxVal, BigDecimal queryVal) {
        if (submitMaxVal == null && queryVal == null) {
            return submitMaxVal;
        }
        if (submitMaxVal != null && queryVal == null) {
            return submitMaxVal;
        }
        if (submitMaxVal == null && queryVal != null) {
            return queryVal;
        }
        if (queryVal.compareTo(submitMaxVal) > 0) {
            return queryVal;
        }
        return submitMaxVal;
    }

    private BigDecimal getSubmitMinVal(BigDecimal submitMinVal, BigDecimal queryVal) {
        if (submitMinVal == null && queryVal == null) {
            return submitMinVal;
        }
        if (submitMinVal != null && queryVal == null) {
            return submitMinVal;
        }
        if (submitMinVal == null && queryVal != null) {
            return queryVal;
        }
        if (queryVal.compareTo(submitMinVal) < 0) {
            return queryVal;
        }
        return submitMinVal;
    }
}

