/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CalFrequencyServiceHelper {
    public static Map<Long, String> checkUnique(List<DynamicObject> dynamicObjects) {
        HashMap<Long, String> result = new HashMap<Long, String>(dynamicObjects.size());
        if (SWCListUtils.isEmpty(dynamicObjects)) {
            return result;
        }
        String typeErrorMsg = ResManager.loadKDString((String)"\u8be5\u56fd\u5bb6/\u5730\u533a\u5df2\u5b58\u5728\u591a\u6761\u9891\u5ea6\u7c7b\u578b\u4e3a%s\u3001\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u7684\u6570\u636e\u3002", (String)"CalFrequencyServiceHelper_1", (String)"swc-hsbs-business", (Object[])new Object[0]);
        SWCDataServiceHelper calFrequencyServiceHelper = new SWCDataServiceHelper("hsbs_calfrequency");
        HashMap<Long, Map<String, DynamicObject>> groupByCountryId = new HashMap<Long, Map<String, DynamicObject>>(dynamicObjects.size());
        for (DynamicObject dynamicObject : dynamicObjects) {
            String frequencyType;
            Map groupList = groupByCountryId.computeIfAbsent(dynamicObject.getLong("country.id"), val -> new HashMap(10));
            if (groupList.containsKey(frequencyType = dynamicObject.getString("type")) && !CalFrequencyEnum.OTHER.equals((Object)CalFrequencyEnum.valueOf((String)frequencyType))) {
                result.put((Long)dynamicObject.getPkValue(), String.format(Locale.ROOT, typeErrorMsg, CalFrequencyEnum.valueOf((String)frequencyType).getI18nName().loadKDString()));
                continue;
            }
            groupList.put(frequencyType, dynamicObject);
        }
        QFilter countryFilter = new QFilter("country", "in", groupByCountryId.keySet());
        QFilter enableFilter = new QFilter("enable", "=", (Object)"1");
        countryFilter.and(enableFilter);
        DynamicObject[] calFrequenciesQuery = calFrequencyServiceHelper.query("name,type,country.id", countryFilter.toArray());
        HashMap<Long, List<DynamicObject>> groupCalFrequenciesQuery = new HashMap<Long, List<DynamicObject>>(dynamicObjects.size());
        for (DynamicObject calFrequency : calFrequenciesQuery) {
            List queryGroupList = groupCalFrequenciesQuery.computeIfAbsent(calFrequency.getLong("country.id"), val -> new ArrayList(10));
            queryGroupList.add(calFrequency);
        }
        return CalFrequencyServiceHelper.buildValidateResult(groupByCountryId, groupCalFrequenciesQuery, result);
    }

    private static Map<Long, String> buildValidateResult(Map<Long, Map<String, DynamicObject>> groupByCountryId, Map<Long, List<DynamicObject>> groupCalFrequenciesQuery, Map<Long, String> result) {
        String nameErrorMsg = ResManager.loadKDString((String)"\u8be5\u56fd\u5bb6/\u5730\u533a\u5df2\u5b58\u5728\u591a\u6761\u9891\u5ea6\u76f8\u540c\u3001\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u7684\u6570\u636e\u3002", (String)"CalFrequencyServiceHelper_0", (String)"swc-hsbs-business", (Object[])new Object[0]);
        String typeErrorMsg = ResManager.loadKDString((String)"\u8be5\u56fd\u5bb6/\u5730\u533a\u5df2\u5b58\u5728\u591a\u6761\u9891\u5ea6\u7c7b\u578b\u4e3a%s\u3001\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u7684\u6570\u636e\u3002", (String)"CalFrequencyServiceHelper_1", (String)"swc-hsbs-business", (Object[])new Object[0]);
        for (Map.Entry<Long, Map<String, DynamicObject>> entry : groupByCountryId.entrySet()) {
            Long countryId = entry.getKey();
            Map<String, DynamicObject> validateGroupData = entry.getValue();
            List<DynamicObject> queryGroupList = groupCalFrequenciesQuery.get(countryId);
            if (SWCListUtils.isEmpty(queryGroupList)) continue;
            block1: for (Map.Entry<String, DynamicObject> validateCalFrequency : validateGroupData.entrySet()) {
                String name = validateCalFrequency.getValue().getString("name");
                String type = validateCalFrequency.getValue().getString("type");
                Long validatePkValue = (Long)validateCalFrequency.getValue().getPkValue();
                for (DynamicObject queryCalFrequency : queryGroupList) {
                    Long queryPkValue = (Long)queryCalFrequency.getPkValue();
                    if (validatePkValue != null && validatePkValue.equals(queryPkValue)) continue;
                    if (CalFrequencyEnum.valueOf((String)type).equals((Object)CalFrequencyEnum.OTHER)) {
                        if (!SWCStringUtils.equals((String)name, (String)queryCalFrequency.getString("name"))) continue;
                        result.put(validatePkValue, nameErrorMsg);
                        continue block1;
                    }
                    if (SWCStringUtils.equals((String)type, (String)queryCalFrequency.getString("type"))) {
                        result.put(validatePkValue, String.format(Locale.ROOT, typeErrorMsg, CalFrequencyEnum.valueOf((String)type).getI18nName().loadKDString()));
                        continue block1;
                    }
                    if (!SWCStringUtils.equals((String)name, (String)queryCalFrequency.getString("name"))) continue;
                    result.put(validatePkValue, nameErrorMsg);
                    continue block1;
                }
            }
        }
        return result;
    }
}

