/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.mservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.db.DB;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbs.mservice.api.IHSBSBizDataCodeService;

public class HSBSBizDataCodeService
implements IHSBSBizDataCodeService {
    private static final char UNDERLINE = '_';

    public List<String> getBizDataCodes(String codePrefix, int count) {
        if (count < 1 || SWCStringUtils.isEmpty((String)codePrefix)) {
            return Collections.EMPTY_LIST;
        }
        if (count == 1) {
            String globalLongId = String.valueOf(DB.genGlobalLongId());
            StringBuilder bizDataCode = new StringBuilder(codePrefix);
            bizDataCode.append('_').append(globalLongId);
            ArrayList<String> results = new ArrayList<String>(1);
            results.add(bizDataCode.toString());
            return results;
        }
        long[] globalLongIds = DB.genGlobalLongIds((int)count);
        List<String> bizDataCodes = Arrays.stream(globalLongIds).mapToObj(id -> codePrefix + '_' + id).collect(Collectors.toList());
        return bizDataCodes;
    }
}

