/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.mservice.update;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class CertDetailUpdateService
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(CertDetailUpdateService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        CertDetailUpdateService.tryCompleteCertSceneDetail();
        return new UpgradeResult();
    }

    public static void tryCompleteCertSceneDetail() {
        List<Long> certDetailPks = CertDetailUpdateService.getCertDetailId();
        List partitions = Lists.partition(certDetailPks, (int)5000);
        for (List partCertDetailIds : partitions) {
            Set<Long> certDetailPksOfExistScene = CertDetailUpdateService.getDetailIdOfExistScene(partCertDetailIds);
            List leftPks = ListUtils.removeAll((Collection)partCertDetailIds, certDetailPksOfExistScene);
            CertDetailUpdateService.insertSceneDetail(leftPks);
        }
    }

    @NotNull
    private static List<Long> getCertDetailId() {
        DataSet dataSet = DB.queryDataSet((String)"CertDetailUpdateService", (DBRoute)DBRoute.of((String)"swc"), (String)"select fid from t_hsbs_certdetail", (Object[])new Object[0]);
        Iterator iterator = dataSet.iterator();
        ArrayList certDetailPks = Lists.newArrayList();
        while (iterator.hasNext()) {
            certDetailPks.add(((Row)iterator.next()).getLong("fid"));
        }
        dataSet.close();
        return certDetailPks;
    }

    @NotNull
    private static Set<Long> getDetailIdOfExistScene(List<Long> partCertDetailIds) {
        ArrayList sepList = Lists.newArrayListWithExpectedSize((int)partCertDetailIds.size());
        partCertDetailIds.forEach(cert -> sepList.add("?"));
        DataSet dataSet = DB.queryDataSet((String)"CertDetailUpdateService", (DBRoute)DBRoute.of((String)"swc"), (String)("select fid,fcertdetailid,fscene from t_hsbs_certscenedetail where fcertdetailid in (" + StringUtils.join((Iterable)sepList, (String)",") + ")"), (Object[])partCertDetailIds.toArray());
        Iterator iterator = dataSet.iterator();
        HashSet certDetailPksOfExistScene = Sets.newHashSet();
        while (iterator.hasNext()) {
            certDetailPksOfExistScene.add(((Row)iterator.next()).getLong("fcertdetailid"));
        }
        dataSet.close();
        return certDetailPksOfExistScene;
    }

    private static void insertSceneDetail(List leftPks) {
        if (leftPks.isEmpty()) {
            return;
        }
        ArrayList params = Lists.newArrayListWithExpectedSize((int)leftPks.size());
        long[] pkIds = IDService.get().genLongIds(leftPks.size());
        for (int i = 0; i < leftPks.size(); ++i) {
            params.add(new Object[]{pkIds[i], leftPks.get(i), "payroll"});
        }
        DB.executeBatch((DBRoute)DBRoute.of((String)"swc"), (String)"insert into t_hsbs_certscenedetail(fid,fcertdetailid,fscene) values(?,?,?)", (List)params);
    }
}

