/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.mservice.update;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.bos.xdb.util.Pair;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.enums.PersonParamsEnum;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class FetchConfigUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(FetchConfigUpgradeService.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String querySql = "select item.fname itemname,item.funiquecode ftuniquecode,spitem.funiquecode spuniquecode, spitem.fname spitemname, config.frelationtype relationtype,config.frelationfieldid relationfieldid,config.frelationname relationname,config.fid id,entry.fentryid entryid,entry.ffetchitemid ftitemid,entry.fsupportitemid spitemid,entry.ffixedvalue fixedvalue,entry.ffilterfield filterfield,entry.fcondition entrycondition,entry.fvaluetype valuetype\n from t_hsbs_fetchconfig config left join t_hsbs_fetchfilterentry entry on config.fid = entry.fid \n left join t_hsbs_fetchitem item on entry.ffetchitemid =item.fid \n left join t_hsbs_supportitem spitem on entry.fsupportitemid = spitem.fid \n where config.fconditionlogictype =' ' and config.fconditionlogic = ' '";
        HashMap<Long, List<Map<String, Object>>> configEntryDataMap = new HashMap<Long, List<Map<String, Object>>>(16);
        HashMap<Long, String> configMainFilterMap = new HashMap<Long, String>(16);
        try (DataSet dateSet = SWCDbUtil.queryDataSet((String)"queryFetchConfigAndEntryData", (DBRoute)SWCConstants.SWC_ROUETE, (String)querySql, (Object[])new Object[0]);){
            while (dateSet.hasNext()) {
                Row row = dateSet.next();
                Long configId = row.getLong("id");
                List entryList = configEntryDataMap.computeIfAbsent(configId, value -> new ArrayList(10));
                HashMap<String, Object> entryMap = new HashMap<String, Object>(16);
                Long entryid = row.getLong("entryid");
                String relationtype = row.getString("relationtype");
                String relationfieldid = row.getString("relationfieldid");
                String relationname = row.getString("relationname");
                if (SWCStringUtils.isNotEmpty((String)relationtype) && SWCStringUtils.isNotEmpty((String)relationfieldid) && SWCStringUtils.isNotEmpty((String)relationname)) {
                    configMainFilterMap.put(configId, relationtype + '-' + relationfieldid + '-' + relationname);
                }
                if (entryid == null) continue;
                entryMap.put("entryid", entryid);
                entryMap.put("ftuniquecode", row.getString("ftuniquecode"));
                entryMap.put("ftitemname", row.getString("itemname"));
                entryMap.put("spuniquecode", row.getString("spuniquecode"));
                entryMap.put("spitemname", row.getString("spitemname"));
                entryMap.put("fixedvalue", row.get("fixedvalue"));
                entryMap.put("entrycondition", row.getString("entrycondition"));
                entryMap.put("valuetype", row.getString("valuetype"));
                entryMap.put("fieldid", row.getString("filterfield"));
                entryList.add(entryMap);
            }
        }
        ArrayList<Map<String, Object>> configDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> entryDataList = new ArrayList<Map<String, Object>>(10);
        ArrayList<Map<String, Object>> addEntryDataList = new ArrayList<Map<String, Object>>(10);
        this.assembleConfigAndEntryDataList(configDataList, entryDataList, addEntryDataList, configEntryDataMap, configMainFilterMap);
        List<Object[]> configParamList = this.assembleConfigParamList(configDataList);
        List<Object[]> entryParamList = this.assembleEntryParamList(entryDataList);
        List<Object[]> addEntryParamList = this.assembleAddEntryParamList(addEntryDataList);
        String configUpdateSql = "update t_hsbs_fetchconfig set fconditionlogic = ?,fconditionlogictype = ?,fmodifytime = ? where fid = ?";
        String entryUpdateSql = "update t_hsbs_fetchfilterentry set fconditionnumber =?,fcomparevaluetext =?,fcomparevalue =?,fvaluetype =?,fcondition =? where fentryid =?";
        String addEntryUpdateSql = "INSERT INTO t_hsbs_fetchfilterentry (fid, fentryid, ffieldname, fdatatype, fcondition, ffilterfield, fvaluetype, fconditionnumber, fcomparevalue, fcomparevaluetext) VALUES(?,?,?,?,?,?,?,?,?,?)";
        try (TXHandle txHandle = TX.required();){
            if (!SWCListUtils.isEmpty(configParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)configUpdateSql, configParamList);
            }
            if (!SWCListUtils.isEmpty(entryParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)entryUpdateSql, entryParamList);
            }
            if (!SWCListUtils.isEmpty(addEntryParamList)) {
                SWCDbUtil.executeBatch((DBRoute)SWCConstants.SWC_ROUETE, (String)addEntryUpdateSql, addEntryParamList);
            }
            log.info("FetchConfigUpgradeService end");
        }
        return null;
    }

    private List<Object[]> assembleAddEntryParamList(List<Map<String, Object>> addEntryDataList) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        if (SWCListUtils.isEmpty(addEntryDataList)) {
            return dataList;
        }
        for (Map<String, Object> entry : addEntryDataList) {
            Object value = entry.get("value");
            Object valuename = entry.get("valuename");
            Object condition = entry.get("condition");
            Object valuetype = entry.get("valuetype");
            Object conditionnumber = entry.get("conditionnumber");
            Object fieldname = entry.get("fieldname");
            Object datatype = entry.get("datatype");
            Object field = entry.get("field");
            Object entryid = entry.get("entryid");
            Object fid = entry.get("fid");
            Object[] updateParam = new Object[]{fid, entryid, fieldname, datatype, condition, field, valuetype, conditionnumber, value, valuename};
            dataList.add(updateParam);
        }
        return dataList;
    }

    private List<Object[]> assembleEntryParamList(List<Map<String, Object>> entryDataList) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        if (SWCListUtils.isEmpty(entryDataList)) {
            return dataList;
        }
        for (Map<String, Object> entry : entryDataList) {
            Object entryid = entry.get("entryid");
            Object value = entry.get("value");
            Object condition = entry.get("condition");
            Object valuetype = entry.get("valuetype");
            Object conditionnumber = entry.get("conditionnumber");
            Object valuename = entry.get("valuename");
            Object[] updateParam = new Object[]{conditionnumber, valuename, value, valuetype, condition, entryid};
            dataList.add(updateParam);
        }
        return dataList;
    }

    private List<Object[]> assembleConfigParamList(List<Map<String, Object>> configDataList) {
        ArrayList<Object[]> dataList = new ArrayList<Object[]>(10);
        if (SWCListUtils.isEmpty(configDataList)) {
            return dataList;
        }
        Date dateNow = new Date();
        for (Map<String, Object> config : configDataList) {
            Object id = config.get("id");
            Object conditionlogic = config.get("conditionlogic");
            Object conditionlogiccode = config.get("conditionlogiccode");
            Object[] updateParam = new Object[]{conditionlogiccode, conditionlogic, dateNow, id};
            dataList.add(updateParam);
        }
        return dataList;
    }

    private void assembleConfigAndEntryDataList(List<Map<String, Object>> configDataList, List<Map<String, Object>> entryDataList, List<Map<String, Object>> addEntryDataList, Map<Long, List<Map<String, Object>>> configEntryDataMap, Map<Long, String> configMainFilterMap) {
        HashMap<String, String> conditionMap = new HashMap<String, String>(16);
        conditionMap.put("0", "==");
        conditionMap.put("1", ">");
        conditionMap.put("2", ">=");
        conditionMap.put("3", "<");
        conditionMap.put("4", "<=");
        conditionMap.put("==", "==");
        conditionMap.put(">", ">");
        conditionMap.put(">=", ">=");
        conditionMap.put("<", "<");
        conditionMap.put("<=", "<=");
        HashMap<String, String> valueTypeMap = new HashMap<String, String>(16);
        valueTypeMap.put("0", "5");
        valueTypeMap.put("1", "3");
        valueTypeMap.put("2", "4");
        long[] entryIds = DB.genLongIds((String)"t_hsbs_fetchfilterentry", (int)(configEntryDataMap.size() * 2));
        int idIndex = 0;
        for (Map.Entry<Long, List<Map<String, Object>>> configEntry : configEntryDataMap.entrySet()) {
            HashMap<String, Object> configMap = new HashMap<String, Object>(3);
            Long configId = configEntry.getKey();
            configMap.put("id", configId);
            configMap.put("conditionlogic", "1");
            int index = 1;
            StringBuilder conditionLogicSb = new StringBuilder();
            String mainFilterStr = configMainFilterMap.get(configId);
            ArrayList<String> existFilterField = new ArrayList<String>(10);
            List<Map<String, Object>> entryList = configEntry.getValue();
            if (!SWCListUtils.isEmpty(entryList)) {
                for (Map<String, Object> entry : entryList) {
                    HashMap<String, Object> entryMap = new HashMap<String, Object>(16);
                    Pair<String, String> valuePair = this.assembleValue(entry);
                    existFilterField.add(entry.get("fieldid") + "");
                    entryMap.put("entryid", entry.get("entryid"));
                    entryMap.put("value", valuePair.getKey());
                    entryMap.put("valuename", valuePair.getValue());
                    String entryCondition = (String)conditionMap.get(entry.get("entrycondition"));
                    if (SWCStringUtils.isEmpty((String)entryCondition)) continue;
                    entryMap.put("condition", entryCondition);
                    String valueType = (String)valueTypeMap.get(entry.get("valuetype"));
                    if (SWCStringUtils.isEmpty((String)valueType)) continue;
                    String conditionNumber = this.assembleConditionNumber(index++);
                    entryMap.put("valuetype", valueType);
                    entryMap.put("conditionnumber", conditionNumber);
                    if (conditionLogicSb.length() > 0) {
                        conditionLogicSb.append(" and ");
                    }
                    conditionLogicSb.append(conditionNumber);
                    entryDataList.add(entryMap);
                }
            }
            if (SWCStringUtils.isNotEmpty((String)mainFilterStr)) {
                String[] splits = mainFilterStr.split("-");
                String mainFilterType = splits[0];
                String mainFilterField = splits[1];
                String mainFilterName = splits[2];
                if (!existFilterField.contains(mainFilterField)) {
                    HashMap<String, Object> mainEntryMap = new HashMap<String, Object>(16);
                    String mainConditionNumber = this.assembleConditionNumber(index++);
                    Pair<String, String> pair = this.assembleFieldName(mainFilterType);
                    mainEntryMap.put("fieldname", mainFilterName);
                    mainEntryMap.put("datatype", "Id");
                    mainEntryMap.put("condition", "==");
                    mainEntryMap.put("field", mainFilterField);
                    mainEntryMap.put("valuetype", SWCStringUtils.equals((String)mainFilterType, (String)"3") ? "2" : "1");
                    mainEntryMap.put("value", pair.getValue());
                    mainEntryMap.put("valuename", pair.getKey());
                    mainEntryMap.put("conditionnumber", mainConditionNumber);
                    mainEntryMap.put("fid", configId);
                    mainEntryMap.put("entryid", entryIds[idIndex++]);
                    if (conditionLogicSb.length() > 0) {
                        conditionLogicSb.append(" and ");
                    }
                    conditionLogicSb.append(mainConditionNumber);
                    addEntryDataList.add(mainEntryMap);
                }
            }
            configMap.put("conditionlogiccode", conditionLogicSb.toString());
            configDataList.add(configMap);
        }
    }

    private Pair<String, String> assembleFieldName(String mainFilterType) {
        String fieldName = "";
        String fieldValue = "";
        switch (mainFilterType) {
            case "0": {
                fieldName = PersonParamsEnum.PARAM_CALPERSON.getDesc();
                fieldValue = PersonParamsEnum.PARAM_CALPERSON.getCode();
                break;
            }
            case "1": {
                fieldName = PersonParamsEnum.PARAM_SALARYFILE.getDesc();
                fieldValue = PersonParamsEnum.PARAM_SALARYFILE.getCode();
                break;
            }
            case "2": {
                fieldName = PersonParamsEnum.PARAM_ERPPEROSN.getDesc();
                fieldValue = PersonParamsEnum.PARAM_ERPPEROSN.getCode();
                break;
            }
            case "3": {
                fieldName = PersonParamsEnum.PARAM_TASK.getDesc();
                fieldValue = PersonParamsEnum.PARAM_TASK.getCode();
                break;
            }
        }
        return new Pair((Object)fieldName, (Object)fieldValue);
    }

    private String assembleConditionNumber(int numberIndex) {
        String indexStr = numberIndex < 10 ? "0" + numberIndex : numberIndex + "";
        return "T" + indexStr;
    }

    private Pair<String, String> assembleValue(Map<String, Object> entry) {
        String valueType = entry.get("valuetype") + "";
        String value = null;
        String valueText = null;
        switch (valueType) {
            case "0": {
                value = entry.get("spuniquecode") + "";
                valueText = entry.get("spitemname") + "";
                break;
            }
            case "1": {
                value = entry.get("fixedvalue") + "";
                valueText = entry.get("fixedvalue") + "";
                break;
            }
            case "2": {
                value = entry.get("ftuniquecode") + "";
                valueText = entry.get("ftitemname") + "";
                break;
            }
        }
        return new Pair(value, valueText);
    }
}

