/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.mservice.update;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class TaxSwitchUpgradeService
implements IUpgradeService {
    private static final Log log = LogFactory.getLog(TaxSwitchUpgradeService.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String sql = "select fdata from t_hsbs_salaryparam where fparamcfgid = 1108511190553756672";
        DataSet dateSet = SWCDbUtil.queryDataSet((String)"querySWCTaxSwitch", (DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[0]);
        String paramData = "";
        JSONObject countryJsonObj = new JSONObject();
        while (dateSet.hasNext()) {
            JSONObject paramObj;
            Row salaryParamRow = dateSet.next();
            paramData = salaryParamRow.getString("fdata");
            if (SWCStringUtils.isEmpty((String)paramData) || (paramObj = JSONObject.parseObject((String)paramData)).containsKey((Object)"countryInfo")) continue;
            boolean enableTaxCal = paramObj.getBooleanValue("enableTaxCal");
            sql = "select fcountryid,fmodifierid,fmodifytime from t_sitbs_appcountryrel where fenable = '1'";
            DataSet countryDataSet = SWCDbUtil.queryDataSet((String)"querySITCountry", (DBRoute)new DBRoute("sit"), (String)sql, (Object[])new Object[0]);
            HashMap countryInfoMap = new HashMap(16);
            while (countryDataSet.hasNext()) {
                Row row = countryDataSet.next();
                Long countryId = row.getLong("fcountryid");
                Long l = row.getLong("fmodifierid");
                Date modifyTime = row.getDate("fmodifytime");
                HashMap<String, Comparable<Long>> countryMap = new HashMap<String, Comparable<Long>>(2);
                countryMap.put("modifyId", l);
                countryMap.put("modifyTime", modifyTime);
                countryInfoMap.put(countryId, countryMap);
            }
            countryDataSet.close();
            if (countryInfoMap == null || countryInfoMap.size() == 0) continue;
            ArrayList countryIdList = new ArrayList(countryInfoMap.size());
            for (Map.Entry entry : countryInfoMap.entrySet()) {
                countryIdList.add(entry.getKey());
            }
            int size = countryIdList.size();
            StringBuilder stringBuilder = new StringBuilder("select fid,fname,fnumber from t_bd_country where fid in (");
            for (int i = 0; i < size; ++i) {
                stringBuilder.append(countryIdList.get(i));
                if (i == size - 1) continue;
                stringBuilder.append(',');
            }
            stringBuilder.append(')');
            DataSet sysCountrySet = SWCDbUtil.queryDataSet((String)"querySYSCountry", (DBRoute)new DBRoute("sys"), (String)stringBuilder.toString(), (Object[])new Object[0]);
            while (sysCountrySet.hasNext()) {
                Row row = sysCountrySet.next();
                Long countryId = row.getLong("fid");
                Map countryMap = (Map)countryInfoMap.get(countryId);
                if (countryMap == null || countryMap.size() == 0) continue;
                String countryName = row.getString("fname");
                countryMap.put("countryName", countryName);
                String countryNumber = row.getString("fnumber");
                countryMap.put("countryNumber", countryNumber);
            }
            sysCountrySet.close();
            JSONArray retArray = new JSONArray();
            for (Map.Entry entry : countryInfoMap.entrySet()) {
                Long countryId = (Long)entry.getKey();
                Map countryMap = (Map)entry.getValue();
                JSONObject retObj = new JSONObject();
                retObj.put("countryNumber", countryMap.get("countryNumber"));
                retObj.put("taxCalModel", (Object)"0");
                Date modifyTime = (Date)countryMap.get("modifyTime");
                if (modifyTime != null) {
                    retObj.put("operateTime", (Object)SWCDateTimeUtils.format((Date)modifyTime, (String)"yyyy-MM-dd HH:mm:ss"));
                }
                retObj.put("countryName", countryMap.get("countryName"));
                retObj.put("enableTaxCal", (Object)enableTaxCal);
                retObj.put("operatorId", countryMap.get("modifyId"));
                retObj.put("countryId", (Object)countryId);
                retArray.add((Object)retObj);
            }
            countryJsonObj.put("countryInfo", (Object)retArray);
            sql = "update t_hsbs_salaryparam set fdata = ? where fparamcfgid = 1108511190553756672";
            SWCDbUtil.update((DBRoute)SWCConstants.SWC_ROUETE, (String)sql, (Object[])new Object[]{countryJsonObj.toJSONString()});
            log.info("update t_hsbs_salaryparam success");
        }
        dateSet.close();
        return null;
    }
}

