/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.lang.Lang;
import kd.swc.hsbp.business.taxservice.TaxCalServiceHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.salaryitem.SalaryItemHelper;
import kd.swc.hsbs.business.statistictag.StatisticsTagHelper;

public class SalaryItemSaveValidator
extends SWCDataBaseValidator {
    private static final String DATALENGTH_ZERO = "0";
    private static final String FIELD_AREATYPE_GENERAL = "1";
    private static final String FIELD_AREATYPE_ASSIGN = "2";
    public static final String IMPORT_TYPE_OVERRIDE = "override";
    public static final String IMPORT_TYPE_OVERRIDENEW = "overridenew";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            this.importValidate(dataEntities);
        }
    }

    private void checkAreaTypeAndCountry(ExtendedDataEntity dataEntity) {
        String errorMsg;
        DynamicObject obj = dataEntity.getDataEntity();
        String areatype = obj.getString("areatype");
        if (SWCStringUtils.isEmpty((String)areatype)) {
            String errorMsg2 = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"SalaryItemSaveValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg2, obj.getString("name")));
        }
        long countryId = obj.getLong("country.id");
        if (SWCStringUtils.endsWithIgnoreCase((String)FIELD_AREATYPE_ASSIGN, (String)areatype) && 0L == countryId) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"SalaryItemSaveValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, obj.getString("name")));
        }
        if (SWCStringUtils.endsWithIgnoreCase((String)FIELD_AREATYPE_GENERAL, (String)areatype) && 0L != countryId) {
            errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"SalaryItemSaveValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, obj.getString("name")));
        }
    }

    private void checkAndDealData(ExtendedDataEntity dataEntity, Map<String, ExtendedDataEntity> nameMap, Boolean taxCalEnableStatus, boolean isImport) {
        String number;
        String msg;
        String name;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        nameMap.put(dynamicObject.getString("name"), dataEntity);
        DynamicObject dataTypeData = dynamicObject.getDynamicObject("datatype");
        long dataTypeId = dataTypeData.getLong("id");
        DynamicObject dataPrecisionData = dynamicObject.getDynamicObject("dataprecision");
        DynamicObject dataRoundData = dynamicObject.getDynamicObject("dataround");
        String dataLength = dynamicObject.getString("datalength");
        if (1030L == dataTypeId) {
            if (dataLength == null || DATALENGTH_ZERO.equals(dataLength)) {
                String msg2 = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u65f6\uff0c\u6570\u636e\u957f\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u4e0d\u80fd\u4e3a0\u3002", (String)"SalaryItemSaveValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, msg2);
            }
            dynamicObject.set("dataprecision", null);
            dynamicObject.set("dataround", null);
        } else if (1010L == dataTypeId || 1020L == dataTypeId) {
            String string = name = 1010L == dataTypeId ? ResManager.loadKDString((String)"\u6570\u503c", (String)"SalaryItemSaveValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u91d1\u989d", (String)"SalaryItemSaveValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            if (1010L == dataTypeId) {
                if (isImport && dataPrecisionData == null) {
                    dynamicObject.set("dataprecision", (Object)1030L);
                } else if (!isImport && dataPrecisionData == null) {
                    msg = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a{0}\u65f6\uff0c\u6570\u636e\u7cbe\u5ea6\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryItemSaveValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[]{name});
                    this.addErrorMessage(dataEntity, msg);
                }
            }
            if (1020L == dataTypeId) {
                dynamicObject.set("dataprecision", null);
            }
            if (isImport && dataRoundData == null) {
                dynamicObject.set("dataround", (Object)1010L);
            }
            if (dataRoundData == null && !isImport) {
                msg = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a{0}\u65f6\uff0c\u7cbe\u5ea6\u5c3e\u5dee\u5904\u7406\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SalaryItemSaveValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[]{name});
                this.addErrorMessage(dataEntity, msg);
            }
        } else if (1040L == dataTypeId || 1050L == dataTypeId || 1060L == dataTypeId) {
            if (1040L != dataTypeId) {
                dynamicObject.set("datalength", null);
            }
            dynamicObject.set("dataprecision", null);
            dynamicObject.set("dataround", null);
        }
        this.checkTagAndPayoutInfo(dataEntity, dynamicObject, dataTypeId);
        name = dynamicObject.getString("name");
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name)) {
            msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"SalaryItemSaveValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"SalaryItemSaveValidator_28", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg);
        }
        if (StringCheckUtils.checkNumberIsContainJavaVariableForbidChar((String)(number = dynamicObject.getString("number")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u548c\u7279\u6b8a\u5b57\u7b26", (String)"SalaryItemSaveValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
        if (taxCalEnableStatus.booleanValue()) {
            String isPayOutItem = dynamicObject.getString("ispayoutitem");
            String taxTag = dynamicObject.getString("taxtag");
            if (SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)taxTag) && !SWCStringUtils.equals((String)DATALENGTH_ZERO, (String)isPayOutItem)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u4e2a\u7a0e\u6807\u7b7e\u4e3a\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u65f6\uff0c\u5b9e\u53d1\u9879\u76ee\u53ea\u80fd\u4e3a\u5426\u3002", (String)"SalaryItemSaveValidator_20", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
        } else {
            String taxTag = dynamicObject.getString("taxtag");
            if (!SWCStringUtils.equals((String)DATALENGTH_ZERO, (String)taxTag)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u7a0e\u670d\u52a1\u5f00\u5173\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u4f7f\u7528\u4e2a\u7a0e\u6807\u7b7e\u529f\u80fd\u3002", (String)"SalaryItemSaveValidator_23", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private void checkTagAndPayoutInfo(ExtendedDataEntity dataEntity, DynamicObject dynamicObject, long dataTypeId) {
        String ispayoutitem = dynamicObject.getString("ispayoutitem");
        if (SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)ispayoutitem) && 1020L != dataTypeId) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u82e5\u4e3a\u5b9e\u53d1\u9879\u76ee\uff0c\u6570\u636e\u7c7b\u578b\u5e94\u4e3a\u91d1\u989d\u578b\u3002", (String)"SalaryItemSaveValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void importValidate(ExtendedDataEntity[] dataEntities) {
        HashMap<String, ExtendedDataEntity> nameMap = new HashMap<String, ExtendedDataEntity>();
        if (this.getOption().containsVariable("importtype")) {
            String importType = this.getOption().getVariableValue("importtype");
            if (SWCStringUtils.equals((String)IMPORT_TYPE_OVERRIDE, (String)importType) || SWCStringUtils.equals((String)IMPORT_TYPE_OVERRIDENEW, (String)importType)) {
                this.checkImportData(dataEntities, nameMap);
            } else {
                this.checkDataEntity(dataEntities, nameMap, true);
            }
        } else {
            this.checkDataEntity(dataEntities, nameMap, false);
        }
    }

    private void checkDataEntity(ExtendedDataEntity[] dataEntities, Map<String, ExtendedDataEntity> nameMap, boolean isImport) {
        Set effectiveTagLevelIdSet = StatisticsTagHelper.getEffectiveTagLevelIdSet();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            Boolean taxCalEnableStatus = this.getTaxCalEnableStatus(dataEntity);
            this.checkAndDealData(dataEntity, nameMap, taxCalEnableStatus, isImport);
            this.checkAreaTypeAndCountry(dataEntity);
            this.checkStatisticsTag(dataEntity, effectiveTagLevelIdSet);
        }
    }

    private Boolean getTaxCalEnableStatus(ExtendedDataEntity dataEntity) {
        DynamicObject dataObj = dataEntity.getDataEntity();
        String areaType = dataObj.getString("areatype");
        if (SWCStringUtils.isEmpty((String)areaType) || SWCStringUtils.equals((String)areaType, (String)FIELD_AREATYPE_GENERAL)) {
            return Boolean.FALSE;
        }
        if (SWCStringUtils.equals((String)areaType, (String)FIELD_AREATYPE_ASSIGN)) {
            DynamicObject countryObj = dataObj.getDynamicObject("country");
            if (SWCObjectUtils.isEmpty((Object)countryObj)) {
                return Boolean.FALSE;
            }
            long countryId = countryObj.getLong("id");
            return TaxCalServiceHelper.getTaxCalEnableStatusByCountryId((long)countryId);
        }
        return Boolean.FALSE;
    }

    private void checkImportData(ExtendedDataEntity[] dataEntities, Map<String, ExtendedDataEntity> nameMap) {
        Set numbers = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getString("number")).collect(Collectors.toSet());
        SalaryItemHelper salaryItemHelper = new SalaryItemHelper();
        DynamicObject[] salaryItemData = salaryItemHelper.getSalaryItemData(numbers);
        Map<String, DynamicObject> salaryItemMap = Arrays.stream(salaryItemData).collect(Collectors.toMap(key -> key.getString("number"), value -> value));
        Set effectiveTagLevelIdSet = StatisticsTagHelper.getEffectiveTagLevelIdSet();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String errorMsg;
            DynamicObject dataEntityObj = dataEntity.getDataEntity();
            if (dataEntityObj == null) continue;
            Boolean taxCalEnableStatus = this.getTaxCalEnableStatus(dataEntity);
            this.checkAndDealData(dataEntity, nameMap, taxCalEnableStatus, true);
            this.checkAreaTypeAndCountry(dataEntity);
            String number = dataEntityObj.getString("number");
            DynamicObject dynamicObject = salaryItemMap.get(number);
            if (dynamicObject == null) continue;
            String status = dynamicObject.getString("status");
            String enable = dynamicObject.getString("enable");
            String taxTagOld = dynamicObject.getString("taxtag");
            String calBlockOld = dynamicObject.getString("calblock");
            String taxTag = dataEntityObj.getString("taxtag");
            String calBlock = dataEntityObj.getString("calblock");
            if (!(!SWCStringUtils.equals((String)"A", (String)status) || !SWCStringUtils.equals((String)"10", (String)enable) || taxCalEnableStatus.booleanValue() || SWCStringUtils.equals((String)taxTagOld, (String)taxTag) && SWCStringUtils.equals((String)calBlockOld, (String)calBlock))) {
                errorMsg = ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e2a\u7a0e\u4e91\u8ba1\u7b97\u670d\u52a1\uff0c\u65e0\u6cd5\u4fee\u6539\u4e2a\u7a0e\u76f8\u5173\u5b57\u6bb5\u3002", (String)"SalaryItemSaveValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            if (SWCStringUtils.equals((String)"A", (String)status) && SWCStringUtils.equals((String)FIELD_AREATYPE_GENERAL, (String)enable) && (!SWCStringUtils.equals((String)taxTagOld, (String)taxTag) || !SWCStringUtils.equals((String)calBlockOld, (String)calBlock))) {
                errorMsg = null;
                errorMsg = taxCalEnableStatus != false ? ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u4e2a\u7a0e\u76f8\u5173\u5b57\u6bb5\u3002", (String)"SalaryItemSaveValidator_19", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u672a\u542f\u7528\u4e2a\u7a0e\u4e91\u8ba1\u7b97\u670d\u52a1\uff0c\u65e0\u6cd5\u4fee\u6539\u4e2a\u7a0e\u76f8\u5173\u5b57\u6bb5\u3002", (String)"SalaryItemSaveValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            if (taxCalEnableStatus.booleanValue()) {
                String isPayOutItem = dataEntityObj.getString("ispayoutitem");
                if (SWCStringUtils.equals((String)FIELD_AREATYPE_ASSIGN, (String)taxTag) && !SWCStringUtils.equals((String)DATALENGTH_ZERO, (String)isPayOutItem)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u4e2a\u7a0e\u6807\u7b7e\u4e3a\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u65f6\uff0c\u5b9e\u53d1\u9879\u76ee\u53ea\u80fd\u4e3a\u5426\u3002", (String)"SalaryItemSaveValidator_20", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                }
            } else if (!SWCStringUtils.equals((String)DATALENGTH_ZERO, (String)taxTag)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e2a\u7a0e\u670d\u52a1\u5f00\u5173\u672a\u5f00\u542f\uff0c\u65e0\u6cd5\u4f7f\u7528\u4e2a\u7a0e\u6807\u7b7e\u529f\u80fd\u3002", (String)"SalaryItemSaveValidator_23", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
            this.checkStatisticsTag(dataEntity, effectiveTagLevelIdSet);
        }
    }

    private void checkStatisticsTag(ExtendedDataEntity dataEntity, Set<Long> effectiveTagLevelIdSet) {
        DynamicObject statisticsTag = dataEntity.getDataEntity().getDynamicObject("statisticstag");
        if (statisticsTag != null) {
            String areaType = statisticsTag.getString("areatype");
            DynamicObject country = statisticsTag.getDynamicObject("country");
            DynamicObject salaryItemCountry = dataEntity.getDataEntity().getDynamicObject("country");
            if (FIELD_AREATYPE_ASSIGN.equals(areaType) && salaryItemCountry != null && country.getLong("id") != salaryItemCountry.getLong("id")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u7edf\u8ba1\u7c7b\u522b\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u85aa\u916c\u9879\u76ee\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"SalaryItemSaveValidator_26", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
            if (effectiveTagLevelIdSet != null && !effectiveTagLevelIdSet.contains(statisticsTag.getLong("taglevel.id"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u85aa\u916c\u9879\u76ee\u7edf\u8ba1\u7c7b\u522b\u4e0d\u5728\u7528\u6237\u6743\u9650\u5185\uff0c\u8bf7\u68c0\u67e5\u6743\u9650\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"SalaryItemSaveValidator_27", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

