/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.lang.Lang;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class StandardItemSaveValidator
extends SWCDataBaseValidator {
    private static final String BIZTYPE_2 = "2";
    private static final String BIZTYPE_3 = "3";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": 
            case "submit": {
                HashMap<String, ExtendedDataEntity> nameMap = new HashMap<String, ExtendedDataEntity>();
                for (ExtendedDataEntity dataEntity : dataEntities) {
                    this.validateData(dataEntity, nameMap);
                    DynamicObject dbObj = dataEntity.getDataEntity();
                    this.validateCountryInfo(dataEntity, dbObj);
                    this.validateFixedItem(dataEntity, dbObj);
                }
                break;
            }
        }
    }

    private void validateCountryInfo(ExtendedDataEntity dataEntity, DynamicObject dbObj) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String areatype = dynamicObject.getString("areatype");
        DynamicObject country = dynamicObject.getDynamicObject("country");
        long calFrequencyId = dynamicObject.getLong("calfrequency.id");
        if (!(dbObj == null || SWCStringUtils.isEmpty((String)dbObj.getString("areatype")) && SWCObjectUtils.isEmpty((Object)dbObj.getDynamicObject("country")) || SWCStringUtils.equals((String)areatype, (String)dbObj.getString("areatype")) && SWCObjectUtils.equals((Object)country, (Object)dbObj.getDynamicObject("country")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u80fd\u4fee\u6539\u201c\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u201d\u3001\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u3002", (String)"StandardItemSaveValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (SWCStringUtils.equals((String)areatype, (String)"1")) {
            if (SWCObjectUtils.isEmpty((Object)country)) {
                return;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u201c\u901a\u7528\u201d\u65f6\u4e0d\u5141\u8bb8\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u4fe1\u606f\u3002", (String)"StandardItemSaveValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        } else if (SWCObjectUtils.isEmpty((Object)country)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u201c\u6307\u5b9a\u201d\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e3a\u5fc5\u5f55\u4fe1\u606f\uff0c\u8bf7\u5f55\u5165\u56fd\u5bb6/\u5730\u533a\u3002", (String)"StandardItemSaveValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private void validateData(ExtendedDataEntity dataEntity, Map<String, ExtendedDataEntity> nameMap) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String name = dynamicObject.getString("name");
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name)) {
            String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"SalaryItemSaveValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"SalaryItemSaveValidator_28", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg);
        }
    }

    private void validateFixedItem(ExtendedDataEntity dataEntity, DynamicObject dbObj) {
        Set dbBizTypes;
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        String enable = dynamicObject.getString("enable");
        String biztype = dynamicObject.getString("biztype");
        Set bizTypes = Arrays.stream(biztype.split(",")).filter(type -> SWCStringUtils.isNotEmpty((String)type)).collect(Collectors.toSet());
        String fixeditem = dynamicObject.getString("fixeditem");
        if (!(SWCStringUtils.equals((String)enable, (String)"10") || bizTypes.equals(dbBizTypes = Arrays.stream(dbObj.getString("biztype").split(",")).filter(type -> SWCStringUtils.isNotEmpty((String)type)).collect(Collectors.toSet())) && SWCStringUtils.equals((String)fixeditem, (String)dbObj.getString("fixeditem")))) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4fee\u6539\u5f85\u542f\u7528\u6570\u636e\u7684\u201c\u9002\u7528\u4e1a\u52a1\u7c7b\u578b\u201d\u548c\u201c\u56fa\u5b9a\u9879\u76ee\u201d\u5b57\u6bb5\u3002", (String)"StandardItemSaveValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (bizTypes.size() == 1 && bizTypes.contains(BIZTYPE_2) || bizTypes.size() == 1 && bizTypes.contains(BIZTYPE_3)) {
            dynamicObject.set("fixeditem", null);
        } else if (SWCStringUtils.isEmpty((String)fixeditem)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9002\u7528\u4e1a\u52a1\u7c7b\u578b\u4e3a\u201c\u85aa\u916c\u7ba1\u7406\u201d\u65f6\uff0c\u56fa\u5b9a\u9879\u76ee\u4e3a\u5fc5\u5f55\u4fe1\u606f\uff0c\u8bf7\u5f55\u5165\u56fa\u5b9a\u9879\u76ee\u3002", (String)"StandardItemSaveValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }
}

