/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.attbizitem;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCNumberValidateUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.common.enums.DataTypeEnum;

public class AttBizItemValidator
extends SWCDataBaseValidator {
    public final Log log = LogFactory.getLog(AttBizItemValidator.class);

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, DynamicObject> allDataMap = null;
        switch (operateKey) {
            case "save": {
                allDataMap = this.getAllDataMap(dataEntities);
                this.saveValidator(allDataMap);
                this.checkImportData(allDataMap);
                break;
            }
            case "submit": {
                allDataMap = this.getAllDataMap(dataEntities);
                this.saveValidator(allDataMap);
                break;
            }
            case "delete": {
                this.deleteValidator(dataEntities);
                break;
            }
        }
    }

    private void checkImportData(Map<Long, DynamicObject> allDataMap) {
        ExtendedDataEntity[] dataEntities;
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        if (StringUtils.equals((CharSequence)isSave, (CharSequence)Boolean.TRUE.toString())) {
            return;
        }
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            this.checkAreaType(allDataMap.get(data.getLong("id")), data, dataEntity);
            this.checkImportVal(allDataMap.get(data.getLong("id")), data, dataEntity);
        }
    }

    private void checkImportVal(DynamicObject oldData, DynamicObject data, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection mutiCurrencyColl;
        int dataLength;
        long dataTypeId = data.getLong("datatype.id");
        if (dataTypeId != 1030L && (dataLength = data.getInt("datalength")) != 0) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6587\u672c\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u6570\u636e\u957f\u5ea6\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_62", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
        if (dataTypeId != 1010L) {
            String maxValue = data.getString("inputmaxval");
            String minValue = data.getString("inputminval");
            String scaleLimit = data.getString("scalelimit");
            if (SWCStringUtils.isNotEmpty((String)maxValue) || SWCStringUtils.isNotEmpty((String)minValue) || SWCStringUtils.isNotEmpty((String)scaleLimit)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6570\u503c\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u5c0f/\u6700\u5927\u503c\u548c\u5c0f\u6570\u4f4d\u6570\u9650\u5236\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_61", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
        if (dataTypeId != 1050L) {
            Date earliesDate = data.getDate("earliestdate");
            Date lastDate = data.getDate("lastdate");
            if (earliesDate != null || lastDate != null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u65e5\u671f\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u65e9/\u6700\u665a\u65e5\u671f\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_60", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
        if (dataTypeId != 1020L && (mutiCurrencyColl = data.getDynamicObjectCollection("currency")) != null && mutiCurrencyColl.size() > 0) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u91d1\u989d\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u53ef\u8f93\u5165\u5e01\u79cd\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_37", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void checkParam(DynamicObject data, ExtendedDataEntity dataEntity) {
        long dataTypeId = data.getLong("datatype.id");
        String consumeMethod = data.getString("consumemethod");
        if (SWCStringUtils.isEmpty((String)consumeMethod)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u5fc5\u586b\u3002", (String)"BizItemValidator_17", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            return;
        }
        if (dataTypeId == 1010L || dataTypeId == 1020L) {
            if (!SWCStringUtils.equals((String)consumeMethod, (String)"5")) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u3001\u91d1\u989d\u65f6\uff0c\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u6c47\u603b\u3002", (String)"AttBizItemValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        } else if (!SWCStringUtils.equals((String)consumeMethod, (String)"1") && !SWCStringUtils.equals((String)consumeMethod, (String)"2")) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u3001\u65e5\u671f\u65f6\uff0c\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u6700\u65b0\u3001\u6700\u65e9\u3002", (String)"BizItemValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void saveValidator(Map<Long, DynamicObject> allDataMap) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (!this.checkEnabledModify(dataEntity, allDataMap)) continue;
            this.checkData(data, dataEntity);
            this.checkParam(data, dataEntity);
            if (!StringCheckUtils.checkNameIsContainSpecialChar((String)data.getString("name"))) continue;
            String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c\u3010\u201d\u3001\u201c\u3011\u201d\u3001\u201c]\u201d\u3002", (String)"BizItemValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"BizItemValidator_63", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
        }
    }

    private void checkData(DynamicObject data, ExtendedDataEntity dataEntity) {
        long dataTypeId = data.getLong("datatype.id");
        if (dataTypeId == 0L) {
            return;
        }
        if (dataTypeId == DataTypeEnum.TEXT.getCode()) {
            Integer dataLength = (Integer)data.get("datalength");
            if (dataLength == null || dataLength <= 0 || dataLength > 255) {
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u65f6\uff0c\u6570\u636e\u957f\u5ea6\u7684\u6570\u503c\u8303\u56f4\u4e3a(0,255]\u3002", (String)"BizItemValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
        } else if (dataTypeId == DataTypeEnum.DATE.getCode()) {
            Date earliestDate = data.getDate("earliestdate");
            Date lastDate = data.getDate("lastdate");
            if (earliestDate != null && lastDate != null && lastDate.before(earliestDate)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u665a\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6700\u65e9\u65e5\u671f\u3002", (String)"BizItemValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        } else if (dataTypeId == DataTypeEnum.NUMBERIC.getCode()) {
            if (!this.checkMaxValueAndMinValueIsNumeric(data, dataEntity)) {
                return;
            }
            String maxValue = data.getString("inputmaxval");
            String minValue = data.getString("inputminval");
            String regx1 = "-0(\\.0*)?";
            String regx2 = "^([+,-])?(([1-9]{1}\\d{0,12})|(0{1}))(\\.\\d{0,10})?$";
            if (!(maxValue.isEmpty() || !maxValue.matches(regx1) && maxValue.matches(regx2))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002\u6574\u6570\u90e8\u5206\u6700\u5927\u4e3a13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u6700\u5927\u4e3a10\u4f4d\u3002", (String)"AttBizItemValidator_9", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                return;
            }
            if (!(minValue.isEmpty() || !minValue.matches(regx1) && minValue.matches(regx2))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002\u6574\u6570\u90e8\u5206\u6700\u5927\u4e3a13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u6700\u5927\u4e3a10\u4f4d\u3002", (String)"AttBizItemValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                return;
            }
            String scaleLimit = data.getString("scalelimit");
            if (!SWCStringUtils.isEmpty((String)scaleLimit)) {
                int maxValueScale;
                int minValueScale;
                int scaleLimitVal = Integer.parseInt(scaleLimit);
                if (!SWCStringUtils.isEmpty((String)minValue) && (minValueScale = new BigDecimal(minValue).scale()) > scaleLimitVal) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemValidator_24", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                    return;
                }
                if (!SWCStringUtils.isEmpty((String)maxValue) && (maxValueScale = new BigDecimal(maxValue).scale()) > scaleLimitVal) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemValidator_25", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                    return;
                }
            } else {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u201c\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u201d\u5fc5\u586b\u3002", (String)"BizItemValidator_27", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                return;
            }
            if (!maxValue.isEmpty() && !minValue.isEmpty() && new BigDecimal(maxValue).compareTo(new BigDecimal(minValue)) < 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u53ef\u5c0f\u4e8e\u6700\u5c0f\u8f93\u5165\u503c\u3002", (String)"BizItemValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                return;
            }
            if (SWCStringUtils.isNotEmpty((String)minValue)) {
                try {
                    BigDecimal minVal = new BigDecimal(minValue);
                    data.set("isminvalnull", (Object)"0");
                    data.set("minvalue", (Object)minVal);
                }
                catch (Exception e) {
                    this.log.info("transfer minVal fail!");
                }
            }
            if (SWCStringUtils.isNotEmpty((String)maxValue)) {
                try {
                    BigDecimal maxVal = new BigDecimal(maxValue);
                    data.set("ismaxvalnull", (Object)"0");
                    data.set("maxvalue", (Object)maxVal);
                }
                catch (Exception e) {
                    this.log.info("transfer maxVal fail!");
                }
            }
        }
    }

    private void checkAreaType(DynamicObject oldData, DynamicObject data, ExtendedDataEntity dataEntity) {
        if (oldData != null && !SWCStringUtils.equals((String)data.getString("areatype"), (String)oldData.getString("areatype"))) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u3002", (String)"BizItemValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return;
        }
        if (oldData != null && data.getLong("country.id") != oldData.getLong("country.id")) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u56fd\u5bb6/\u5730\u533a\u3002", (String)"BizItemValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return;
        }
        if ("2".equals(data.getString("areatype"))) {
            if (data.getDynamicObject("country") == null || data.getLong("country.id") == 0L) {
                String errorMsg = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BizItemValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return;
            }
        } else if (data.getDynamicObject("country") != null && data.getLong("country.id") != 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e0d\u53ef\u5f55\u5165\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_58", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return;
        }
    }

    private Map<Long, DynamicObject> getAllDataMap(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        List dataIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_attbizitem");
        QFilter filter = new QFilter("id", "in", dataIdList);
        filter.and("enable", "in", (Object)new String[]{"1", "10"});
        DynamicObject[] unabledChangeDataArray = helper.query("id,classification,datatype.id,areatype,country.id,enable,datalength,createorg.id,number,attitemtype,ctrlstrategy,consumemethod", new QFilter[]{filter});
        if (unabledChangeDataArray == null || unabledChangeDataArray.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(unabledChangeDataArray).collect(Collectors.toMap(unabledChangeData -> unabledChangeData.getLong("id"), unabledChangeData -> unabledChangeData));
    }

    private boolean checkEnabledModify(ExtendedDataEntity dataEntity, Map<Long, DynamicObject> allDataMap) {
        DynamicObject data = dataEntity.getDataEntity();
        long dataId = data.getLong("id");
        boolean tag = true;
        if (!allDataMap.containsKey(dataId) || SWCStringUtils.equals((String)"10", (String)data.getString("enable"))) {
            return tag;
        }
        DynamicObject oldData = allDataMap.get(dataId);
        if (!SWCStringUtils.equals((String)"1", (String)oldData.getString("classification"))) {
            String errorMsg = ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u4e3a\u201c\u4e1a\u52a1\u9879\u76ee\u201d\uff0c\u4e0d\u53ef\u5728\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u5217\u8868\u9875\u9762\u66f4\u65b0\u3002", (String)"AttBizItemValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (data.getLong("datatype.id") != oldData.getLong("datatype.id")) {
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u201c\u6570\u636e\u7c7b\u578b\u201d\u3002", (String)"BizItemValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (data.getInt("datalength") != oldData.getInt("datalength")) {
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u201c\u6570\u636e\u957f\u5ea6\u201d\u3002", (String)"BizItemValidator_50", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (data.getLong("createorg.id") != oldData.getLong("createorg.id")) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"AttBizItemValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (!SWCStringUtils.equals((String)data.getString("consumemethod"), (String)oldData.getString("consumemethod"))) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u3002", (String)"AttBizItemValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (!SWCStringUtils.equals((String)data.getString("number"), (String)oldData.getString("number"))) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u7f16\u7801\u3002", (String)"AttBizItemValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (!SWCStringUtils.equals((String)data.getString("attitemtype"), (String)oldData.getString("attitemtype"))) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u8003\u52e4\u9879\u76ee\u7c7b\u578b\u3002", (String)"AttBizItemValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (!SWCStringUtils.equals((String)data.getString("ctrlstrategy"), (String)oldData.getString("ctrlstrategy"))) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u63a7\u5236\u7b56\u7565\u3002", (String)"AttBizItemValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        }
        return tag;
    }

    private void deleteValidator(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
    }

    private boolean checkMaxValueAndMinValueIsNumeric(DynamicObject data, ExtendedDataEntity dataEntity) {
        String maxValue = data.getString("inputmaxval");
        if (!maxValue.isEmpty() && !SWCNumberValidateUtils.isRealNumber((String)maxValue)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizItemValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            return false;
        }
        String minValue = data.getString("inputminval");
        if (!minValue.isEmpty() && !SWCNumberValidateUtils.isRealNumber((String)minValue)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizItemValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            return false;
        }
        return true;
    }
}

