/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.attinteg;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.attinteg.AttIntegMapScmHelper;
import org.apache.commons.lang.StringUtils;

public class AttIntegMapScmValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "enable": {
                if (dataEntities.length > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u542f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"AttIntegMapScmValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                }
                this.enableValidator(dataEntities);
                break;
            }
        }
    }

    private void enableValidator(ExtendedDataEntity[] dataEntities) {
        HashSet countryIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        HashSet orgIds = Sets.newHashSetWithExpectedSize((int)dataEntities.length);
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject obj = entity.getDataEntity();
            if (StringUtils.equals((String)obj.getString("enable"), (String)"1")) {
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e3a\u53ef\u7528\u72b6\u6001\u3002", (String)"AttIntegMapScmValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, errorMsg);
                continue;
            }
            countryIds.add(obj.getLong("country.id"));
            orgIds.add(obj.getLong("org.id"));
        }
        QFilter qFilter = new QFilter("country.id", "in", (Object)countryIds);
        qFilter.and(new QFilter("org.id", "in", (Object)orgIds));
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection dyobjCol = AttIntegMapScmHelper.queryAttIntegMapScmList((QFilter)qFilter);
        Map<String, DynamicObject> dyobjMap = dyobjCol.stream().collect(Collectors.toMap(entry -> String.valueOf(entry.getLong("country.id")) + String.valueOf(entry.getLong("org.id")), Function.identity(), (o1, o2) -> o1));
        this.checkDataOnlyOne(dataEntities, dyobjMap);
    }

    private void checkDataOnlyOne(ExtendedDataEntity[] dataEntities, Map<String, DynamicObject> dyobjMap) {
        for (ExtendedDataEntity entity : dataEntities) {
            DynamicObject dataEntity = entity.getDataEntity();
            String dataKey = String.valueOf(dataEntity.getString("country.id")) + String.valueOf(dataEntity.getLong("org.id"));
            if (!dyobjMap.containsKey(dataKey)) continue;
            String errorMsg = ResManager.loadKDString((String)"\u542f\u7528\u5931\u8d25\uff0c\u4e00\u4e2a\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e00\u4e2a\u56fd\u5bb6/\u5730\u533a\u4e0b\u4ec5\u53ef\u5b58\u57281\u4e2a\u53ef\u7528\u72b6\u6001\u7684\u6620\u5c04\u65b9\u6848\u3002", (String)"AttIntegMapScmValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
        }
    }
}

