/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.attintegnew;

import com.google.common.collect.Maps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class AttIntegMapScmNewValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "donothing_confirmchange": 
            case "confirmchange": 
            case "auditconfirmchange": 
            case "changesave": {
                this.checkSave(dataEntities);
                break;
            }
        }
    }

    private void checkSave(ExtendedDataEntity[] dataEntities) {
        HashMap<Long, DynamicObject> attItemMap = new HashMap<Long, DynamicObject>(16);
        HashMap<Long, DynamicObject> attBizItemMap = new HashMap<Long, DynamicObject>(16);
        HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
        this.collectAttItemAndAttBizItem(dataEntities, attItemMap, attBizItemMap, orgIdSet);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            Long orgId = data.getDynamicObject("org").getLong("id");
            if (!orgIdSet.contains(orgId)) {
                String errorMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6743\u9650\u3002", (String)"AttIntegMapScmNewValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                continue;
            }
            if (!this.checkEntryEmpty(dataEntity)) continue;
            this.checkEntryItem(dataEntity, attItemMap, attBizItemMap);
        }
    }

    private void collectAttItemAndAttBizItem(ExtendedDataEntity[] dataEntities, Map<Long, DynamicObject> attItemMap, Map<Long, DynamicObject> attBizItemMap, Set<Long> orgIdSet) {
        HashSet<Long> attItemIdSet = new HashSet<Long>(16);
        HashSet<Long> attBizItemIdSet = new HashSet<Long>(16);
        this.collectEntryCheckInfo(dataEntities, attItemIdSet, attBizItemIdSet, orgIdSet);
        HashMap param = Maps.newHashMapWithExpectedSize((int)3);
        QFilter attItemFilter = new QFilter("enable", "=", (Object)"1");
        attItemFilter.and(new QFilter("status", "=", (Object)"C"));
        attItemFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        attItemFilter.and("id", "in", attItemIdSet);
        param.put("filters", new QFilter[]{attItemFilter});
        param.put("start", 0);
        param.put("end", attItemIdSet.size());
        DynamicObject[] attItems = attItemIdSet.size() > 0 ? (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"wtc", (String)"wtis", (String)"ISalaryIntegrationService", (String)"getAttitem", (Object[])new Object[]{param}) : null;
        if (attItems != null && attItems.length > 0) {
            attItemMap.putAll(Arrays.stream(attItems).collect(Collectors.toMap(attItem -> attItem.getLong("id"), attItem -> attItem)));
        }
        SWCDataServiceHelper attBizItemHelper = new SWCDataServiceHelper("hsbs_attbizitem");
        QFilter bizItemFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_attbizitem", new ArrayList<Long>(orgIdSet), (boolean)true);
        if (bizItemFilter == null) {
            bizItemFilter = new QFilter("status", "=", (Object)"C");
        } else {
            bizItemFilter.and(new QFilter("status", "=", (Object)"C"));
        }
        bizItemFilter.and(new QFilter("enable", "=", (Object)"1"));
        bizItemFilter.and(new QFilter("id", "in", attBizItemIdSet));
        DynamicObjectCollection attBizItems = attBizItemHelper.queryOriginalCollection("id,attitemtype", new QFilter[]{bizItemFilter});
        if (!CollectionUtils.isEmpty((Collection)attBizItems)) {
            attBizItemMap.putAll(attBizItems.stream().collect(Collectors.toMap(attBizItem -> attBizItem.getLong("id"), attBizItem -> attBizItem)));
        }
    }

    private void collectEntryCheckInfo(ExtendedDataEntity[] dataEntities, Set<Long> attItemIdSet, Set<Long> attBizItemIdSet, Set<Long> orgIdSet) {
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHLXNRR9KPZ", (String)"hsbs_attintegmapscmnew", (String)"47150e89000000ac");
        boolean hasAllOrg = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIdList = hasPermOrgResult.getHasPermOrgs();
        HashSet allOrgSet = new HashSet(allOrgIdList);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection sumEntry = data.getDynamicObjectCollection("sumentryentity");
            DynamicObjectCollection detailEntry = data.getDynamicObjectCollection("detailentryentity");
            for (DynamicObject sumData : sumEntry) {
                attItemIdSet.add(sumData.getLong("sumattitem.id"));
                attBizItemIdSet.add(sumData.getLong("sumattbizitem.id"));
            }
            for (DynamicObject detailData : detailEntry) {
                attItemIdSet.add(detailData.getLong("detailattitem.id"));
                attBizItemIdSet.add(detailData.getLong("detailattbizitem.id"));
            }
            Long orgId = data.getDynamicObject("org").getLong("id");
            if (hasAllOrg) {
                orgIdSet.add(orgId);
                continue;
            }
            if (!allOrgSet.contains(orgId)) continue;
            orgIdSet.add(orgId);
        }
    }

    private boolean checkEntryEmpty(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection sumEntry = data.getDynamicObjectCollection("sumentryentity");
        DynamicObjectCollection detailEntry = data.getDynamicObjectCollection("detailentryentity");
        String itemScope = data.getString("itemscope");
        boolean result = true;
        if ("0".equals(itemScope)) {
            if (CollectionUtils.isEmpty((Collection)sumEntry)) {
                result = false;
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u603b\u9879\u76ee\u5206\u5f55\u201d\u3002", (String)"AttIntegMapScmNewValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
            if (!CollectionUtils.isEmpty((Collection)detailEntry)) {
                detailEntry.clear();
            }
        } else if ("1".equals(itemScope)) {
            if (CollectionUtils.isEmpty((Collection)detailEntry)) {
                result = false;
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u9879\u76ee\u5206\u5f55\u201d\u3002", (String)"AttIntegMapScmNewValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
            if (!CollectionUtils.isEmpty((Collection)sumEntry)) {
                sumEntry.clear();
            }
        } else if (CollectionUtils.isEmpty((Collection)sumEntry) && CollectionUtils.isEmpty((Collection)detailEntry)) {
            result = false;
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u603b\u9879\u76ee\u5206\u5f55\u201d\uff0c\u201c\u660e\u7ec6\u9879\u76ee\u5206\u5f55\u201d\u3002", (String)"AttIntegMapScmNewValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        } else if (CollectionUtils.isEmpty((Collection)sumEntry)) {
            result = false;
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6c47\u603b\u9879\u76ee\u5206\u5f55\u201d\u3002", (String)"AttIntegMapScmNewValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        } else if (CollectionUtils.isEmpty((Collection)detailEntry)) {
            result = false;
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u9879\u76ee\u5206\u5f55\u201d\u3002", (String)"AttIntegMapScmNewValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
        return result;
    }

    private void checkEntryItem(ExtendedDataEntity dataEntity, Map<Long, DynamicObject> attItemMap, Map<Long, DynamicObject> attBizItemMap) {
        DynamicObject attBizItem;
        Long attBizItemId;
        DynamicObject attItem;
        Long attItemId;
        int seq;
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection sumEntry = data.getDynamicObjectCollection("sumentryentity");
        DynamicObjectCollection detailEntry = data.getDynamicObjectCollection("detailentryentity");
        if (!CollectionUtils.isEmpty((Collection)sumEntry)) {
            for (DynamicObject sumData : sumEntry) {
                seq = sumData.getInt("seq");
                attItemId = sumData.getLong("sumattitem.id");
                attItem = attItemMap.get(attItemId);
                if (attItem == null) {
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    continue;
                }
                if ("1".equals(attItem.getString("itemtype"))) {
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    continue;
                }
                attBizItemId = sumData.getLong("sumattbizitem.id");
                attBizItem = attBizItemMap.get(attBizItemId);
                if (attBizItem == null) {
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    continue;
                }
                if (!"0".equals(attBizItem.getString("attitemtype"))) continue;
                this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)detailEntry)) {
            for (DynamicObject detailData : detailEntry) {
                seq = detailData.getInt("seq");
                attItemId = detailData.getLong("detailattitem.id");
                attItem = attItemMap.get(attItemId);
                if (attItem == null) {
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    continue;
                }
                if ("3".equals(attItem.getString("itemtype"))) {
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    continue;
                }
                attBizItemId = detailData.getLong("detailattbizitem.id");
                attBizItem = attBizItemMap.get(attBizItemId);
                if (attBizItem == null) {
                    this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
                    continue;
                }
                if (!"1".equals(attBizItem.getString("attitemtype"))) continue;
                this.addMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u7b2c{0}\u884c\u5206\u5f55\uff0c\u5fc5\u586b\u9879\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u540d\u79f0\u201d\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u89c4\u5219\uff0c\u8bf7\u8c03\u6574\u3002", (String)"AttIntegMapScmNewValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
            }
        }
    }
}

