/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.bizitemgroup;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.service.BizItemGroupService;

public class BizItemGroupValidator
extends SWCDataBaseValidator {
    public static int BIZITEM_MAX_NUMBER = 100;

    public void validate() {
        super.validate();
        switch (this.getOperateKey()) {
            case "save": {
                this.saveOrSubmitCheck();
                this.submitValueAndDateCheck(false);
                this.checkImportData();
                this.currencyValidator();
                break;
            }
            case "submit": {
                this.saveOrSubmitCheck();
                this.submitValueAndDateCheck(true);
                this.importAndViewStyleCheck();
                this.currencyValidator();
                break;
            }
            case "audit": 
            case "enable": {
                this.auditAndEnableCheck();
                break;
            }
        }
    }

    private void checkImportData() {
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        if (SWCStringUtils.equals((String)isSave, (String)Boolean.TRUE.toString())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"29", (String)"/UHLXNRR9KPZ", (String)"hsbs_bizitemgroup", (String)"47150e89000000ac");
        boolean hasAllOrg = hasPermOrgResult.hasAllOrgPerm();
        List allOrgIdList = hasPermOrgResult.getHasPermOrgs();
        HashSet allOrgSet = new HashSet(allOrgIdList);
        HashSet<Long> orgIdSet = new HashSet<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizItemGroupObj = dataEntity.getDataEntity();
            DynamicObject orgObj = bizItemGroupObj.getDynamicObject("createorg");
            Long orgId = orgObj.getLong("id");
            if (hasAllOrg) {
                orgIdSet.add(orgId);
                continue;
            }
            if (!allOrgSet.contains(orgId)) continue;
            orgIdSet.add(orgId);
        }
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and(new QFilter("enable", "=", (Object)"1"));
        QFilter periodFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_calperiodtype", new ArrayList(orgIdSet), (boolean)true);
        SWCDataServiceHelper peridHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObjectCollection peridColl = null;
        peridColl = periodFilter != null ? peridHelper.queryOriginalCollection("id", new QFilter[]{qFilter, periodFilter}) : peridHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        HashSet<Long> periodIdSet = new HashSet<Long>(16);
        if (peridColl != null) {
            for (DynamicObject peridObj : peridColl) {
                periodIdSet.add(peridObj.getLong("id"));
            }
        }
        QFilter bizItemFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_bizitem", new ArrayList(orgIdSet), (boolean)true);
        SWCDataServiceHelper bizItemHelper = new SWCDataServiceHelper("hsbs_bizitem");
        DynamicObjectCollection bizItemColl = null;
        bizItemColl = bizItemFilter != null ? bizItemHelper.queryOriginalCollection("id", new QFilter[]{qFilter, bizItemFilter}) : bizItemHelper.queryOriginalCollection("id", new QFilter[]{qFilter});
        HashSet<Long> bizItemIdSet = new HashSet<Long>(16);
        if (bizItemColl != null) {
            for (DynamicObject bizItemObj : bizItemColl) {
                bizItemIdSet.add(bizItemObj.getLong("id"));
            }
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bizItemGroupObj = dataEntity.getDataEntity();
            DynamicObject orgObj = bizItemGroupObj.getDynamicObject("createorg");
            Long orgId = orgObj.getLong("id");
            if (!orgIdSet.contains(orgId)) {
                String errorMsg = ResManager.loadKDString((String)"\u6ca1\u6709\u8be5\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6743\u9650\u3002", (String)"BizItemGroupValidator_22", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                continue;
            }
            DynamicObject periodObj = bizItemGroupObj.getDynamicObject("calperiodtype");
            Long periodId = periodObj.getLong("id");
            if (!periodIdSet.contains(periodId)) {
                String errorMsg = ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b\u5728\u8be5\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u4e0d\u53ef\u7528\u3002", (String)"BizItemGroupValidator_23", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                continue;
            }
            DynamicObjectCollection bizItemEntryColl = bizItemGroupObj.getDynamicObjectCollection("entryentity");
            if (bizItemEntryColl == null || bizItemEntryColl.size() == 0) continue;
            for (DynamicObject bizItemEntryObj : bizItemEntryColl) {
                DynamicObject bizItemObj = bizItemEntryObj.getDynamicObject("bizitem");
                Long bizItemId = bizItemObj.getLong("id");
                if (!bizItemIdSet.contains(bizItemId)) {
                    String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5728\u8be5\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u4e0b\u4e0d\u53ef\u7528\u3002", (String)"BizItemGroupValidator_25", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    continue;
                }
                boolean isextprop = bizItemObj.getBoolean("isextprop");
                if (!isextprop) continue;
                String errorMsg = ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u6dfb\u52a0\u5e26\u6269\u5c55\u5c5e\u6027\u7684\u4e1a\u52a1\u9879\u76ee\u3002", (String)"BizItemGroupValidator_24", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            }
        }
    }

    private void importAndViewStyleCheck() {
        DynamicObject data = null;
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            data = dataEntity.getDataEntity();
            String modelType = data.getString("modeltype");
            if (!SWCStringUtils.isEmpty((String)modelType)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u5148\u5b8c\u6210\u4e1a\u52a1\u6570\u636e\u6837\u5f0f\u8bbe\u7f6e\u540e\u518d\u63d0\u4ea4\u548c\u542f\u7528\u3002", (String)"BizItemGroupValidator_19", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void auditAndEnableCheck() {
        block0: for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = data.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryColl.size(); ++index) {
                boolean submitDateCheck;
                String errorMsg;
                DynamicObject entryObj = (DynamicObject)entryColl.get(index);
                DynamicObject bizItemObj = entryObj.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)bizItemObj)) continue;
                Long dataTypeId = bizItemObj.getLong("datatype.id");
                if (dataTypeId == 1010L) {
                    boolean submitValCheck = this.auditSubmitMaxAndMinValueCheck(entryObj, bizItemObj);
                    if (submitValCheck) continue;
                    errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4e2d\u7684\u63d0\u62a5\u6700\u5927/\u6700\u5c0f\u8f93\u5165\u503c\uff0c\u63d0\u62a5\u6700\u65e9/\u6700\u665a\u65e5\u671f\u4e0e\u4e1a\u52a1\u9879\u76ee\u7684\u503c\u8303\u56f4\u51b2\u7a81\uff08\u5927\u4e8e\u4e1a\u52a1\u9879\u76ee\u7684\u503c\u8303\u56f4\uff09\uff0c\u8bf7\u7f16\u8f91\u8c03\u6574\u3002", (String)"BizItemGroupValidator_37", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                    continue block0;
                }
                if (dataTypeId != 1050L || (submitDateCheck = this.auditSubmitStartAndEndDateCheck(entryObj, bizItemObj))) continue;
                errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4e2d\u7684\u63d0\u62a5\u6700\u5927/\u6700\u5c0f\u8f93\u5165\u503c\uff0c\u63d0\u62a5\u6700\u65e9/\u6700\u665a\u65e5\u671f\u4e0e\u4e1a\u52a1\u9879\u76ee\u7684\u503c\u8303\u56f4\u51b2\u7a81\uff08\u5927\u4e8e\u4e1a\u52a1\u9879\u76ee\u7684\u503c\u8303\u56f4\uff09\uff0c\u8bf7\u7f16\u8f91\u8c03\u6574\u3002", (String)"BizItemGroupValidator_37", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                continue block0;
            }
        }
    }

    private void submitValueAndDateCheck(boolean isSubmit) {
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        boolean isImport = true;
        if (StringUtils.equals((CharSequence)isSave, (CharSequence)Boolean.TRUE.toString())) {
            isImport = false;
        } else if (isSubmit) {
            isImport = false;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection entryColl = data.getDynamicObjectCollection("entryentity");
            for (int index = 0; index < entryColl.size(); ++index) {
                DynamicObject entryObj = (DynamicObject)entryColl.get(index);
                DynamicObject bizItemObj = entryObj.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)bizItemObj)) continue;
                Long dataTypeId = bizItemObj.getLong("datatype.id");
                if (dataTypeId == 1010L) {
                    this.submitMaxAndMinValueCheck(dataEntity, entryObj, bizItemObj, index, isImport);
                    continue;
                }
                if (dataTypeId == 1050L) {
                    this.submitStartAndEndDateCheck(dataEntity, entryObj, bizItemObj, index, isImport);
                    continue;
                }
                if (!isImport) continue;
                this.otherDataTypeCheck(dataEntity, entryObj);
            }
        }
    }

    private boolean auditSubmitStartAndEndDateCheck(DynamicObject entryObj, DynamicObject bizItemObj) {
        BizItemGroupService service = new BizItemGroupService();
        Date submitStartDate = entryObj.getDate("submitstartdate");
        Date submitEndDate = entryObj.getDate("submitenddate");
        Date earliestDate = bizItemObj.getDate("earliestdate");
        Date lastDate = bizItemObj.getDate("lastdate");
        boolean dateCheck = service.checkSubmitStartAndEndDate(submitStartDate, submitEndDate);
        if (!dateCheck) {
            return false;
        }
        dateCheck = service.checkSubmitDateRange(earliestDate, lastDate, submitStartDate);
        if (!dateCheck) {
            return false;
        }
        dateCheck = service.checkSubmitDateRange(earliestDate, lastDate, submitEndDate);
        return dateCheck;
    }

    private void submitStartAndEndDateCheck(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject bizItemObj, int index, boolean isImport) {
        String errorMsg;
        String errorMsgStr;
        Date lastDate;
        Date earliestDate;
        Date submitEndDate;
        String preErrorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u9879\u76ee\u6784\u6210\u201d\u7b2c{0}\u884c\uff1a", (String)"BizItemGroupValidator_30", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), index + 1);
        BizItemGroupService service = new BizItemGroupService();
        Date submitStartDate = entryObj.getDate("submitstartdate");
        boolean dateCheck = service.checkSubmitStartAndEndDate(submitStartDate, submitEndDate = entryObj.getDate("submitenddate"));
        if (!dateCheck) {
            String errorMsg2 = ResManager.loadKDString((String)"\u63d0\u62a5\u6700\u665a\u65e5\u671f\u5e94\u665a\u4e8e\u63d0\u62a5\u6700\u65e9\u65e5\u671f\u3002", (String)"BizItemGroupValidator_34", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            if (isImport) {
                this.addMessage(dataEntity, errorMsg2, ErrorLevel.FatalError);
            } else {
                this.addMessage(dataEntity, preErrorMsg + errorMsg2, ErrorLevel.FatalError);
            }
        }
        if (!(dateCheck = service.checkSubmitDateRange(earliestDate = bizItemObj.getDate("earliestdate"), lastDate = bizItemObj.getDate("lastdate"), submitStartDate))) {
            errorMsgStr = ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u63d0\u62a5\u65e5\u671f\u5728\u9879\u76ee\u65e5\u671f\u8303\u56f4\u5185\uff1a{0}~{1}\u3002", (String)"BizItemGroupValidator_35", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, earliestDate == null ? Character.valueOf(' ') : SWCDateTimeUtils.format((Date)earliestDate, (String)"yyyy-MM-dd"), lastDate == null ? Character.valueOf(' ') : SWCDateTimeUtils.format((Date)lastDate, (String)"yyyy-MM-dd"));
            if (isImport) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            } else {
                this.addMessage(dataEntity, preErrorMsg + errorMsg, ErrorLevel.FatalError);
            }
        }
        if (!(dateCheck = service.checkSubmitDateRange(earliestDate, lastDate, submitEndDate))) {
            errorMsgStr = ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u63d0\u62a5\u65e5\u671f\u5728\u9879\u76ee\u65e5\u671f\u8303\u56f4\u5185\uff1a{0}~{1}\u3002", (String)"BizItemGroupValidator_36", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, earliestDate == null ? Character.valueOf(' ') : SWCDateTimeUtils.format((Date)earliestDate, (String)"yyyy-MM-dd"), lastDate == null ? Character.valueOf(' ') : SWCDateTimeUtils.format((Date)lastDate, (String)"yyyy-MM-dd"));
            if (isImport) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            } else {
                this.addMessage(dataEntity, preErrorMsg + errorMsg, ErrorLevel.FatalError);
            }
        }
    }

    private boolean auditSubmitMaxAndMinValueCheck(DynamicObject entryObj, DynamicObject bizItemObj) {
        boolean maxAndMinCheck;
        BizItemGroupService service = new BizItemGroupService();
        BigDecimal submitMinVal = entryObj.getBigDecimal("submitminvalue");
        BigDecimal submitMaxVal = entryObj.getBigDecimal("submitmaxvalue");
        String isMinValNull = bizItemObj.getString("isminvalnull");
        String isMaxValNull = bizItemObj.getString("ismaxvalnull");
        BigDecimal itemMinVal = null;
        if (!SWCStringUtils.equals((String)isMinValNull, (String)"1")) {
            itemMinVal = bizItemObj.getBigDecimal("minvalue");
        }
        BigDecimal itemMaxVal = null;
        if (!SWCStringUtils.equals((String)isMaxValNull, (String)"1")) {
            itemMaxVal = bizItemObj.getBigDecimal("maxvalue");
        }
        if (!(maxAndMinCheck = service.checkSubmitMaxAndMinVal(submitMinVal, submitMaxVal))) {
            return false;
        }
        maxAndMinCheck = service.checkSubmitValueRange(itemMinVal, itemMaxVal, submitMinVal);
        if (!maxAndMinCheck) {
            return false;
        }
        maxAndMinCheck = service.checkSubmitValueRange(itemMinVal, itemMaxVal, submitMaxVal);
        return maxAndMinCheck;
    }

    private void otherDataTypeCheck(ExtendedDataEntity dataEntity, DynamicObject entryObj) {
        BigDecimal submitMinVal = entryObj.getBigDecimal("submitminvalue");
        BigDecimal submitMaxVal = entryObj.getBigDecimal("submitmaxvalue");
        if (submitMinVal != null || submitMaxVal != null) {
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u4e3a\u975e\u6570\u503c\u7c7b\u578b\uff0c\u8bf7\u52ff\u586b\u5199\u63d0\u62a5\u6700\u5927/\u6700\u5c0f\u8f93\u5165\u503c\u3002", (String)"BizItemGroupValidator_40", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
        Date submitStartDate = entryObj.getDate("submitstartdate");
        Date submitEndDate = entryObj.getDate("submitenddate");
        if (submitStartDate != null || submitEndDate != null) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u52ff\u586b\u5199\u63d0\u62a5\u6700\u65e9/\u6700\u665a\u65e5\u671f\uff0c\u4e1a\u52a1\u9879\u76ee\u4e3a\u975e\u65e5\u671f\u7c7b\u578b\u3002", (String)"BizItemGroupValidator_41", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }

    private void submitMaxAndMinValueCheck(ExtendedDataEntity dataEntity, DynamicObject entryObj, DynamicObject bizItemObj, int index, boolean isImport) {
        String errorMsg;
        String errorMsgStr;
        boolean maxAndMinCheck;
        String preErrorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u201c\u4e1a\u52a1\u9879\u76ee\u6784\u6210\u201d\u7b2c{0}\u884c\uff1a", (String)"BizItemGroupValidator_30", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), index + 1);
        BizItemGroupService service = new BizItemGroupService();
        String scaleLimit = bizItemObj.getString("scalelimit");
        int scale = Integer.parseInt(scaleLimit);
        BigDecimal submitMinVal = entryObj.getBigDecimal("submitminvalue");
        BigDecimal submitMaxVal = entryObj.getBigDecimal("submitmaxvalue");
        if (isImport) {
            String maxValScale;
            String submitMaxValStr;
            String errorMsg2;
            String minValScale;
            String submitMinValStr;
            if (submitMinVal != null && (submitMinValStr = submitMinVal.stripTrailingZeros().toPlainString()).indexOf(46) != -1 && (minValScale = submitMinValStr.substring(submitMinValStr.indexOf(46) + 1, submitMinValStr.length())).length() > scale) {
                errorMsg2 = ResManager.loadKDString((String)"\u201c\u63d0\u62a5\u6700\u5c0f\u8f93\u5165\u503c\u201d\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemGroupValidator_38", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg2, ErrorLevel.FatalError);
            }
            if (submitMaxVal != null && (submitMaxValStr = submitMaxVal.stripTrailingZeros().toPlainString()).indexOf(46) != -1 && (maxValScale = submitMaxValStr.substring(submitMaxValStr.indexOf(46) + 1, submitMaxValStr.length())).length() > scale) {
                errorMsg2 = ResManager.loadKDString((String)"\u63d0\u62a5\u7684\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemGroupValidator_39", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg2, ErrorLevel.FatalError);
            }
        }
        if (!(maxAndMinCheck = service.checkSubmitMaxAndMinVal(submitMinVal, submitMaxVal))) {
            String errorMsg3 = ResManager.loadKDString((String)"\u63d0\u62a5\u6700\u5927\u8f93\u5165\u503c\u5e94\u2265\u63d0\u62a5\u6700\u5c0f\u8f93\u5165\u503c\u3002", (String)"BizItemGroupValidator_31", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            if (isImport) {
                this.addMessage(dataEntity, errorMsg3, ErrorLevel.FatalError);
            } else {
                this.addMessage(dataEntity, preErrorMsg + errorMsg3, ErrorLevel.FatalError);
            }
        }
        String isMinValNull = bizItemObj.getString("isminvalnull");
        String isMaxValNull = bizItemObj.getString("ismaxvalnull");
        BigDecimal itemMinVal = null;
        if (!SWCStringUtils.equals((String)isMinValNull, (String)"1")) {
            itemMinVal = bizItemObj.getBigDecimal("minvalue");
        }
        BigDecimal itemMaxVal = null;
        if (!SWCStringUtils.equals((String)isMaxValNull, (String)"1")) {
            itemMaxVal = bizItemObj.getBigDecimal("maxvalue");
        }
        if (!(maxAndMinCheck = service.checkSubmitValueRange(itemMinVal, itemMaxVal, submitMinVal))) {
            errorMsgStr = ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u8f93\u5165\u503c\u5728\u9879\u76ee\u7684\u6700\u5927\u503c{1}\u548c\u6700\u5c0f\u503c{0}\u4e4b\u95f4\u3002", (String)"BizItemGroupValidator_32", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, itemMinVal == null ? Character.valueOf(' ') : itemMinVal.setScale(scale, 4).toPlainString(), itemMaxVal == null ? Character.valueOf(' ') : itemMaxVal.setScale(scale, 4).toPlainString());
            if (isImport) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            } else {
                this.addMessage(dataEntity, preErrorMsg + errorMsg, ErrorLevel.FatalError);
            }
        }
        if (!(maxAndMinCheck = service.checkSubmitValueRange(itemMinVal, itemMaxVal, submitMaxVal))) {
            errorMsgStr = ResManager.loadKDString((String)"\u8bf7\u786e\u4fdd\u63d0\u62a5\u7684\u6700\u5927\u8f93\u5165\u503c\u5728\u9879\u76ee\u7684\u6700\u5927\u548c\u6700\u5c0f\u503c\u8303\u56f4\u5185\uff1a{0}~{1}\u3002", (String)"BizItemGroupValidator_33", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, itemMinVal == null ? Character.valueOf(' ') : itemMinVal.setScale(scale, 4).toPlainString(), itemMaxVal == null ? Character.valueOf(' ') : itemMaxVal.setScale(scale, 4).toPlainString());
            if (isImport) {
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            } else {
                this.addMessage(dataEntity, preErrorMsg + errorMsg, ErrorLevel.FatalError);
            }
        }
    }

    private void saveOrSubmitCheck() {
        DynamicObject data = null;
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            data = dataEntity.getDataEntity();
            DynamicObjectCollection entryEntity = data.getDynamicObjectCollection("entryentity");
            if (entryEntity != null && entryEntity.size() > BIZITEM_MAX_NUMBER) {
                String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u4e2a\u6570\u4e0d\u5f97\u8d85\u8fc7{0}\u4e2a\u3002", (String)"BizItemGroupValidator_21", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, MessageFormat.format(errorMsg, BIZITEM_MAX_NUMBER), ErrorLevel.FatalError);
                continue;
            }
            HashSet<String> bizItemNumberSet = new HashSet<String>(16);
            HashSet<String> isCycleSet = new HashSet<String>(2);
            if (!SWCListUtils.isEmpty((List)entryEntity)) {
                for (DynamicObject entry : entryEntity) {
                    this.checkInputValue(dataEntity, entry, bizItemNumberSet);
                    String bizitemCycle = entry.getString("bizitem.cycle");
                    isCycleSet.add(bizitemCycle);
                }
            }
            if (isCycleSet.size() == 2) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u4e0d\u652f\u6301\u540c\u65f6\u5305\u542b\u5faa\u73af\u548c\u975e\u5faa\u73af\u7684\u4e1a\u52a1\u9879\u76ee\u3002", (String)"BizItemGroupValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            DynamicObjectCollection entryColl = data.getDynamicObjectCollection("entryentity");
            String modelType = data.getString("modeltype");
            boolean isContainsCycle = false;
            for (DynamicObject entryObj : entryColl) {
                String cycle;
                DynamicObject bizItemObj = entryObj.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)bizItemObj) || !SWCStringUtils.equals((String)(cycle = bizItemObj.getString("cycle")), (String)"1")) continue;
                isContainsCycle = true;
                break;
            }
            if (!isContainsCycle || !SWCStringUtils.equals((String)modelType, (String)"2")) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542b\u5faa\u73af\u9879\u7684\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u7684\u201c\u5bfc\u5165\u67e5\u770b\u6837\u5f0f\u201d\u9700\u8bbe\u7f6e\u4e3a\u201c\u7eb5\u8868\u201d\u3002", (String)"BizItemGroupValidator_45", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void currencyValidator() {
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        if (SWCStringUtils.equals((String)isSave, (String)Boolean.TRUE.toString())) {
            return;
        }
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            DynamicObjectCollection entryColl;
            DynamicObject currencyObj;
            DynamicObject bizItemGroupObj = dataEntity.getDataEntity();
            String currencyfilltype = bizItemGroupObj.getString("currencyfilltype");
            if (SWCStringUtils.isEmpty((String)currencyfilltype)) {
                currencyfilltype = "1";
                bizItemGroupObj.set("currencyfilltype", (Object)currencyfilltype);
            }
            if (!SWCStringUtils.equals((String)currencyfilltype, (String)"2") && !SWCObjectUtils.isEmpty((Object)(currencyObj = bizItemGroupObj.getDynamicObject("sysfillcurrency")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u586b\u5145\u65b9\u5f0f\u4e3a\u7a7a\u6216\u201c\u4eba\u5de5\u586b\u5199\u201d\u4e0d\u80fd\u6307\u5b9a\u7cfb\u7edf\u586b\u5145\u5e01\u79cd\u3002", (String)"BizItemGroupValidator_42", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            if (SWCStringUtils.equals((String)currencyfilltype, (String)"2") && SWCObjectUtils.isEmpty((Object)(currencyObj = bizItemGroupObj.getDynamicObject("sysfillcurrency")))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5e01\u79cd\u586b\u5145\u65b9\u5f0f\u4e3a \u201c\u7cfb\u7edf\u586b\u5145\uff08\u4e0d\u5f00\u653e\u4eba\u5de5\u586b\u5199\uff09\u201d\u65f6\uff0c\u8bf7\u586b\u5199\u201c\u7cfb\u7edf\u586b\u5145\u5e01\u79cd\u201d\u3002", (String)"BizItemGroupValidator_43", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            currencyObj = bizItemGroupObj.getDynamicObject("sysfillcurrency");
            if (SWCObjectUtils.isEmpty((Object)currencyObj) || (entryColl = bizItemGroupObj.getDynamicObjectCollection("entryentity")) == null || entryColl.size() == 0) continue;
            HashSet<String> notContainCurrencySet = new HashSet<String>(entryColl.size());
            for (DynamicObject entryObj : entryColl) {
                DynamicObjectCollection inputCurrencyColl;
                long dataTypeId;
                DynamicObject bizItemObj = entryObj.getDynamicObject("bizitem");
                if (SWCObjectUtils.isEmpty((Object)bizItemObj) || (dataTypeId = bizItemObj.getLong("datatype.id")) != 1020L || (inputCurrencyColl = bizItemObj.getDynamicObjectCollection("currency")) == null || inputCurrencyColl.size() == 0 || this.containCurrency(inputCurrencyColl, currencyObj)) continue;
                notContainCurrencySet.add(bizItemObj.getString("name"));
            }
            int size = notContainCurrencySet.size();
            if (size == 0) continue;
            String msg = ResManager.loadKDString((String)"\u7cfb\u7edf\u586b\u5145\u5e01\u79cd\u4e0d\u5728\u4e1a\u52a1\u9879\u76ee\u7684\u53ef\u8f93\u5165\u5e01\u79cd\u8303\u56f4\u5185\uff1a", (String)"BizItemGroupValidator_44", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            StringBuilder sb = new StringBuilder();
            sb.append(msg);
            int index = 0;
            for (String notContainCurrencyName : notContainCurrencySet) {
                sb.append(notContainCurrencyName);
                if (index != size - 1) {
                    sb.append('\u3001');
                }
                ++index;
            }
            this.addMessage(dataEntity, sb.toString(), ErrorLevel.FatalError);
        }
    }

    private boolean containCurrency(DynamicObjectCollection inputCurrencyColl, DynamicObject currencyObj) {
        long currencyId = currencyObj.getLong("id");
        for (DynamicObject inputCurrencyObj : inputCurrencyColl) {
            DynamicObject obj = inputCurrencyObj.getDynamicObject("fbasedataid");
            long inputCurrencyId = obj.getLong("id");
            if (currencyId != inputCurrencyId) continue;
            return true;
        }
        return false;
    }

    private void checkInputValue(ExtendedDataEntity dataEntity, DynamicObject entry, Set<String> bizItemNumberSet) {
        int seq = entry.getInt("seq");
        String bizItemNumber = entry.getString("bizitem.number");
        if (bizItemNumberSet.contains(bizItemNumber)) {
            this.addMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u4e1a\u52a1\u9879\u76ee\u5df2\u5b58\u5728\u4e1a\u52a1\u6570\u636e\u6a21\u7248\u4e2d\uff0c\u4e0d\u53ef\u91cd\u590d\u5bfc\u5165", (String)"BizItemGroupValidator_46", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq), ErrorLevel.Error);
        } else {
            bizItemNumberSet.add(bizItemNumber);
        }
    }
}

