/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.changereason;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class ChangeReasonValidator
extends AbstractValidator {
    private static final String HSBS_CHANGEREASON = "hsbs_changereason";

    public void validate() {
        Object[] extendedDataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])extendedDataEntities)) {
            return;
        }
        this.validateNumberAndBusinessFieldModify((ExtendedDataEntity[])extendedDataEntities);
    }

    private void validateNumberAndBusinessFieldModify(ExtendedDataEntity[] extendedDataEntities) {
        HashSet<Long> existsIds = new HashSet<Long>(extendedDataEntities.length);
        ArrayList<ExtendedDataEntity> existsRecords = new ArrayList<ExtendedDataEntity>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dynamicObject = extendedDataEntity.getDataEntity();
            if (SWCObjectUtils.isEmpty((Object)dynamicObject.getLong("id"))) continue;
            existsIds.add(dynamicObject.getLong("id"));
            existsRecords.add(extendedDataEntity);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(HSBS_CHANGEREASON);
        QFilter filter = new QFilter("id", "in", existsIds);
        Object[] dbEntities = helper.query("id,number,name,description,issyspreset,bussinessfield.id,bussinessfield.number", new QFilter[]{filter});
        if (SWCArrayUtils.isEmpty((Object[])dbEntities)) {
            return;
        }
        Map<Long, DynamicObject> dbMap = Arrays.stream(dbEntities).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        for (ExtendedDataEntity extendedDataEntity : existsRecords) {
            DynamicObject dy2 = extendedDataEntity.getDataEntity();
            Long id = dy2.getLong("id");
            DynamicObject dbData = dbMap.get(id);
            if (SWCObjectUtils.isEmpty((Object)dbData)) continue;
            String dbNum = dbData.getString("number");
            String dbBusinessFieldNum = dbData.getString("bussinessfield.number");
            String curNum = dy2.getString("number");
            String curBusinessFieldNum = dy2.getString("bussinessfield.number");
            if (SWCStringUtils.equals((String)dbNum, (String)curNum) && SWCStringUtils.equals((String)dbBusinessFieldNum, (String)curBusinessFieldNum)) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u4fee\u6539\u201c\u7f16\u7801\u201d\u548c\u201c\u4e1a\u52a1\u7c7b\u578b\u201d\u3002", (String)"ChangeReasonValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }
}

