/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.fetchconfig;

import java.text.MessageFormat;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.exception.KDBizException;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;

public class CalResultFetchConfigValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": {
                this.saveValidator(dataEntities);
                break;
            }
            case "enable": {
                if (dataEntities.length > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u542f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FetchConfigValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                }
                this.validFetchItemEnable(dataEntities);
                break;
            }
            case "disable": {
                break;
            }
        }
    }

    private void checkResultFetchConfigEnable(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            long fetchConfigId = data.getLong("id");
            boolean flag = FetchConfigHelper.checkResultFetchConfigEnable((long)fetchConfigId, (String)"1");
            if (flag) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u7981\u7528\u5df2\u542f\u7528\u7684\u6570\u636e\u3002", (String)"CalResultFetchConfigValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void validFetchItemEnable(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            long fetchConfigId = data.getLong("id");
            boolean flag = FetchConfigHelper.checkResultFetchConfigEnable((long)fetchConfigId, (String)"0");
            if (!flag) {
                return;
            }
            String resultMsg = FetchConfigHelper.checkConfigFetchItemEnable((long)fetchConfigId, (String)"1");
            if (!SWCStringUtils.isNotEmpty((String)resultMsg)) continue;
            this.addErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u53d6\u6570\u9879\u76ee\u5df2\u7ecf\u88ab\u4f7f\u7528\uff1a{0}\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"CalResultFetchConfigValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), resultMsg));
        }
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            DynamicObjectCollection calItemMatchEntry = data.getDynamicObjectCollection("calitemmatchentry");
            if (!CollectionUtils.isEmpty((Collection)calItemMatchEntry)) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8ba1\u7b97\u9879\u76ee\u6620\u5c04\u53d6\u6570\u9879\u76ee\u201d\u3002", (String)"CalResultFetchConfigValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }
}

