/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.fetchconfig;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.common.vo.FetchItemCheckResultVo;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;
import org.apache.commons.lang.StringUtils;

public class CustFetchConfigValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": {
                this.checkSaveFetchConfig(dataEntities);
                break;
            }
            case "enable": {
                if (dataEntities.length > 1) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u542f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FetchConfigValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                }
                this.checkFetchItemConfig(dataEntities[0]);
                break;
            }
            case "disable": {
                this.checkFetchConfigDisable(dataEntities);
                break;
            }
            case "delete": {
                this.checkDeleteFetchConfig(dataEntities);
                break;
            }
        }
    }

    private void checkFetchItemConfig(ExtendedDataEntity dataEntity) {
        DynamicObject dynamicObject = dataEntity.getDataEntity();
        Long configId = dynamicObject.getLong("id");
        DynamicObjectCollection calItemMatchEntry = dynamicObject.getDynamicObjectCollection("fetchfieldentry");
        List entryIdList = calItemMatchEntry.stream().map(single -> single.getLong("id")).collect(Collectors.toList());
        FetchItemCheckResultVo fetchItemCheckResultVo = FetchConfigHelper.checkBatchFetchItemEnableByEntryIds(entryIdList, (long)configId);
        if (SWCStringUtils.equals((String)"3", (String)fetchItemCheckResultVo.getResult())) {
            this.addFatalErrorMessage(dataEntity, MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u4ee5\u4e0b\u53d6\u6570\u9879\u76ee\u5df2\u7ecf\u88ab\u4f7f\u7528\uff1a{0}\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\u3002", (String)"CustFetchConfigEdit_22", (String)"swc-hsbs-formplugin", (Object[])new Object[0]), fetchItemCheckResultVo.getFetchItemList()));
        }
    }

    private void checkSaveFetchConfig(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObjectCollection dynamicObjectCollection = dataEntity.getDataEntity().getDynamicObjectCollection("fetchfieldentry");
            HashSet<String> outParamSet = new HashSet<String>(dynamicObjectCollection.size());
            HashSet<String> outParamNameSet = new HashSet<String>(dynamicObjectCollection.size());
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String outPutParam = dynamicObject.getString("outputparam");
                String outPutParamName = dynamicObject.getString("outputparamname");
                if (!StringCheckUtils.isEnglishChar((String)outPutParam)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u53c2\u201c{0}\u201d\u53ea\u80fd\u586b\u5199\u82f1\u6587\u5b57\u6bcd\u3002", (String)"CustFetchConfigValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[]{outPutParam}));
                    continue;
                }
                if (outParamSet.contains(outPutParam)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u53c2\u201c{0}\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"CustFetchConfigValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[]{outPutParam}));
                    continue;
                }
                outParamSet.add(outPutParam);
                if (outParamNameSet.contains(outPutParamName)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fa\u53c2\u540d\u79f0\u201c{0}\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"CustFetchConfigValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[]{outPutParamName}));
                    continue;
                }
                outParamNameSet.add(outPutParamName);
            }
            HashSet<String> inParamSet = new HashSet<String>(dynamicObjectCollection.size());
            HashSet<String> inParamNameSet = new HashSet<String>(dynamicObjectCollection.size());
            DynamicObjectCollection inputEntry = dataEntity.getDataEntity().getDynamicObjectCollection("inputfieldentry");
            for (DynamicObject dynamicObject : inputEntry) {
                String inPutParam = dynamicObject.getString("inputparam");
                String inputParamName = dynamicObject.getString("inputparamname");
                if (!StringCheckUtils.isEnglishChar((String)inPutParam)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5165\u53c2\u201c{0}\u201d\u53ea\u80fd\u586b\u5199\u82f1\u6587\u5b57\u6bcd\u3002", (String)"CustFetchConfigValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[]{inPutParam}));
                    continue;
                }
                if (inParamSet.contains(inPutParam)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5165\u53c2\u201c{0}\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"CustFetchConfigValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[]{inPutParam}));
                    continue;
                }
                inParamSet.add(inPutParam);
                if (inParamNameSet.contains(inputParamName)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5165\u53c2\u540d\u79f0\u201c{0}\u201d\u4e0d\u80fd\u91cd\u590d\u3002", (String)"CustFetchConfigValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[]{inputParamName}));
                    continue;
                }
                inParamNameSet.add(inputParamName);
            }
        }
    }

    private void checkDeleteFetchConfig(ExtendedDataEntity[] dataEntities) {
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] dynamicObjects = fetchConfigHelper.selectCustFetchConfigList(pkIds);
        Map<Long, String> fetchConfigMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getString("enable")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            String type = fetchConfigMap.get(id);
            if (StringUtils.equals((String)"10", (String)type)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u542f\u7528\u7684\u6570\u636e\u624d\u53ef\u4ee5\u5220\u9664,\u542f\u7528\u8fc7\u7684\u6570\u636e\u53ea\u80fd\u7981\u7528\u3002", (String)"CustFetchConfigValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkFetchConfigDisable(ExtendedDataEntity[] dataEntities) {
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] dynamicObjects = fetchConfigHelper.selectCustFetchConfigList(pkIds);
        Map<Long, String> fetchConfigMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getString("enable")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            String type = fetchConfigMap.get(id);
            if (StringUtils.equals((String)"1", (String)type)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u7981\u7528\u5df2\u542f\u7528\u7684\u6570\u636e\u3002", (String)"CalResultFetchConfigValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }
}

