/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.fetchconfig;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.KDBizException;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;
import org.apache.commons.lang.StringUtils;

public class FetchConfigValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "enable": {
                if (dataEntities.length <= 1) break;
                throw new KDBizException(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u6279\u91cf\u542f\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u6570\u636e\u3002", (String)"FetchConfigValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
            case "disable": {
                this.checkFetchConfigDisable(dataEntities);
                break;
            }
            case "delete": {
                this.checkDeleteFetchConfigEnable(dataEntities);
                break;
            }
        }
    }

    private void checkDeleteFetchConfigEnable(ExtendedDataEntity[] dataEntities) {
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] dynamicObjects = fetchConfigHelper.selectFetchConfigList(pkIds);
        Map<Long, String> fetchConfigMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getString("enable")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            String type = fetchConfigMap.get(id);
            if (StringUtils.equals((String)"10", (String)type)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u5f85\u542f\u7528\u7684\u6570\u636e\u624d\u53ef\u4ee5\u5220\u9664,\u542f\u7528\u8fc7\u7684\u6570\u636e\u53ea\u80fd\u7981\u7528\u3002", (String)"FetchConfigValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkFetchConfigDisable(ExtendedDataEntity[] dataEntities) {
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getDataEntity().getLong("id")).collect(Collectors.toList());
        FetchConfigHelper fetchConfigHelper = new FetchConfigHelper();
        DynamicObject[] dynamicObjects = fetchConfigHelper.selectFetchConfigList(pkIds);
        Map<Long, String> fetchConfigMap = Arrays.stream(dynamicObjects).collect(Collectors.toMap(key -> key.getLong("id"), value -> value.getString("enable")));
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dynamicObject = dataEntity.getDataEntity();
            long id = dynamicObject.getLong("id");
            String type = fetchConfigMap.get(id);
            if (StringUtils.equals((String)"1", (String)type)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u80fd\u7981\u7528\u5df2\u542f\u7528\u7684\u6570\u636e\u3002", (String)"FetchConfigValidator_17", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }
}

