/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.fetchconfig;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class FetchItemValidator
extends SWCDataBaseValidator {
    private static final String IMPORT_TYPE_OVERRIDE = "override";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": {
                this.saveValidator(dataEntities);
                break;
            }
        }
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            this.importValidator(dataEntity);
        }
    }

    private void importValidator(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        String areaType = data.getString("areatype");
        if (SWCStringUtils.equals((String)areaType, (String)"1") && SWCStringUtils.isNotEmpty((String)data.getString("country.number"))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u662f\u901a\u7528\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u7f16\u7801\u53ea\u80fd\u4e3a\u7a7a\u3002", (String)"FetchItemValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        if (SWCStringUtils.equals((String)areaType, (String)"2") && SWCStringUtils.isEmpty((String)data.getString("country.number"))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u662f\u6307\u5b9a\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"FetchItemValidator_9", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)data.getString("name"))) {
            String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"FetchItemValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"FetchItemValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
            return;
        }
        if (StringCheckUtils.checkNumberIsContainJavaVariableForbidChar((String)data.getString("number"))) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e2d\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u6216\u7a7a\u683c\u3002", (String)"FetchItemValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        long dataType = data.getLong("datatype.id");
        if (dataType == 1020L) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\uff0c\u7f16\u7801\u9519\u8bef\u3002", (String)"FetchItemValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
            return;
        }
        if (dataType == 1030L || dataType == 1050L) {
            data.set("dataprecision", null);
            data.set("dataround", null);
        }
        if (this.getOption().containsVariable("importtype")) {
            String importtype = this.getOption().getVariableValue("importtype");
            long id = data.getLong("id");
            String number = data.getString("number");
            String enable = data.getString("enable");
            if (SWCStringUtils.equals((String)IMPORT_TYPE_OVERRIDE, (String)importtype) && SWCStringUtils.equals((String)"1", (String)enable)) {
                QFilter filter = new QFilter("id", "=", (Object)id);
                filter.and(new QFilter("enable", "=", (Object)"1"));
                SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_fetchitem");
                DynamicObject dynamicObject = helper.queryOne("number,name,enable,areatype,country.number,datatype", new QFilter[]{filter});
                String numberStr = dynamicObject.getString("number");
                if (!SWCStringUtils.equals((String)number, (String)numberStr)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u540e\u4e0d\u5141\u8bb8\u4fee\u6539\u7f16\u7801\u3002", (String)"FetchItemValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    return;
                }
                String areaTypeStr = dynamicObject.getString("areatype");
                if (!SWCStringUtils.equals((String)areaType, (String)areaTypeStr)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u540e\u4e0d\u5141\u8bb8\u4fee\u6539\u56fd\u5bb6/\u5730\u533a\u3002", (String)"FetchItemValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    return;
                }
                String countryNumberStr = dynamicObject.getString("country.number");
                String countryNumber = data.getString("country.number");
                if (!SWCStringUtils.equals((String)countryNumber, (String)countryNumberStr)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u540e\u4e0d\u5141\u8bb8\u4fee\u6539\u56fd\u5bb6/\u5730\u533a\u7f16\u7801\u3002", (String)"FetchItemValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    return;
                }
                long dataTypeNumber = dynamicObject.getLong("datatype.id");
                if (dataTypeNumber != dataType) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u542f\u7528\u540e\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u636e\u7c7b\u578b\u3002", (String)"FetchItemValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.Error);
                    return;
                }
            }
        }
    }
}

