/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.paysubject;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.basedata.paysubject.PaySubjectHelper;
import kd.swc.hsbs.common.enums.CashIntergrationEnum;

public class PaySubjectPayOrgValidator
extends SWCDataBaseValidator {
    private static final String CASHINTERGRATION = "cashintergration";

    public void validate() {
        String opKey;
        RefObject rfObj = new RefObject();
        if (!this.getOption().tryGetVariableValue("isSave", rfObj) && (SWCStringUtils.equals((String)(opKey = this.getOperateKey()), (String)"save") || SWCStringUtils.equals((String)opKey, (String)"audit"))) {
            ExtendedDataEntity[] entities = this.getDataEntities();
            List fiOrgList = null;
            HashSet<String> containsName = null;
            DynamicObjectCollection payorgent = null;
            for (ExtendedDataEntity entity : entities) {
                boolean isKingdee;
                DynamicObject paysubjectObj = entity.getDataEntity();
                String cashintergration = paysubjectObj.getString(CASHINTERGRATION);
                boolean bl = isKingdee = cashintergration != null && SWCStringUtils.indexOfIgnoreCase((String)cashintergration, (String)CashIntergrationEnum.KINGDEE.getCode()) >= 0;
                if (!isKingdee) continue;
                fiOrgList = fiOrgList == null ? PaySubjectHelper.getFiReceiveOrgList() : fiOrgList;
                containsName = new HashSet<String>(16);
                payorgent = paysubjectObj.getDynamicObjectCollection("payorgent");
                int entSize = payorgent.size();
                HashSet payerIdSet = Sets.newHashSetWithExpectedSize((int)entSize);
                boolean hasNotFiOrg = false;
                for (DynamicObject payOrg : payorgent) {
                    long agentpayorgId = payOrg.getLong("agentpayorg.id");
                    if (fiOrgList != null && fiOrgList.contains(agentpayorgId)) {
                        if (payerIdSet.contains(agentpayorgId)) {
                            containsName.add(payOrg.getString("agentpayorg.name"));
                        }
                        payerIdSet.add(agentpayorgId);
                        continue;
                    }
                    hasNotFiOrg = true;
                }
                if (!containsName.isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    int num = 0;
                    for (String name : containsName) {
                        sb.append('\u201c');
                        sb.append(name);
                        sb.append('\u201d');
                        if (++num >= containsName.size()) continue;
                        sb.append('\u3001');
                    }
                    String format = ResManager.loadKDString((String)"\u5b58\u5728\u76f8\u540c\u7684\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7%s\u3002", (String)"PaySubjectPayOrgValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    String errMsg = String.format(Locale.ROOT, format, sb.toString());
                    this.addFatalErrorMessage(entity, errMsg);
                }
                if (!hasNotFiOrg) continue;
                String content = ResManager.loadKDString((String)"\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"PaySubjectPayOrgValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage(entity, content);
            }
        }
    }
}

