/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.paysubject;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.support.util.CollectionUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.paysubject.PaySubjectLawHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.history.model.SWCHisBaseConstants;
import kd.swc.hsbp.common.util.SWCBaseUtils;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.basedata.paysubject.PaySubjectHelper;
import kd.swc.hsbs.common.enums.CashIntergrationEnum;

public class PaySubjectSaveValidator
extends SWCDataBaseValidator {
    public static final Pattern pattern = Pattern.compile("^\\d+$");
    private static final Log logger = LogFactory.getLog(PaySubjectSaveValidator.class);
    private static final String CASHINTERGRATION = "cashintergration";

    public void validate() {
        logger.info("PaySubjectSaveValidator length:{}", (Object)this.getDataEntities().length);
        ExtendedDataEntity[] entities = this.getDataEntities();
        HashSet lawIds = Sets.newHashSet();
        List lawEntityIds = Arrays.stream(entities).map(entity -> entity.getDataEntity().getLong("lawentity.id")).collect(Collectors.toList());
        SWCDataServiceHelper paySubjectHelper = new SWCDataServiceHelper("hsbs_paysubject");
        QFilter statusTempFilter = new QFilter("status", "in", Arrays.asList("A", "B"));
        QFilter statusAuditFilter = new QFilter("datastatus", "in", (Object)SWCHisBaseConstants.getValidStatus());
        statusTempFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        statusAuditFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        statusAuditFilter.or(statusTempFilter);
        QFilter lawEntityFilter = new QFilter("lawentity.id", "in", lawEntityIds);
        DynamicObject[] paySubjects = paySubjectHelper.query("id,boid,lawentity,bsed,bsled", new QFilter[]{lawEntityFilter, statusAuditFilter});
        HashMap paySubjectsMap = Maps.newHashMapWithExpectedSize((int)16);
        for (DynamicObject dynamicObject : paySubjects) {
            Long lawentityId = dynamicObject.getLong("lawentity.id");
            List paySubjectList = (List)paySubjectsMap.get(lawentityId);
            if (!CollectionUtils.isEmpty((Collection)paySubjectList)) {
                paySubjectList.add(dynamicObject);
                continue;
            }
            paySubjectsMap.put(lawentityId, Lists.newArrayList((Object[])new DynamicObject[]{dynamicObject}));
        }
        logger.info("PaySubjectSaveValidator entities:{}", (Object)entities.length);
        for (DynamicObject dynamicObject : entities) {
            String cashintergration;
            Object needlaw;
            logger.info("BillNo:{} \u5f00\u59cb\u5bfc\u5165", (Object)dynamicObject.getBillNo());
            int defaultNum = 0;
            DynamicObject paysubjectObj = dynamicObject.getDataEntity();
            Long lawEntityId = paysubjectObj.getLong("lawentity.id");
            if (lawEntityId != 0L) {
                Date bsed = paysubjectObj.getDate("bsed");
                Date bsled = paysubjectObj.getDate("bsled");
                bsled = bsled == null ? SWCBaseUtils.getMaxLoseEffectDate() : bsled;
                Long boid = paysubjectObj.getLong("boid");
                List paySubjectList = (List)paySubjectsMap.get(lawEntityId);
                boolean isRepeatLaw = false;
                if (!CollectionUtils.isEmpty((Collection)paySubjectList)) {
                    for (DynamicObject paySubject : paySubjectList) {
                        Date bsledDb;
                        Date bsedDb;
                        if (paySubject.getLong("boid") == boid.longValue() || !SWCDateTimeUtils.isDateRangeOverlap((Date)bsed, (Date)bsled, (Date)(bsedDb = paySubject.getDate("bsed")), (Date)(bsledDb = paySubject.getDate("bsled")))) continue;
                        isRepeatLaw = true;
                        break;
                    }
                    if (isRepeatLaw) {
                        this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u5df2\u88ab\u5f15\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PaySubjectEdit_BLUE_6", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
                        continue;
                    }
                }
            }
            if ((needlaw = SWCSalaryParameterServiceHelper.getSalaryParam((String)"paysubject", (String)"needlaw")) != null && Boolean.parseBoolean(String.valueOf(needlaw))) {
                if (lawEntityId == 0L) {
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53\u201d\u3002", (String)"PaySubjectSaveValidator_BLUE_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (lawEntityId == 0L && PaySubjectLawHelper.getLawIsMust().booleanValue()) {
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, ResManager.loadKDString((String)"\u652f\u4ed8\u4e3b\u4f53\u5fc5\u987b\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53\uff0c\u8bf7\u7ef4\u62a4\u201c\u5173\u8054\u6cd5\u5f8b\u5b9e\u4f53\u201d\u3002", (String)"PaySubjectSaveValidator_BLUE_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            boolean isKingdee = (cashintergration = paysubjectObj.getString(CASHINTERGRATION)) != null && SWCStringUtils.indexOfIgnoreCase((String)cashintergration, (String)CashIntergrationEnum.KINGDEE.getCode()) >= 0;
            DynamicObjectCollection payorgent = paysubjectObj.getDynamicObjectCollection("payorgent");
            if (!isKingdee && payorgent.isEmpty()) {
                this.reLawEntity((ExtendedDataEntity)dynamicObject, lawIds, lawEntityId);
                logger.info("BillNo:{} \u4ed8\u6b3e\u4fe1\u606f\u5206\u5f55\u5e94\u5141\u8bb8\u4e3a\u7a7a,\u65e0\u9700\u6821\u9a8c", (Object)dynamicObject.getBillNo());
                continue;
            }
            if (isKingdee && (payorgent == null || payorgent.isEmpty())) {
                String noPayOrg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u4fe1\u606f\u201d\u3002", (String)"PaySubjectSaveValidator_BLUE_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, noPayOrg);
                continue;
            }
            if (isKingdee) {
                if (payorgent.stream().anyMatch(data -> data.getLong("agentpayorg.id") == 0L)) {
                    String noPayOrg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u4fe1\u606f\u201d\u3002", (String)"PaySubjectSaveValidator_BLUE_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, noPayOrg);
                    continue;
                }
            } else if (payorgent.stream().anyMatch(data -> SWCStringUtils.isEmpty((String)data.getString("agentpayaccount")) || data.getLong("agentpaybank.id") == 0L)) {
                String noPayOrg = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u4fe1\u606f\u201d\u3002", (String)"PaySubjectSaveValidator_BLUE_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, noPayOrg);
                continue;
            }
            this.validatorAccountInfo(lawIds, (ExtendedDataEntity)dynamicObject, defaultNum, lawEntityId, isKingdee, payorgent);
        }
    }

    private void validatorAccountInfo(HashSet<Long> lawIds, ExtendedDataEntity entity, int defaultNum, Long lawEntityId, boolean isKingdee, DynamicObjectCollection payorgent) {
        TreeSet<Integer> noNameRow = new TreeSet<Integer>();
        boolean importTag = Boolean.parseBoolean(this.getOption().getVariableValue("importtag_of_datasource", "false"));
        for (DynamicObject ent : payorgent) {
            boolean isDefault = ent.getBoolean("isdefault");
            if (!isDefault && !PaySubjectHelper.isHaveScope((DynamicObject)ent)) {
                noNameRow.add(ent.getInt("seq"));
            }
            if (isDefault) {
                ++defaultNum;
            }
            String agentpayaccount = ent.getString("agentpayaccount");
            if (!importTag || !SWCStringUtils.isNotEmpty((String)agentpayaccount)) continue;
            Matcher isNum = pattern.matcher(agentpayaccount = agentpayaccount.replaceAll("\\s*", ""));
            if (!isNum.matches()) {
                this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u4ed8\u6b3e\u8d26\u53f7\u201d\u5b57\u6bb5\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"PaySubjectSaveValidator_BLUE_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            ent.set("agentpayaccount", (Object)agentpayaccount);
        }
        if (!importTag && !noNameRow.isEmpty()) {
            String format = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u4ed8\u6b3e\u4fe1\u606f\u201d\u7b2c%s\u884c\u201c\u9002\u7528\u8303\u56f4\u201d\u3002", (String)"PaySubjectSaveValidator_BLUE_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            String content = String.format(Locale.ROOT, format, PaySubjectHelper.getErrorRowStr(noNameRow));
            this.addFatalErrorMessage(entity, content);
        }
        logger.info("BillNo:{} \u9ed8\u8ba4\u884c:{}", (Object)entity.getBillNo(), (Object)defaultNum);
        if (defaultNum != 1) {
            String notOnePayOrg = isKingdee ? ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u4ed8\u6b3e\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"PaySubjectSaveValidator_BLUE_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8bf7\u8bbe\u7f6e\u4e00\u4e2a\u9ed8\u8ba4\u7684\u4ed8\u6b3e\u8d26\u53f7\u3002", (String)"PaySubjectSaveValidator_BLUE_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(entity, notOnePayOrg);
        }
        this.reLawEntity(entity, lawIds, lawEntityId);
    }

    private void reLawEntity(ExtendedDataEntity entity, HashSet<Long> lawIds, Long lawEntityId) {
        if (lawIds.contains(lawEntityId)) {
            this.addFatalErrorMessage(entity, ResManager.loadKDString((String)"\u6cd5\u5f8b\u5b9e\u4f53\u4e0e\u5176\u4ed6\u5bfc\u5165\u6570\u636e\u91cd\u590d\uff0c\u8bf7\u786e\u8ba4\u8c03\u6574\u3002", (String)"PaySubjectImportHrValidatorHandler_7", (String)"swc-hsbs-formplugin", (Object[])new Object[0]));
        } else {
            lawIds.add(lawEntityId);
        }
    }
}

