/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.statisticstag;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class StatisticsTagSaveValidator
extends SWCDataBaseValidator {
    private static final String KEY_PARENT_TAG = "parent";
    private static final String KEY_TAG_LEVEL = "taglevel";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_IS_LEAF = "isleaf";
    private static final String KEY_ENABLE_ADD_JUNIOR = "enableaddjunior";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            if (this.getOption().containsVariable("importtype")) {
                this.checkImportData();
            } else {
                this.checkSaveData();
            }
        }
    }

    private void checkSaveData() {
        HashSet<Long> oldDataIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            if (data.getLong("id") == 0L) continue;
            oldDataIdSet.add(data.getLong("id"));
        }
        Map<Long, DynamicObject> oldDataMap = this.collectOldDataMap(oldDataIdSet);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            if (!this.checkNumberAndName(dataEntity)) continue;
            this.checkModify(oldDataMap, dataEntity);
        }
    }

    private void checkImportData() {
        List dataEntityList = Arrays.stream(this.dataEntities).sorted(Comparator.comparingInt(data -> data.getDataEntity().getInt("taglevel.level"))).collect(Collectors.toList());
        dataEntityList.removeIf(dataEntity -> !this.checkNumberAndName((ExtendedDataEntity)dataEntity) || !this.checkAreaTypeAndCountry((ExtendedDataEntity)dataEntity));
        long[] ids = DB.genLongIds((String)"hsbs_statisticstag", (int)dataEntityList.size());
        int idIndex = 0;
        HashSet<Long> createOrgIdSet = new HashSet<Long>(this.dataEntities.length);
        HashSet<Long> oldDataIdSet = new HashSet<Long>(this.dataEntities.length);
        for (int index = 0; index < this.dataEntities.length; ++index) {
            DynamicObject data2 = this.dataEntities[index].getDataEntity();
            if (data2.getLong("id") == 0L) {
                data2.set("id", (Object)ids[idIndex++]);
            } else {
                oldDataIdSet.add(ids[idIndex]);
            }
            createOrgIdSet.add(data2.getLong("createorg.id"));
        }
        Map<Long, Set<Long>> createOrgIdMap = this.collectCreateOrgIdMap(createOrgIdSet);
        Map<String, DynamicObject> dependonTagMap = this.collectDependonTagMap();
        Map<Long, DynamicObject> oldDataMap = this.collectOldDataMap(oldDataIdSet);
        for (ExtendedDataEntity dataEntity2 : dataEntityList) {
            DynamicObject data3 = dataEntity2.getDataEntity();
            int level = data3.getDynamicObject(KEY_TAG_LEVEL).getInt(KEY_LEVEL);
            String parentTagNumber = dataEntity2.getDataEntity().getString("parenttagnumber");
            if (level == 1) {
                String number = data3.getString("number");
                dependonTagMap.put(number, data3);
                continue;
            }
            if (SWCStringUtils.isEmpty((String)parentTagNumber)) {
                String errorMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7c7b\u522b\u672a\u586b\u5199\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"StatisticsTagSaveValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity2, errorMsg);
                continue;
            }
            DynamicObject parentTag = dependonTagMap.get(parentTagNumber);
            if (parentTag == null || !createOrgIdMap.get(dataEntity2.getDataEntity().getDynamicObject("createorg").getLong("id")).contains(parentTag.getDynamicObject("createorg").getLong("id"))) {
                String errorMsg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u8be5\u4e0a\u7ea7\u7c7b\u522b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"StatisticsTagSaveValidator_9", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity2, errorMsg);
                continue;
            }
            if (!this.checkModify(oldDataMap, dataEntity2) || !this.checkTagLevelAndParentTag(dataEntity2, parentTag)) continue;
            String number = data3.getString("number");
            dependonTagMap.put(number, data3);
        }
    }

    private boolean checkModify(Map<Long, DynamicObject> oldDataMap, ExtendedDataEntity dataEntity) {
        DynamicObject newData = dataEntity.getDataEntity();
        DynamicObject oldData = oldDataMap.get(newData.getLong("id"));
        if (oldData == null) {
            return true;
        }
        if (!dataEntity.getDataEntity().getBoolean(KEY_IS_LEAF)) {
            DynamicObject newTagLevel = newData.getDynamicObject(KEY_TAG_LEVEL);
            Long oldTagLevelId = oldData.getLong("taglevel.id");
            if (newTagLevel == null) {
                return false;
            }
            long newTagLevelId = newTagLevel.getLong("id");
            if (newTagLevelId != oldTagLevelId) {
                String errorMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u7ea7\u7c7b\u522b\uff0c\u65e0\u6cd5\u66f4\u6539\u201c\u7c7b\u522b\u5c42\u7ea7\u201d\u3002", (String)"StatisticsTagSaveValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                return false;
            }
            if (newData.getBoolean(KEY_ENABLE_ADD_JUNIOR) != oldData.getBoolean(KEY_ENABLE_ADD_JUNIOR)) {
                String errorMsg = ResManager.loadKDString((String)"\u5df2\u5b58\u5728\u4e0b\u7ea7\u7c7b\u522b\uff0c\u65e0\u6cd5\u4fee\u6539\u201c\u5141\u8bb8\u589e\u52a0\u4e0b\u7ea7\u7c7b\u522b\u201d\u3002", (String)"StatisticsTagSaveValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(dataEntity, errorMsg);
                return false;
            }
        }
        return true;
    }

    private Map<Long, DynamicObject> collectOldDataMap(Set<Long> oldDataIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
        DynamicObjectCollection oldDatas = helper.queryOriginalCollection("id,taglevel.id,enableaddjunior", new QFilter[]{new QFilter("id", "in", oldDataIdSet)});
        return oldDatas.stream().collect(Collectors.toMap(oldData -> oldData.getLong("id"), oldData -> oldData));
    }

    private Map<Long, Set<Long>> collectCreateOrgIdMap(Set<Long> createOrgIdSet) {
        HashMap<Long, Set<Long>> createOrgIdMap = new HashMap<Long, Set<Long>>(createOrgIdSet.size());
        for (Long createOrgId : createOrgIdSet) {
            List superiorOrgIdList = OrgUnitServiceHelper.getAllSuperiorOrgs((String)"29", (long)createOrgId);
            HashSet<Long> idSet = new HashSet<Long>(superiorOrgIdList);
            idSet.add(createOrgId);
            createOrgIdMap.put(createOrgId, idSet);
        }
        return createOrgIdMap;
    }

    private Map<String, DynamicObject> collectDependonTagMap() {
        DynamicObject[] datas;
        QFilter keyFilter;
        HashMap<String, DynamicObject> dependonTagMap = new HashMap<String, DynamicObject>(this.dataEntities.length);
        HashSet<String> parentTagNumberSet = new HashSet<String>(this.dataEntities.length);
        HashSet<Long> parentTagIdSet = new HashSet<Long>(this.dataEntities.length);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject parentTag = dataEntity.getDataEntity().getDynamicObject(KEY_PARENT_TAG);
            String parentTagNumber = dataEntity.getDataEntity().getString("parenttagnumber");
            if (parentTag != null) {
                parentTagIdSet.add(parentTag.getLong("id"));
            }
            if (!SWCStringUtils.isNotEmpty((String)parentTagNumber)) continue;
            parentTagNumberSet.add(parentTagNumber);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_statisticstag");
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter(KEY_ENABLE_ADD_JUNIOR, "=", (Object)"1"));
        if (!CollectionUtils.isEmpty(parentTagNumberSet) && !CollectionUtils.isEmpty(parentTagIdSet)) {
            keyFilter = new QFilter("number", "in", parentTagNumberSet);
            keyFilter.or(new QFilter("id", "in", parentTagIdSet));
        } else {
            keyFilter = !CollectionUtils.isEmpty(parentTagNumberSet) ? new QFilter("number", "in", parentTagNumberSet) : new QFilter("id", "in", parentTagIdSet);
        }
        filter.and(keyFilter);
        for (DynamicObject data : datas = helper.query("id,number,createorg.id,taglevel.level,areatype,country.id,parent.areatype,parent.country.id,longnumber", new QFilter[]{filter})) {
            dependonTagMap.put(data.getString("number"), data);
        }
        return dependonTagMap;
    }

    private boolean checkAreaTypeAndCountry(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        String areaType = data.getString("areatype");
        DynamicObject country = data.getDynamicObject("country");
        if ("1".equals(areaType)) {
            data.set("country", null);
        } else if (country == null) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6b63\u786e\u586b\u5199\u56fd\u5bb6/\u5730\u533a\u5185\u5bb9\u3002", (String)"StatisticsTagSaveValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        return true;
    }

    private boolean checkTagLevelAndParentTag(ExtendedDataEntity dataEntity, DynamicObject parentTag) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObject tagLevel = data.getDynamicObject(KEY_TAG_LEVEL);
        if (tagLevel.getInt(KEY_LEVEL) == 1) {
            return true;
        }
        int parentTagLevel = parentTag.getInt("taglevel.level");
        if (parentTagLevel + 1 != tagLevel.getInt(KEY_LEVEL)) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7c7b\u522b\u7684\u7c7b\u522b\u5c42\u7ea7\u4e0e\u85aa\u916c\u9879\u76ee\u7edf\u8ba1\u7c7b\u522b\u7684\u7c7b\u522b\u5c42\u7ea7\u4e0d\u5339\u914d\uff0c\u5e94\u586b\u5199\u5f53\u524d\u5c42\u7ea7\u7684\u4e0a\u4e00\u7ea7\u7c7b\u522b\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"StatisticsTagSaveValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        String areaType = parentTag.getString("areatype");
        if ("2".equals(areaType) && parentTag.getLong("country.id") != data.getLong("country.id")) {
            String errorMsg = ResManager.loadKDString((String)"\u4e0a\u7ea7\u7c7b\u522b\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u85aa\u916c\u9879\u76ee\u7edf\u8ba1\u7c7b\u522b\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u5339\u914d\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"StatisticsTagSaveValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(dataEntity, errorMsg);
            return false;
        }
        return true;
    }

    private boolean checkNumberAndName(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        String name = data.getString("name");
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name)) {
            String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"StatisticsTagSaveValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"StatisticsTagSaveValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
            return false;
        }
        String number = data.getString("number");
        if (StringCheckUtils.checkNumberIsContainJavaVariableForbidChar((String)number)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u548c\u7279\u6b8a\u5b57\u7b26\u3002", (String)"StatisticsTagSaveValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }
}

