/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.basedata.supportitem;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.item.utils.ItemDataUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class SupportItemValidator
extends SWCDataBaseValidator {
    public void validate() {
        String operateKey;
        switch (operateKey = this.getOperateKey()) {
            case "save": {
                List<Long> idList = this.checkNumber();
                this.checkImportData(idList);
                break;
            }
            case "submit": {
                this.checkNumber();
                break;
            }
        }
    }

    private void checkImportData(List<Long> idList) {
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        if (StringUtils.equals((CharSequence)isSave, (CharSequence)Boolean.TRUE.toString())) {
            return;
        }
        DynamicObject[] existData = null;
        if (idList.size() > 0) {
            SWCDataServiceHelper supportHelper = new SWCDataServiceHelper("hsbs_supportitem");
            String fields = "country,datatype,enable";
            existData = supportHelper.query(fields, new QFilter[]{new QFilter("id", "in", idList)});
        }
        Map<Long, DynamicObject> existMap = this.arrayToMap(existData);
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject existObj = null;
        String defaultValue = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            String areaType = obj.getString("areatype");
            long countryId = obj.getLong("country.id");
            if (SWCStringUtils.equals((String)areaType, (String)"1") && countryId != 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e0d\u9700\u8981\u586b\u5199\u3002", (String)"SupportItemValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
            if (SWCStringUtils.equals((String)areaType, (String)"2") && countryId == 0L) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u5fc5\u586b\u3002", (String)"SupportItemValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
            if (null != (existObj = existMap.get(obj.getLong("id")))) {
                this.checkFieldIsModify(existObj, obj, dataEntity);
            }
            defaultValue = obj.getString("defaultValue");
            long dataTypeId = obj.getLong("datatype.id");
            if (dataTypeId == 1010L) {
                obj.set("datalength", (Object)0);
                if (!this.checkIsNumber(defaultValue)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u9ed8\u8ba4\u503c\u5fc5\u987b\u662f\u6570\u503c\u7c7b\u578b\u3002", (String)"SupportItemValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (!SWCStringUtils.isNotEmpty((String)defaultValue)) continue;
                BigDecimal defaultResult = new BigDecimal(defaultValue);
                BigDecimal value = defaultResult.stripTrailingZeros();
                if (value.precision() - value.scale() > 13 || value.scale() > 10) {
                    this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5b57\u6bb5\u9ed8\u8ba4\u503c\u7684\u503c%s\u683c\u5f0f\u4e0d\u6b63\u786e\u3002\u6574\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc713\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u4e0d\u80fd\u8d85\u8fc710\u4f4d\u3002", (String)"SupportItemValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), defaultValue));
                    continue;
                }
                defaultResult = defaultResult.setScale(obj.getInt("dataprecision.scale"), ItemDataUtils.getRoundingMode((long)obj.getLong("dataround.id")));
                obj.set("defaultValue", (Object)defaultResult.toPlainString());
                continue;
            }
            if (dataTypeId == 1030L) {
                int dataLength = obj.getInt("datalength");
                if (dataLength <= 0) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u65f6\uff0c\u6570\u636e\u957f\u5ea6\u503c\u4e0d\u80fd\u4e3a\u7a7a\u62160\u3002", (String)"SupportItemValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                } else {
                    this.checkValueLength(dataEntity, defaultValue, dataLength);
                }
                obj.set("dataprecision", null);
                obj.set("dataround", null);
                continue;
            }
            if (dataTypeId == 1050L) {
                obj.set("dataprecision", null);
                obj.set("dataround", null);
                obj.set("datalength", (Object)0);
                if (this.checkIsDate(defaultValue)) continue;
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u65e5\u671f\u65f6\uff0c\u9ed8\u8ba4\u503c\u5fc5\u987b\u662f\u65e5\u671f\u7c7b\u578b\u3002", (String)"SupportItemValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (dataTypeId != 1020L) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u53ea\u80fd\u662f\u6570\u503c\u3001\u6587\u672c\u6216\u8005\u65e5\u671f\u3002", (String)"SupportItemValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkValueLength(ExtendedDataEntity dataEntity, String defaultValue, int dataLength) {
        if (SWCStringUtils.isEmpty((String)defaultValue)) {
            return;
        }
        if (defaultValue.length() > dataLength) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u9ed8\u8ba4\u503c\u4e0d\u80fd\u8d85\u8fc7\u652f\u6301\u9879\u76ee\u8bbe\u7f6e\u7684\u6570\u636e\u957f\u5ea6\u3002", (String)"SupportItemValidator_17", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean checkIsNumber(String defaultValue) {
        boolean flag = true;
        if (SWCStringUtils.isEmpty((String)defaultValue)) {
            return flag;
        }
        try {
            new BigDecimal(defaultValue);
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private boolean checkIsDate(String defaultValue) {
        boolean flag = true;
        if (SWCStringUtils.isEmpty((String)defaultValue)) {
            return flag;
        }
        try {
            SWCDateTimeUtils.parseDate((String)defaultValue, (String)"yyyy-MM-dd");
        }
        catch (Exception e) {
            flag = false;
        }
        return flag;
    }

    private void checkFieldIsModify(DynamicObject existObj, DynamicObject obj, ExtendedDataEntity dataEntity) {
        if (existObj.getLong("country.id") != obj.getLong("country.id")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SupportItemValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
        if (SWCStringUtils.equals((String)"1", (String)existObj.getString("enable")) && existObj.getLong("datatype.id") != obj.getLong("datatype.id")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4f7f\u7528\u72b6\u6001\u4e3a\u201c\u53ef\u7528\u201d\u65f6\uff0c\u6570\u636e\u7c7b\u578b\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"SupportItemValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, DynamicObject> arrayToMap(DynamicObject[] existData) {
        HashMap<Long, DynamicObject> map = new HashMap<Long, DynamicObject>(16);
        if (existData == null || existData.length == 0) {
            return map;
        }
        for (DynamicObject obj : existData) {
            map.put(obj.getLong("id"), obj);
        }
        return map;
    }

    private List<Long> checkNumber() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        ArrayList<Long> idList = new ArrayList<Long>(10);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String number;
            DynamicObject obj = dataEntity.getDataEntity();
            if (obj.getLong("id") != 0L) {
                idList.add(obj.getLong("id"));
            }
            if (StringCheckUtils.checkNumberIsContainJavaVariableForbidChar((String)(number = obj.getString("number")))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7f16\u7801\u4e0d\u80fd\u5305\u542b\u7a7a\u683c\u548c\u7279\u6b8a\u5b57\u7b26", (String)"SupportItemValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
            if (StringCheckUtils.checkNameIsContainSpecialChar((String)obj.getString("name"))) {
                String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"SupportItemValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"SupportItemValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg);
            }
            String areaType = obj.getString("areatype");
            long countryId = obj.getLong("country.id");
            if (countryId != 0L || !"2".equals(areaType)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u5fc5\u586b\u3002", (String)"SupportItemValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
        return idList;
    }
}

