/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.bizdatadim;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCArrayUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class BizDataDimValidator
extends SWCDataBaseValidator {
    private static final Log logger = LogFactory.getLog(BizDataDimValidator.class);

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        Object[] extendedDataEntities = this.getDataEntities();
        if (SWCArrayUtils.isEmpty((Object[])extendedDataEntities)) {
            return;
        }
        switch (operateKey) {
            case "save": {
                this.saveValildator((ExtendedDataEntity[])extendedDataEntities);
                break;
            }
        }
    }

    private void saveValildator(ExtendedDataEntity[] extendedDataEntities) {
        this.checkPayrollGrpValid(extendedDataEntities);
        Set<Long> pkIds = this.getPkIds(extendedDataEntities);
        Map<Long, DynamicObject> dbDataMap = new HashMap<Long, DynamicObject>(16);
        if (!CollectionUtils.isEmpty(pkIds)) {
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizdatadim");
            QFilter filter = new QFilter("id", "in", pkIds);
            DynamicObject[] bizDataDimArr = helper.query("number, payrollgroup, org", new QFilter[]{filter});
            dbDataMap = Arrays.stream(bizDataDimArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        }
        this.checkPayrollGrpPerm(extendedDataEntities);
        this.checkPayrollGrpChanged(dbDataMap, extendedDataEntities);
    }

    private void checkPayrollGrpValid(ExtendedDataEntity[] extendedDataEntities) {
        List payrollGrpIds = Arrays.stream(extendedDataEntities).map(entity -> entity.getDataEntity().getLong("payrollgroup.id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(payrollGrpIds)) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u4e3a{0}\u7684\u85aa\u8d44\u6838\u7b97\u7ec4\u3002", (String)"BizDataDimValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
        QFilter filter = new QFilter("id", "in", payrollGrpIds);
        SWCDataServiceHelper payrollGrpHelper = new SWCDataServiceHelper("hsas_payrollgrp");
        DynamicObject[] payrollGrpArr = payrollGrpHelper.query("id, enable, status", new QFilter[]{filter});
        Map<Long, DynamicObject> payrollGrpMap = Arrays.stream(payrollGrpArr).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject payrollGrp = payrollGrpMap.get(dataEntity.getLong("payrollgroup.id"));
            if (null != payrollGrp && !"0".equals(payrollGrp.getString("enable")) && "C".equals(payrollGrp.getString("status"))) continue;
            this.addErrorMessage(extendedDataEntity, MessageFormat.format(errorMsg, dataEntity.getString("payrollgroup.number")));
        }
    }

    private void checkPayrollGrpPerm(ExtendedDataEntity[] extendedDataEntities) {
        boolean hasAllPayrollGrpPerm;
        Set hasPermPayrollGrpIds = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim", (String)"47150e89000000ac");
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"/UHLXNRR9KPZ", (String)"hsbs_bizdatadim");
        boolean bl = hasAllPayrollGrpPerm = null == hasPermPayrollGrpIds;
        if (hasAllPayrollGrpPerm && hasPermOrgResult.hasAllOrgPerm()) {
            logger.info("================Current Operator has all payrollGroup perm");
            return;
        }
        HashSet hasPermOrgs = new HashSet(hasPermOrgResult.getHasPermOrgs());
        String errorMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5bf9\u5e94\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6743\u9650\u3002", (String)"BizDataDimValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
        String errorOrgMsg = ResManager.loadKDString((String)"\u60a8\u6ca1\u6709\u5bf9\u5e94\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6743\u9650\u3002", (String)"BizDataDimValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObject payrollGrp = dataEntity.getDynamicObject("payrollgroup");
            if (SWCObjectUtils.isEmpty((Object)payrollGrp)) continue;
            if (!hasAllPayrollGrpPerm && !hasPermPayrollGrpIds.contains(payrollGrp.getLong("id"))) {
                this.addErrorMessage(extendedDataEntity, errorMsg);
                continue;
            }
            if (hasPermOrgResult.hasAllOrgPerm() || hasPermOrgs.contains(payrollGrp.getLong("org.id"))) continue;
            this.addErrorMessage(extendedDataEntity, errorOrgMsg);
        }
    }

    private void checkPayrollGrpChanged(Map<Long, DynamicObject> dbDataMap, ExtendedDataEntity[] extendedDataEntities) {
        if (dbDataMap.isEmpty()) {
            return;
        }
        String errorMsg = ResManager.loadKDString((String)"\u66f4\u65b0\u5bfc\u5165\u4e0d\u53ef\u4fee\u6539\u85aa\u8d44\u6838\u7b97\u7ec4", (String)"BizDataDimValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (!dbDataMap.containsKey(dataEntity.getLong("id")) || SWCObjectUtils.isEmpty((Object)dataEntity.getDynamicObject("payrollgroup")) || SWCObjectUtils.equals((Object)dataEntity.getDynamicObject("payrollgroup"), (Object)dbDataMap.get(dataEntity.getLong("id")).getDynamicObject("payrollgroup"))) continue;
            this.addErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private Set<Long> getPkIds(ExtendedDataEntity[] extendedDataEntities) {
        HashSet<Long> pkIds = new HashSet<Long>(extendedDataEntities.length);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            if (SWCObjectUtils.isEmpty((Object)dataEntity)) continue;
            pkIds.add(dataEntity.getLong("id"));
        }
        return pkIds;
    }
}

