/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.bizitem;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.BizItemConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCNumberValidateUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.common.enums.DataTypeEnum;
import kd.swc.hsbs.service.BizItemService;

public class BizItemValidator
extends SWCDataBaseValidator {
    public final Log log = LogFactory.getLog(BizItemValidator.class);
    private static final Set<String> NUMTYPESET = Stream.of("3", "4", "5", "6", "1", "2").collect(Collectors.toSet());
    private static final Set<String> TEXTTYPESET = Stream.of("1", "2").collect(Collectors.toSet());
    private static final int ADDPROP_MAXCOUNT = 50;

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, DynamicObject> allDataMap = null;
        switch (operateKey) {
            case "save": {
                allDataMap = this.getAllDataMap(dataEntities);
                this.saveValidator(allDataMap);
                this.checkImportData(allDataMap);
                break;
            }
            case "submit": {
                allDataMap = this.getAllDataMap(dataEntities);
                this.saveValidator(allDataMap);
                break;
            }
            case "delete": {
                this.deleteValidator(dataEntities);
                break;
            }
        }
    }

    private void checkImportData(Map<Long, DynamicObject> allDataMap) {
        Map variables = this.getOption().getVariables();
        String isSave = (String)variables.get("save");
        if (StringUtils.equals((CharSequence)isSave, (CharSequence)Boolean.TRUE.toString())) {
            return;
        }
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        DynamicObject data = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            data = dataEntity.getDataEntity();
            this.checkAreaType(allDataMap.get(data.getLong("id")), data, dataEntity);
            this.checkImportVal(allDataMap.get(data.getLong("id")), data, dataEntity);
            this.checkMaxInputCount(dataEntity);
        }
    }

    private void checkMaxInputCount(ExtendedDataEntity dataEntity) {
        DynamicObject data = dataEntity.getDataEntity();
        String multipleinput = data.getString("multipleinput");
        if (!SWCStringUtils.equals((String)multipleinput, (String)"1")) {
            int maxImputCount = data.getInt("maxinputtime");
            boolean isCycle = data.getBoolean("cycle");
            if (isCycle) {
                if (maxImputCount != 0) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u6b21\u8f93\u5165\u4e3a\u5426\uff0c\u4e0d\u80fd\u7ef4\u62a4\u6700\u5927\u8f93\u5165\u6b21\u6570\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_59", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
            } else if (maxImputCount != 0 && maxImputCount != 1) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u6b21\u8f93\u5165\u4e3a\u5426\uff0c\u4e0d\u80fd\u7ef4\u62a4\u6700\u5927\u8f93\u5165\u6b21\u6570\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_59", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
    }

    private void checkImportVal(DynamicObject oldData, DynamicObject data, ExtendedDataEntity dataEntity) {
        DynamicObjectCollection mutiCurrencyColl;
        int dataLength;
        Long dataTypeId = data.getLong("datatype.id");
        if (dataTypeId == null) {
            return;
        }
        if (dataTypeId != 1030L && (dataLength = data.getInt("datalength")) != 0) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6587\u672c\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u6570\u636e\u957f\u5ea6\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_62", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
        if (dataTypeId != 1010L) {
            String inputMinVal = data.getString("inputminval");
            String inputMaxVal = data.getString("inputmaxval");
            String scaleLimit = data.getString("scalelimit");
            if (SWCStringUtils.isNotEmpty((String)inputMinVal) || SWCStringUtils.isNotEmpty((String)inputMaxVal) || SWCStringUtils.isNotEmpty((String)scaleLimit)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u6570\u503c\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u5c0f/\u6700\u5927\u503c\u548c\u5c0f\u6570\u4f4d\u6570\u9650\u5236\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_61", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
        if (dataTypeId != 1050L) {
            Date earliesDate = data.getDate("earliestdate");
            Date lastDate = data.getDate("lastdate");
            if (earliesDate != null || lastDate != null) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u65e5\u671f\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u6700\u65e9/\u6700\u665a\u65e5\u671f\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_60", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
        if (dataTypeId != 1020L && (mutiCurrencyColl = data.getDynamicObjectCollection("currency")) != null && mutiCurrencyColl.size() > 0) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u975e\u91d1\u989d\u7c7b\u578b\u4e0d\u652f\u6301\u8bbe\u7f6e\u53ef\u8f93\u5165\u5e01\u79cd\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_37", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private boolean checkMaxValueAndMinValueIsNumeric(DynamicObject data, ExtendedDataEntity dataEntity) {
        String maxValue = data.getString("inputmaxval");
        if (!maxValue.isEmpty() && !SWCNumberValidateUtils.isRealNumber((String)maxValue)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizItemValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            return false;
        }
        String minValue = data.getString("inputminval");
        if (!minValue.isEmpty() && !SWCNumberValidateUtils.isRealNumber((String)minValue)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002", (String)"AttBizItemValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            return false;
        }
        return true;
    }

    private void checkParam(DynamicObject data, ExtendedDataEntity dataEntity) {
        String multipleinput = data.getString("multipleinput");
        if (SWCStringUtils.equals((String)"1", (String)data.getString("cycle"))) {
            boolean result = true;
            if (!SWCStringUtils.equals((String)multipleinput, (String)"0")) {
                result = false;
            } else if (data.getInt("maxinputtime") > 1) {
                result = false;
            } else if (!SWCStringUtils.equals((String)data.getString("consumemethod"), (String)"1")) {
                result = false;
            } else if (SWCStringUtils.equals((String)data.getString("islistgenerate"), (String)"1")) {
                result = false;
            }
            if (!result) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u5faa\u73af\u7684\u4e1a\u52a1\u9879\u76ee\uff0c\u8bf7\u6307\u5b9a\u201c\u591a\u6b21\u8f93\u5165\u201d\u4e3a\u201c\u5426\u201d\u3001 \u201c\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u201d\u4e3a\u201c\u6700\u65b0\u201d\u3001\u201c\u6700\u5927\u8f93\u5165\u6b21\u6570\u201d\u52ff\u586b\u5199\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3001\u201c\u7528\u4e8e\u540d\u5355\u751f\u6210\u201d\u4e3a\u201c\u5426\u201d\u3002", (String)"BizItemValidator_57", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        } else {
            this.checkConsumeMethod(data, dataEntity);
        }
    }

    private void checkConsumeMethod(DynamicObject data, ExtendedDataEntity dataEntity) {
        String dataTypeName = data.getString("datatype.name");
        if (SWCStringUtils.isEmpty((String)dataTypeName)) {
            return;
        }
        String consumeMethod = data.getString("consumemethod");
        boolean isCycle = data.getBoolean("cycle");
        if (SWCStringUtils.isEmpty((String)consumeMethod)) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u5fc5\u586b\u3002", (String)"BizItemValidator_17", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
        if (!isCycle) {
            if (dataTypeName.equals(DataTypeEnum.DATE.getDesc()) || dataTypeName.equals(DataTypeEnum.TEXT.getDesc())) {
                if (!TEXTTYPESET.contains(consumeMethod)) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u3001\u65e5\u671f\u65f6\uff0c\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u6700\u65b0\u3001\u6700\u65e9\u3002", (String)"BizItemValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
            } else if (!NUMTYPESET.contains(consumeMethod)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u3001\u91d1\u989d\u65f6\uff0c\u8ba1\u7b97\u53d6\u503c\u65b9\u5f0f\u53ea\u80fd\u9009\u62e9\u6700\u5927\u3001\u6700\u5c0f\u3001\u6c47\u603b\u3001\u5e73\u5747\u3001\u6700\u65b0\u3001\u6700\u65e9\u3002", (String)"BizItemValidator_19", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
    }

    private void saveValidator(Map<Long, DynamicObject> allDataMap) {
        this.buildMaxAndMinInputData(this.dataEntities);
        DynamicObject data = null;
        HashMap<Long, Map<String, BigDecimal>> bizItemGroupSubmitValMap = new HashMap<Long, Map<String, BigDecimal>>(16);
        HashMap<Long, Map<String, Date>> bizItemGroupSubmitDateMap = new HashMap<Long, Map<String, Date>>(16);
        this.getBizItemGroupSubmitDatas(allDataMap, bizItemGroupSubmitValMap, bizItemGroupSubmitDateMap);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            data = dataEntity.getDataEntity();
            if (!this.checkEnabledModify(dataEntity, allDataMap)) continue;
            this.checkData(data, dataEntity);
            this.checkParam(data, dataEntity);
            this.checkSalaryStd(data, dataEntity);
            this.checkPropCount(data, dataEntity);
            if (StringCheckUtils.checkNameIsContainSpecialChar((String)data.getString("name"), (List)BizItemConstants.SPECIAL_CHAR_LIST)) {
                String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c\u3010\u201d\u3001\u201c\u3011\u201d\u3001\u201c]\u201d\u3002", (String)"BizItemValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"BizItemValidator_63", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
            }
            this.checkSubmitValAndDate(data, dataEntity, bizItemGroupSubmitValMap, bizItemGroupSubmitDateMap);
        }
    }

    private void buildMaxAndMinInputData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String maxValStr;
            long dataTypeId;
            DynamicObject bizItemObj = dataEntity.getDataEntity();
            if (bizItemObj == null || (dataTypeId = bizItemObj.getLong("datatype.id")) != 1010L) continue;
            String minValStr = bizItemObj.getString("inputminval");
            if (SWCStringUtils.isNotEmpty((String)minValStr)) {
                try {
                    BigDecimal minVal = new BigDecimal(minValStr);
                    bizItemObj.set("isminvalnull", (Object)"0");
                    bizItemObj.set("minvalue", (Object)minVal);
                }
                catch (Exception e) {
                    this.log.info("transfer minVal fail!");
                }
            }
            if (!SWCStringUtils.isNotEmpty((String)(maxValStr = bizItemObj.getString("inputmaxval")))) continue;
            try {
                BigDecimal maxVal = new BigDecimal(maxValStr);
                bizItemObj.set("ismaxvalnull", (Object)"0");
                bizItemObj.set("maxvalue", (Object)maxVal);
            }
            catch (Exception e) {
                this.log.info("transfer maxVal fail!");
            }
        }
    }

    private void checkSubmitValAndDate(DynamicObject data, ExtendedDataEntity dataEntity, Map<Long, Map<String, BigDecimal>> bizItemGroupSubmitValMap, Map<Long, Map<String, Date>> bizItemGroupSubmitDateMap) {
        Long bizItemId = data.getLong("id");
        if (bizItemId == null || bizItemId == 0L) {
            return;
        }
        Long dataTypeId = data.getLong("datatype.id");
        if (dataTypeId == 1010L) {
            this.checkSubmitVal(bizItemId, data, dataEntity, bizItemGroupSubmitValMap);
            return;
        }
        if (dataTypeId == 1050L) {
            this.checkSubmitDate(bizItemId, data, dataEntity, bizItemGroupSubmitDateMap);
            return;
        }
    }

    private void checkSubmitDate(Long bizItemId, DynamicObject data, ExtendedDataEntity dataEntity, Map<Long, Map<String, Date>> bizItemGroupSubmitDateMap) {
        String errorMsg;
        String errorMsgStr;
        Map<String, Date> submitDateMap = bizItemGroupSubmitDateMap.get(bizItemId);
        if (submitDateMap == null || submitDateMap.size() == 0) {
            return;
        }
        Date earliestDate = data.getDate("earliestdate");
        Date lastDate = data.getDate("lastdate");
        Date submitStartDate = submitDateMap.get("submitStartDate");
        Date submitEndDate = submitDateMap.get("submitEndDate");
        if (earliestDate != null && submitStartDate != null && earliestDate.compareTo(submitStartDate) > 0) {
            errorMsgStr = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u63d0\u62a5\u6700\u65e9/\u6700\u665a\u65e5\u671f\u4e3a\u201c{0}\u201d\uff0c\u8bf7\u786e\u4fdd\u201c\u6700\u65e9\u65e5\u671f\u201d\u4e0d\u665a\u4e8e\u6b64\u3002", (String)"BizItemValidator_54", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, SWCDateTimeUtils.format((Date)submitStartDate, (String)"yyyy-MM-dd"));
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
        if (lastDate != null && submitEndDate != null && lastDate.compareTo(submitEndDate) < 0) {
            errorMsgStr = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u63d0\u62a5\u6700\u65e9/\u6700\u665a\u65e5\u671f\u4e3a\u201c{0}\u201d\uff0c\u8bf7\u786e\u4fdd\u201c\u6700\u665a\u65e5\u671f\u201d\u4e0d\u65e9\u4e8e\u6b64\u3002", (String)"BizItemValidator_55", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, SWCDateTimeUtils.format((Date)submitEndDate, (String)"yyyy-MM-dd"));
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }

    private void checkSubmitVal(Long bizItemId, DynamicObject data, ExtendedDataEntity dataEntity, Map<Long, Map<String, BigDecimal>> bizItemGroupSubmitValMap) {
        String errorMsg;
        String errorMsgStr;
        Map<String, BigDecimal> submitValMap = bizItemGroupSubmitValMap.get(bizItemId);
        if (submitValMap == null || submitValMap.size() == 0) {
            return;
        }
        BigDecimal minVal = null;
        String isMinValNull = data.getString("isminvalnull");
        if (!SWCStringUtils.equals((String)isMinValNull, (String)"1")) {
            minVal = data.getBigDecimal("minvalue");
        }
        BigDecimal maxVal = null;
        String isMaxValNull = data.getString("ismaxvalnull");
        if (!SWCStringUtils.equals((String)isMaxValNull, (String)"1")) {
            maxVal = data.getBigDecimal("maxvalue");
        }
        if (minVal == null && maxVal == null) {
            return;
        }
        String scaleLimit = data.getString("scalelimit");
        int scale = Integer.parseInt(scaleLimit);
        BigDecimal submitMinVal = submitValMap.get("submitMinValue");
        BigDecimal submitMaxVal = submitValMap.get("submitMaxValue");
        if (minVal != null && submitMinVal != null && minVal.compareTo(submitMinVal) > 0) {
            errorMsgStr = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u63d0\u62a5\u6700\u5927/\u6700\u5c0f\u8f93\u5165\u503c\u4e3a\u201c{0}\u201d\uff0c\u8bf7\u786e\u4fdd\u201c\u6700\u5c0f\u8f93\u5165\u503c\u201d\u4e0d\u5927\u4e8e\u6b64\u6570\u3002", (String)"BizItemValidator_56", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, submitMinVal.setScale(scale, 4).toPlainString());
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
        if (maxVal != null && submitMaxVal != null && maxVal.compareTo(submitMaxVal) < 0) {
            errorMsgStr = ResManager.loadKDString((String)"\u4e1a\u52a1\u6570\u636e\u6a21\u677f\u9650\u5b9a\u7684\u63d0\u62a5\u6700\u5927/\u6700\u5c0f\u8f93\u5165\u503c\u4e3a\u201c{0}\u201d\uff0c\u8bf7\u786e\u4fdd\u201c\u6700\u5927\u8f93\u5165\u503c\u201d\u4e0d\u5c0f\u4e8e\u6b64\u6570\u3002", (String)"BizItemValidator_53", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            errorMsg = MessageFormat.format(errorMsgStr, submitMaxVal.setScale(scale, 4).toPlainString());
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }

    private void getBizItemGroupSubmitDatas(Map<Long, DynamicObject> allDataMap, Map<Long, Map<String, BigDecimal>> bizItemGroupSubmitValMap, Map<Long, Map<String, Date>> bizItemGroupSubmitDateMap) {
        Set<Long> bizItemIdSet = allDataMap.keySet();
        BizItemService service = new BizItemService();
        service.getBizItemGroupSubmitVal(bizItemIdSet, bizItemGroupSubmitValMap);
        service.getBizItemGroupSubmitDate(bizItemIdSet, bizItemGroupSubmitDateMap);
    }

    private void checkPropCount(DynamicObject data, ExtendedDataEntity dataEntity) {
        boolean isExtProp = data.getBoolean("isextprop");
        if (isExtProp) {
            DynamicObjectCollection bizItemPropColl = data.getDynamicObjectCollection("bizitempropentry");
            if (bizItemPropColl == null || bizItemPropColl.size() == 0) {
                String errorMsg = ResManager.loadKDString((String)"\u8bf7\u6dfb\u52a0\u81f3\u5c11\u4e00\u4e2a\u4e1a\u52a1\u9879\u76ee\u5c5e\u6027\u3002", (String)"BizItemValidator_30", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return;
            }
            if (bizItemPropColl.size() > 50) {
                String errorMsg = ResManager.loadKDString((String)"\u6700\u591a\u652f\u6301\u6dfb\u52a050\u4e2a\u5173\u8054\u5c5e\u6027\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BizItemValidator_31", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return;
            }
        }
    }

    private void checkSalaryStd(DynamicObject data, ExtendedDataEntity dataEntity) {
        String cycle = data.getString("cycle");
        String issalarystd = data.getString("issalarystd");
        if (SWCStringUtils.equals((String)cycle, (String)"0") && SWCStringUtils.equals((String)issalarystd, (String)"1")) {
            String errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u4e3a\u975e\u5faa\u73af\u9879\u76ee\u65f6\uff0c\u201c\u85aa\u916c\u6807\u51c6\u201d\u5fc5\u987b\u4e3a\u5426\u3002", (String)"BizItemValidator_29", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }

    private void checkData(DynamicObject data, ExtendedDataEntity dataEntity) {
        String dataType = data.getString("datatype.name");
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return;
        }
        if (dataType.equals(DataTypeEnum.TEXT.getDesc())) {
            Integer dataLength = (Integer)data.get("datalength");
            if (dataLength == null || dataLength <= 0 || dataLength > 255) {
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u65f6\uff0c\u6570\u636e\u957f\u5ea6\u7684\u6570\u503c\u8303\u56f4\u4e3a(0,255]\u3002", (String)"BizItemValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return;
            }
        } else if (dataType.equals(DataTypeEnum.DATE.getDesc())) {
            Date earliestDate = data.getDate("earliestdate");
            Date lastDate = data.getDate("lastdate");
            if (earliestDate != null && lastDate != null && lastDate.before(earliestDate)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u665a\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6700\u65e9\u65e5\u671f\u3002", (String)"BizItemValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                return;
            }
        } else if (dataType.equals(DataTypeEnum.NUMBERIC.getDesc()) && this.checkMaxValueAndMinValueIsNumeric(data, dataEntity)) {
            String scaleLimit;
            String maxValue = data.getString("inputmaxval");
            String minValue = data.getString("inputminval");
            String regx1 = "-0(\\.0*)?";
            String regx2 = "^([+,-])?(([1-9]{1}\\d{0,12})|(0{1}))(\\.\\d{0,10})?$";
            if (!maxValue.isEmpty() && (maxValue.matches(regx1) || !maxValue.matches(regx2)) || !minValue.isEmpty() && (minValue.matches(regx1) || !minValue.matches(regx2))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002\u6574\u6570\u90e8\u5206\u6700\u5927\u4e3a13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u6700\u5927\u4e3a10\u4f4d\u3002", (String)"BizItemValidator_22", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (!SWCStringUtils.isEmpty((String)(scaleLimit = data.getString("scalelimit")))) {
                int maxValueScale;
                int minValueScale;
                int scaleLimitVal = Integer.parseInt(scaleLimit);
                if (!SWCStringUtils.isEmpty((String)minValue) && (minValueScale = new BigDecimal(minValue).scale()) > scaleLimitVal) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemValidator_24", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
                if (!SWCStringUtils.isEmpty((String)maxValue) && (maxValueScale = new BigDecimal(maxValue).scale()) > scaleLimitVal) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemValidator_25", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
            } else {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u201c\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u201d\u5fc5\u586b\u3002", (String)"BizItemValidator_27", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (!maxValue.isEmpty() && !minValue.isEmpty() && new BigDecimal(maxValue).compareTo(new BigDecimal(minValue)) < 0) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u53ef\u5c0f\u4e8e\u6700\u5c0f\u8f93\u5165\u503c\u3002", (String)"BizItemValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
        }
        String multipleinput = data.getString("multipleinput");
        int maxinputtime = data.getInt("maxinputtime");
        if (SWCStringUtils.equals((String)multipleinput, (String)"1") && maxinputtime < 2) {
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u591a\u6b21\u8f93\u5165\u503c\u4e3a\u201c\u662f\u201d\u65f6\uff0c\u8bf7\u586b\u5199\u6700\u5927\u8f93\u5165\u6b21\u6570\u503c\u4e0d\u5c0f\u4e8e2\u7684\u6574\u6570\u3002", (String)"BizItemValidator_20", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void checkAreaType(DynamicObject oldData, DynamicObject data, ExtendedDataEntity dataEntity) {
        String errorMsg = null;
        if (oldData != null && !SWCStringUtils.equals((String)data.getString("areatype"), (String)oldData.getString("areatype"))) {
            errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u3002", (String)"BizItemValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return;
        }
        if (oldData != null && data.getLong("country.id") != oldData.getLong("country.id")) {
            errorMsg = ResManager.loadKDString((String)"\u4e0d\u53ef\u66f4\u65b0\u56fd\u5bb6/\u5730\u533a\u3002", (String)"BizItemValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return;
        }
        if ("2".equals(data.getString("areatype"))) {
            if (data.getDynamicObject("country") == null || data.getLong("country.id") == 0L) {
                errorMsg = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u6307\u5b9a\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e0d\u53ef\u4e3a\u7a7a\u3002", (String)"BizItemValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                return;
            }
        } else if (data.getDynamicObject("country") != null && data.getLong("country.id") != 0L) {
            errorMsg = ResManager.loadKDString((String)"\u56fd\u5bb6/\u5730\u533a\u7c7b\u578b\u4e3a\u901a\u7528\u65f6\uff0c\u56fd\u5bb6/\u5730\u533a\u4e0d\u53ef\u5f55\u5165\uff08\u66f4\u65b0\u5bfc\u5165\u8bf7\u586b\u5199NULL\uff09\u3002", (String)"BizItemValidator_58", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            return;
        }
    }

    private Map<Long, DynamicObject> getAllDataMap(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        List dataIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitem");
        QFilter filter = new QFilter("id", "in", dataIdList);
        filter.and("enable", "in", (Object)new String[]{"1", "10"});
        DynamicObject[] unabledChangeDataArray = helper.query("id,bizitemcategory.id,applylevel,datatype.id,areatype,country.id,enable,datalength,cycle,oneoffconsume,classification", new QFilter[]{filter});
        if (unabledChangeDataArray == null || unabledChangeDataArray.length == 0) {
            return new HashMap<Long, DynamicObject>(0);
        }
        return Arrays.stream(unabledChangeDataArray).collect(Collectors.toMap(unabledChangeData -> unabledChangeData.getLong("id"), unabledChangeData -> unabledChangeData));
    }

    private boolean checkEnabledModify(ExtendedDataEntity dataEntity, Map<Long, DynamicObject> allDataMap) {
        DynamicObject data = dataEntity.getDataEntity();
        long dataId = data.getLong("id");
        boolean tag = true;
        if (!allDataMap.containsKey(dataId) || SWCStringUtils.equals((String)"10", (String)data.getString("enable"))) {
            return tag;
        }
        String errorMsg = null;
        DynamicObject oldData = allDataMap.get(dataId);
        if (SWCStringUtils.equals((String)"1", (String)oldData.getString("classification"))) {
            errorMsg = ResManager.loadKDString((String)"\u6b64\u9879\u76ee\u4e3a\u201c\u8003\u52e4\u4e1a\u52a1\u9879\u76ee\u201d\uff0c\u4e0d\u53ef\u5728\u4e1a\u52a1\u9879\u76ee\u5217\u8868\u9875\u9762\u66f4\u65b0\u3002", (String)"BizItemValidator_52", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (data.getLong("datatype.id") != oldData.getLong("datatype.id")) {
            errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u201c\u6570\u636e\u7c7b\u578b\u201d\u3002", (String)"BizItemValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (data.getInt("datalength") != oldData.getInt("datalength")) {
            errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u201c\u6570\u636e\u957f\u5ea6\u201d\u3002", (String)"BizItemValidator_50", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        } else if (!StringUtils.equals((CharSequence)data.getString("cycle"), (CharSequence)oldData.getString("cycle"))) {
            errorMsg = ResManager.loadKDString((String)"\u4e1a\u52a1\u9879\u76ee\u5df2\u542f\u7528\uff0c\u4e0d\u53ef\u66f4\u65b0\u201c\u5faa\u73af\u201d\u5b57\u6bb5\u5c5e\u6027\u3002", (String)"BizItemValidator_51", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
            tag = false;
        }
        return tag;
    }

    private void deleteValidator(ExtendedDataEntity[] dataEntities) {
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        ArrayList<Long> recurIdList = new ArrayList<Long>(dataEntities.length);
        ArrayList<Long> nonRecurIdList = new ArrayList<Long>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject dataObj = dataEntity.getDataEntity();
            boolean isCycle = dataObj.getBoolean("cycle");
            if (isCycle) {
                recurIdList.add(dataObj.getLong("id"));
                continue;
            }
            nonRecurIdList.add(dataObj.getLong("id"));
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_recurbizdata");
        Map<Long, List<DynamicObject>> usedRecurBizDataListMap = null;
        if (recurIdList.size() > 0) {
            DynamicObjectCollection bizDatas = helper.queryOriginalCollection("bizitem.id,salaryfile.person.name", new QFilter[]{new QFilter("bizitem", "in", recurIdList)});
            usedRecurBizDataListMap = bizDatas.stream().collect(Collectors.groupingBy(usedBizData -> usedBizData.getLong("bizitem.id")));
        }
        Map<Long, List<DynamicObject>> usedNonRecurBizDataListMap = null;
        if (nonRecurIdList.size() > 0) {
            helper.setEntityName("hsas_nonrecurbizdata");
            DynamicObjectCollection bizDatas = helper.queryOriginalCollection("bizitem.id,salaryfile.person.name", new QFilter[]{new QFilter("bizitem", "in", nonRecurIdList)});
            usedNonRecurBizDataListMap = bizDatas.stream().collect(Collectors.groupingBy(usedBizData -> usedBizData.getLong("bizitem.id")));
        }
        String errorMsg = null;
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            boolean isCycle = data.getBoolean("cycle");
            Long itemId = data.getLong("id");
            if (isCycle) {
                if (usedRecurBizDataListMap != null && usedRecurBizDataListMap.containsKey(itemId)) {
                    errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c{0}\u7684\u4e1a\u52a1\u6570\u636e\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"BizItemValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), usedRecurBizDataListMap.get(data.getLong("id")).get(0).getString("salaryfile.person.name"));
                }
            } else if (usedNonRecurBizDataListMap != null && usedNonRecurBizDataListMap.containsKey(itemId)) {
                errorMsg = MessageFormat.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c{0}\u7684\u4e1a\u52a1\u6570\u636e\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"BizItemValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), usedNonRecurBizDataListMap.get(data.getLong("id")).get(0).getString("salaryfile.person.name"));
            }
            if (errorMsg == null) continue;
            this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
        }
    }
}

