/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.bizitemprop;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.swc.hsbp.common.constants.BizItemConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.common.enums.DataTypeEnum;

public class BizItemPropValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": 
            case "submit": {
                this.nameLimitCheck(dataEntities);
                this.checkData(dataEntities);
                break;
            }
        }
    }

    private void checkData(ExtendedDataEntity[] dataEntities) {
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String scaleLimit;
            DynamicObject data = dataEntity.getDataEntity();
            long dataTypeId = data.getLong("datatype.id");
            if (dataTypeId == DataTypeEnum.TEXT.getCode()) {
                Integer dataLength = (Integer)data.get("datalength");
                if (dataLength != null && dataLength > 0 && dataLength <= 500) continue;
                String errorMsg = ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6587\u672c\u65f6\uff0c\u6570\u636e\u957f\u5ea6\u7684\u6570\u503c\u8303\u56f4\u4e3a(0,500]\u3002", (String)"BizItemPropValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addMessage(dataEntity, errorMsg, ErrorLevel.FatalError);
                continue;
            }
            if (dataTypeId == DataTypeEnum.DATE.getCode()) {
                Date earliestDate = data.getDate("earliestdate");
                Date lastDate = data.getDate("lastdate");
                if (earliestDate == null || lastDate == null || !lastDate.before(earliestDate)) continue;
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u665a\u65e5\u671f\u5fc5\u987b\u665a\u4e8e\u6700\u65e9\u65e5\u671f\u3002", (String)"BizItemPropValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                continue;
            }
            if (dataTypeId != DataTypeEnum.NUMBERIC.getCode()) continue;
            String maxValue = data.getString("inputmaxval");
            String minValue = data.getString("inputminval");
            String regx1 = "-0(\\.0*)?";
            String regx2 = "^([+,-])?(([1-9]{1}\\d{0,12})|(0{1}))(\\.\\d{0,10})?$";
            if (!maxValue.isEmpty() && (maxValue.matches(regx1) || !maxValue.matches(regx2)) || !minValue.isEmpty() && (minValue.matches(regx1) || !minValue.matches(regx2))) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u8f93\u5165\u503c\u4e0d\u5408\u6cd5\u3002\u6574\u6570\u90e8\u5206\u6700\u5927\u4e3a13\u4f4d\uff0c\u5c0f\u6570\u90e8\u5206\u6700\u5927\u4e3a10\u4f4d\u3002", (String)"BizItemPropValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (!SWCStringUtils.isEmpty((String)(scaleLimit = data.getString("scalelimit")))) {
                int maxValueScale;
                int minValueScale;
                int scaleLimitVal = Integer.parseInt(scaleLimit);
                if (!SWCStringUtils.isEmpty((String)minValue) && (minValueScale = new BigDecimal(minValue).scale()) > scaleLimitVal) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5c0f\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemPropValidator_9", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
                if (!SWCStringUtils.isEmpty((String)maxValue) && (maxValueScale = new BigDecimal(maxValue).scale()) > scaleLimitVal) {
                    this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u7b26\u5408\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u3002", (String)"BizItemPropValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
                }
            } else {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6570\u636e\u7c7b\u578b\u4e3a\u6570\u503c\u65f6\uff0c\u201c\u5c0f\u6570\u4f4d\u6570\u9650\u5236\u201d\u5fc5\u586b\u3002", (String)"BizItemPropValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (maxValue.isEmpty() || minValue.isEmpty() || new BigDecimal(maxValue).compareTo(new BigDecimal(minValue)) >= 0) continue;
            this.addMessage(dataEntity, ResManager.loadKDString((String)"\u6700\u5927\u8f93\u5165\u503c\u4e0d\u53ef\u5c0f\u4e8e\u6700\u5c0f\u8f93\u5165\u503c\u3002", (String)"BizItemPropValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
        }
    }

    private void nameLimitCheck(ExtendedDataEntity[] dataEntities) {
        Set<String> specialNameSet = this.getSpecialNameSet();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            String name = data.getString("name");
            if (specialNameSet.contains(name)) {
                this.addMessage(dataEntity, ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u4e0e\u7cfb\u7edf\u901a\u7528\u5c5e\u6027\u540d\u79f0\u76f8\u540c\uff1a\u751f\u6548\u65e5\u671f\u3001\u5931\u6548\u65e5\u671f\u3001\u5e01\u79cd\u3001\u9891\u5ea6\u3001\u5907\u6ce8", (String)"BizItemPropValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ErrorLevel.FatalError);
            }
            if (!StringCheckUtils.checkNameIsContainSpecialChar((String)data.getString("name"), (List)BizItemConstants.SPECIAL_CHAR_LIST)) continue;
            String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c\u3010\u201d\u3001\u201c\u3011\u201d\u3001\u201c]\u201d\u3002", (String)"BizItemPropValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"BizItemPropValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
        }
    }

    private Set<String> getSpecialNameSet() {
        HashSet<String> specialNameSet = new HashSet<String>(5);
        specialNameSet.add(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"BizItemPropValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        specialNameSet.add(ResManager.loadKDString((String)"\u5931\u6548\u65e5\u671f", (String)"BizItemPropValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        specialNameSet.add(ResManager.loadKDString((String)"\u5e01\u79cd", (String)"BizItemPropValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        specialNameSet.add(ResManager.loadKDString((String)"\u9891\u5ea6", (String)"BizItemPropValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        specialNameSet.add(ResManager.loadKDString((String)"\u5907\u6ce8", (String)"BizItemPropValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        return specialNameSet;
    }
}

