/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.formula;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class EnumConfigSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities;
            for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                this.enumSaveValidator(dataEntity);
            }
        }
    }

    private void enumSaveValidator(ExtendedDataEntity dataEntity) {
        ArrayList<String> enumValueList = new ArrayList<String>();
        ArrayList<String> enumNameList = new ArrayList<String>();
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection entryList = data.getDynamicObjectCollection("entryentity");
        if (ObjectUtils.isEmpty((Object)entryList)) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u679a\u4e3e\u5206\u5f55\u201d\u3002", (String)"EnumConfigSaveValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        for (DynamicObject dynamicObject : entryList) {
            String enumvalue = dynamicObject.getString("enumvalue");
            String enumname = dynamicObject.getString("enumname");
            if (this.checkEnumConfig(dataEntity, enumValueList, enumvalue)) {
                this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u503c[%s]\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5!", (String)"EnumConfigSaveValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), enumvalue));
                return;
            }
            if (SWCStringUtils.isEmpty((String)enumname)) {
                return;
            }
            if (!this.checkEnumConfig(dataEntity, enumNameList, enumname)) continue;
            this.addFatalErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0\u201c%s\u201d\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"EnumConfigSaveValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), enumname));
            return;
        }
    }

    private boolean checkEnumConfig(ExtendedDataEntity dataEntity, List<String> enumValueList, String enumvalue) {
        if (enumValueList.contains(enumvalue)) {
            return true;
        }
        enumValueList.add(enumvalue);
        return false;
    }
}

