/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.formula.function;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CommonDeleteValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("delete".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            String itemType = this.getItemType();
            if (SWCStringUtils.isEmpty((String)itemType)) {
                return;
            }
            List itemUniqueCodeList = Arrays.asList(dataEntities).stream().map(obj -> obj.getDataEntity().getString("uniquecode")).collect(Collectors.toList());
            Map itemRelMap = FormulaCacheUtils.checkItemIsUsedForFormula(itemUniqueCodeList, (String)itemType);
            DynamicObject data = null;
            Set formulaNameSet = null;
            String errorMsg = ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab\u5220\u9664\uff0c\u201c\u8ba1\u7b97\u516c\u5f0f\u201d\u7684\u201c%s\u201d\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e\u3002", (String)"FuncDefineDeleteValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                data = dataEntity.getDataEntity();
                formulaNameSet = (Set)itemRelMap.get(data.getString("uniquecode"));
                if (formulaNameSet == null) continue;
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, errorMsg, SWCListUtils.join((Set)formulaNameSet, (String)",")));
            }
        }
    }

    private String getItemType() {
        String entityKey = this.getEntityKey().toLowerCase();
        String itemType = null;
        switch (entityKey) {
            case "hsbs_salaryitem": {
                itemType = "SL";
                break;
            }
            case "hsbs_bizitem": {
                itemType = "BS";
                break;
            }
            case "hsbs_funcdefine": {
                itemType = "FC";
                break;
            }
            case "hsbs_supportitem": {
                itemType = "SP";
                break;
            }
            case "hsbs_fetchitem": {
                itemType = "FT";
                break;
            }
        }
        return itemType;
    }
}

