/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.formula.function;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.formula.utils.FormulaCacheUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCMServiceUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.common.util.StringCheckUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class FuncDefineSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("save".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            HashMap<Long, ExtendedDataEntity> formulaUsedMap = new HashMap<Long, ExtendedDataEntity>(16);
            for (ExtendedDataEntity dataEntity : dataEntities) {
                this.checkFuncExp(dataEntity, formulaUsedMap);
            }
            if (formulaUsedMap.size() > 0) {
                this.checkFuncIsUsed(formulaUsedMap);
            }
        }
    }

    private void checkFuncIsUsed(Map<Long, ExtendedDataEntity> formulaUsedMap) {
        SWCDataServiceHelper funcHelper = new SWCDataServiceHelper("hsbs_funcdefine");
        QFilter filter = new QFilter("id", "in", formulaUsedMap.keySet());
        DynamicObjectCollection oldFuncData = funcHelper.queryOriginalCollection("id,uniquecode", new QFilter[]{filter});
        if (oldFuncData.size() == 0) {
            return;
        }
        List itemUniqueCodeList = oldFuncData.stream().map(obj -> obj.getString("uniquecode")).collect(Collectors.toList());
        Map itemRelMap = FormulaCacheUtils.checkItemIsUsedForFormula(itemUniqueCodeList, (String)"FC");
        for (DynamicObject func : oldFuncData) {
            if (!itemRelMap.containsKey(func.getString("uniquecode"))) continue;
            this.addErrorMessage(formulaUsedMap.get(func.getLong("id")), ResManager.loadKDString((String)"\u51fd\u6570\u5df2\u88ab\u8ba1\u7b97\u516c\u5f0f\u5f15\u7528\uff0c\u65e0\u6cd5\u4fee\u6539\uff0c\u5982\u9700\u8981\u66f4\u65b0\u51fd\u6570\uff0c\u8bf7\u53e6\u5916\u65b0\u5efa\u51fd\u6570\u7136\u540e\u4fee\u6539\u8ba1\u7b97\u516c\u5f0f\u5f15\u7528\u65b0\u7684\u51fd\u6570\u3002", (String)"FuncDefineSaveValidator_17", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private void checkFuncExp(ExtendedDataEntity dataEntity, Map<Long, ExtendedDataEntity> formulaUsedMap) {
        DynamicObject data = dataEntity.getDataEntity();
        DynamicObjectCollection entryList = data.getDynamicObjectCollection("entryentity");
        String name = data.getString("name");
        if (StringCheckUtils.checkNameIsContainSpecialChar((String)name)) {
            String msg = Lang.zh_CN.equals((Object)RequestContext.get().getLang()) || Lang.zh_TW.equals((Object)RequestContext.get().getLang()) ? ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c\u3010\u201d\u3001\u201c[\u201d\u3001\u201c]\u201d\u3001\u201c\u3011\u201d\u3002", (String)"FuncDefineSaveValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u540d\u79f0\u4e0d\u80fd\u5305\u542b\u7279\u6b8a\u5b57\u7b26\u201c[\u201d\u3001\u201c]\u201d\u3002", (String)"FuncDefineSaveValidator_18", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addMessage(dataEntity, msg, ErrorLevel.FatalError);
            return;
        }
        String define = data.getString("define");
        if (!StringCheckUtils.isEnglishChar((String)define)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u5b9a\u4e49\u53ea\u80fd\u7ef4\u62a4\u82f1\u6587\u5b57\u7b26\u3002", (String)"FuncDefineSaveValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        String funcExp = data.getString("funcexp");
        if (SWCStringUtils.isEmpty((String)funcExp)) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u51fd\u6570\u4f53\u201d\u3002", (String)"FuncDefineSaveValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        String[] expArray = funcExp.split("\n");
        boolean isHasReturn = false;
        for (int i = 0; i < expArray.length; ++i) {
            if (SWCStringUtils.isEmpty((String)expArray[i])) continue;
            if (i == 0) {
                this.checkFuncHead(dataEntity, expArray[i], entryList);
                continue;
            }
            if (expArray[i].contains("query") || expArray[i].contains("drop") || expArray[i].contains("delete")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u80fd\u7ef4\u62a4query\u3001drop\u548cdelete\u7b49\u5173\u952e\u5b57\u3002", (String)"FuncDefineSaveValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (expArray[i].contains("public")) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u53ea\u80fd\u5b58\u5728\u4e00\u4e2a\u51fd\u6570\u3002", (String)"FuncDefineSaveValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                return;
            }
            if (expArray[i].contains("return")) {
                isHasReturn = true;
            }
            if (i != expArray.length - 1 || expArray[i].endsWith("}")) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u7ef4\u62a4\u9519\u8bef\uff0c\u6ca1\u6709\u4ee5\u201c}\u201d\u7ed3\u5c3e\u3002", (String)"FuncDefineSaveValidator_16", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!isHasReturn) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u5185\u7f3a\u5c11\u8fd4\u56de\u503c\u3002", (String)"FuncDefineSaveValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        String msg = (String)SWCMServiceUtils.invokeSWCService((String)"hscs", (String)"IFuncCheckService", (String)"checkFuncMethod", (Object[])new Object[]{funcExp});
        if (SWCStringUtils.isNotEmpty((String)msg)) {
            this.addErrorMessage(dataEntity, msg);
            return;
        }
        long id = data.getLong("id");
        if (id != 0L) {
            formulaUsedMap.put(id, dataEntity);
        }
    }

    private void checkFuncHead(ExtendedDataEntity dataEntity, String firstLine, DynamicObjectCollection entryList) {
        if (!firstLine.startsWith("public")) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u6ca1\u6709\u4ee5public\u5f00\u59cb\u3002", (String)"FuncDefineSaveValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (firstLine.indexOf(40) < 0 || firstLine.indexOf(41) < 0) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u7b2c\u4e00\u884c\u7f3a\u5c11\u62ec\u53f7\u3002", (String)"FuncDefineSaveValidator_12", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        String head = firstLine.substring(6, firstLine.indexOf(40)).trim();
        String[] headArray = head.split(" ");
        if (headArray.length != 2) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e0d\u6b63\u786e", (String)"FuncDefineSaveValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        DynamicObject data = dataEntity.getDataEntity();
        String funcDefine = data.getString("define");
        String funcDataType = data.getString("funcdatatype");
        if (!SWCStringUtils.equals((String)funcDataType, (String)headArray[0].trim())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u8fd4\u56de\u503c\u7c7b\u578b\u4e0e\u5355\u636e\u5934\u4e2d\u7ef4\u62a4\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FuncDefineSaveValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        if (!SWCStringUtils.equals((String)funcDefine.trim(), (String)headArray[1].trim())) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u51fd\u6570\u5b9a\u4e49\u540d\u4e0e\u5355\u636e\u5934\u4e2d\u7ef4\u62a4\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FuncDefineSaveValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        this.checkParam(dataEntity, entryList, firstLine);
    }

    private void checkParam(ExtendedDataEntity dataEntity, DynamicObjectCollection entryList, String firstLine) {
        String param = firstLine.substring(firstLine.indexOf(40) + 1, firstLine.indexOf(41));
        if (param.length() == 0 && entryList.size() == 0) {
            return;
        }
        String[] paramArray = param.split(",");
        if (paramArray.length != entryList.size()) {
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u53c2\u6570\u4e2a\u6570\u4e0e\u53c2\u6570\u5217\u8868\u4e2d\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FuncDefineSaveValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
        String paramDataType = null;
        int seq = 0;
        String paramType = null;
        for (DynamicObject paramData : entryList) {
            paramDataType = paramData.getString("paramdatatype");
            paramType = this.getParamType(paramArray[seq].trim());
            if (paramType == null) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u7b2c%s\u4e2a\u53c2\u6570\u7ef4\u62a4\u4e0d\u6b63\u786e\u3002", (String)"FuncDefineSaveValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq + 1));
                return;
            }
            if (!SWCStringUtils.equals((String)paramDataType, (String)paramType)) {
                this.addErrorMessage(dataEntity, String.format(Locale.ROOT, ResManager.loadKDString((String)"\u51fd\u6570\u4f53\u4e2d\u7b2c%s\u4e2a\u53c2\u6570\u7c7b\u578b\u4e0e\u53c2\u6570\u5217\u8868\u4e2d\u7684\u4e0d\u4e00\u81f4\u3002", (String)"FuncDefineSaveValidator_7", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), seq + 1));
                return;
            }
            ++seq;
        }
    }

    private String getParamType(String param) {
        if (SWCStringUtils.isEmpty((String)param)) {
            return null;
        }
        String[] array = param.trim().split(" ");
        if (array.length != 2) {
            return null;
        }
        return array[0].trim();
    }
}

