/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.insurancemap;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.SWCErrorInfoEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.insurance.service.SInsurBaseFetchCfgService;
import kd.swc.hsbs.common.enums.HSBSErrorInfoEnum;

public class InsuranceBaseFetchCfgAuditValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        if (dataEntities == null || dataEntities.length == 0) {
            return;
        }
        if ("audit".equals(this.getOperateKey())) {
            Set baseFetchItemIds = Arrays.stream(dataEntities).map(ExtendedDataEntity::getDataEntity).map(cfgDy -> cfgDy.getLong("basefetchitem")).collect(Collectors.toSet());
            SWCDataServiceHelper cfgHelper = new SWCDataServiceHelper("hsbs_sinsbsfetchcfg");
            QFilter filter = new QFilter("status", "=", (Object)"C");
            filter.and("enable", "=", (Object)"1");
            filter.and("iscurrentversion", "=", (Object)Boolean.TRUE);
            filter.and("basefetchitem", "in", baseFetchItemIds);
            DynamicObjectCollection auditAndEnabledCfgDys = cfgHelper.queryOriginalCollection("id,basefetchitem,name", filter.toArray());
            Map<Object, Object> existedBaseFetchItemMap = new HashMap(0);
            if (auditAndEnabledCfgDys != null) {
                existedBaseFetchItemMap = auditAndEnabledCfgDys.stream().collect(Collectors.toMap(cfgDy -> cfgDy.getLong("basefetchitem"), cfgDy -> cfgDy.getString("name"), (oldVal, newVal) -> oldVal));
            }
            Map baseFetchItemInfo = SInsurBaseFetchCfgService.getBaseFetchItemInfoByStatus(existedBaseFetchItemMap.keySet(), (int)1);
            for (ExtendedDataEntity extendedDataEntity : dataEntities) {
                DynamicObject insuranceBaseFetchCfgDy = extendedDataEntity.getDataEntity();
                Long currBaseFetchItemId = insuranceBaseFetchCfgDy.getLong("basefetchitem");
                if (currBaseFetchItemId == null || currBaseFetchItemId == 0L) {
                    String fieldDesc = ((IDataEntityProperty)insuranceBaseFetchCfgDy.getDynamicObjectType().getProperties().get((Object)"basefetchitem")).getDisplayName().getLocaleValue();
                    this.addErrorMessage(extendedDataEntity, SWCErrorInfoEnum.COMMON_ATTR_IS_NULL.getErrInfo(new Object[]{fieldDesc}));
                    continue;
                }
                if ("1".equals(insuranceBaseFetchCfgDy.getString("enable")) && "C".equals(insuranceBaseFetchCfgDy.getString("status"))) {
                    existedBaseFetchItemMap.put(currBaseFetchItemId, insuranceBaseFetchCfgDy.getString("name"));
                    continue;
                }
                String auditAndEnabledName = (String)existedBaseFetchItemMap.get(currBaseFetchItemId);
                if (auditAndEnabledName != null) {
                    String baseFetchItemName = (String)baseFetchItemInfo.getOrDefault(currBaseFetchItemId, Collections.emptyMap()).get("name");
                    this.addFatalErrorMessage(extendedDataEntity, HSBSErrorInfoEnum.BASE_FETCH_CFG_ITEM_EXISTED.getInfo(new Object[]{baseFetchItemName, auditAndEnabledName}));
                    continue;
                }
                if (!SWCStringUtils.isNotEmpty((String)insuranceBaseFetchCfgDy.getString("name"))) continue;
                existedBaseFetchItemMap.put(currBaseFetchItemId, insuranceBaseFetchCfgDy.getString("name"));
            }
        }
    }
}

