/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.insurancemap;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.property.ComboProp;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.util.ModifyNotAllowedHelper;
import kd.swc.hsbp.common.enums.SWCErrorInfoEnum;
import kd.swc.hsbp.common.util.MandatoryHelper;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.hsbs.business.insurance.constants.SInsuranceConstants;
import kd.swc.hsbs.common.enums.HSBSErrorInfoEnum;

public class InsuranceBaseFetchCfgSaveValidator
extends SWCDataBaseValidator {
    private static final List<String> MANDATORY_FIELDS = Arrays.asList("createorg", "country", "number", "name", "basefetchitem", "fetchsrc");
    private static final List<String> NOT_ALLOWED_MODIFY_FIELDS_FOR_CURRENT = Arrays.asList("createorg", "basefetchitem", "ctrlstrategy");
    private static final List<String> NOT_ALLOWED_MODIFY_FIELDS_FOR_HISTORY = Arrays.asList("createorg", "number", "basefetchitem", "ctrlstrategy");

    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities == null || extendedDataEntities.length == 0) {
            return;
        }
        MainEntityType mainType = EntityMetadataCache.getDataEntityType((String)this.getEntityKey());
        ComboProp fetchSrcProp = (ComboProp)mainType.getProperties().get((Object)"fetchsrc");
        List cfgDys = Arrays.stream(extendedDataEntities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        boolean isHistorySave = "changesave".equals(this.getOperateKey()) || "auditconfirmchange".equals(this.getOperateKey()) || "confirmchange".equals(this.getOperateKey());
        List<String> tmpNotAllowedModifyFields = isHistorySave ? NOT_ALLOWED_MODIFY_FIELDS_FOR_HISTORY : NOT_ALLOWED_MODIFY_FIELDS_FOR_CURRENT;
        Map notAllowedModifyEntityDyMap = ModifyNotAllowedHelper.checkFieldNotAllowedModify(cfgDys, tmpNotAllowedModifyFields);
        Set validAccumulatorIds = SWCPermissionServiceHelper.getValidBaseDataEntityIds(cfgDys, (String)"createorg", (String)"accumulator", null);
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            String notAllowedModifyFieldMsg;
            String fetchSrc;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            StringJoiner errMandatoryFields = MandatoryHelper.checkMandatoryField((DynamicObject)dataEntity, MANDATORY_FIELDS);
            if (errMandatoryFields.length() != 0) {
                this.addErrorMessage(extendedDataEntity, SWCErrorInfoEnum.COMMON_ATTR_IS_NULL.getErrInfo(new Object[]{errMandatoryFields.toString()}));
                continue;
            }
            long currCountryId = dataEntity.getLong("country.id");
            if (currCountryId != SInsuranceConstants.COUNTRY_ID_CHINA) {
                this.addFatalErrorMessage(extendedDataEntity, HSBSErrorInfoEnum.COMMON_COUNTRY_MUST_CHINA.getInfo());
            }
            if ((fetchSrc = dataEntity.getString("fetchsrc")) == null || fetchSrc.trim().length() == 0 || fetchSrcProp.getComboItems() == null) continue;
            fetchSrc = fetchSrc.trim();
            for (ValueMapItem comboItem : fetchSrcProp.getComboItems()) {
                long fetchSrcCountryId;
                if (!dataEntity.getDataEntityType().getProperties().containsKey((Object)comboItem.getValue())) continue;
                if (!fetchSrc.equals(comboItem.getValue())) {
                    dataEntity.set(comboItem.getValue(), null);
                    continue;
                }
                String itemName = fetchSrcProp.getItemByName(fetchSrc);
                DynamicObject srcDy = dataEntity.getDynamicObject(fetchSrc);
                if (SWCObjectUtils.isEmpty((Object)srcDy)) {
                    this.addFatalErrorMessage(extendedDataEntity, SWCErrorInfoEnum.COMMON_ATTR_IS_NULL.getErrInfo(new Object[]{itemName}));
                    continue;
                }
                if (!srcDy.getDynamicObjectType().getProperties().containsKey((Object)"country") || (fetchSrcCountryId = srcDy.getLong("country.id")) == 0L || fetchSrcCountryId == currCountryId) continue;
                this.addFatalErrorMessage(extendedDataEntity, HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_FETCH_SRC_COUNTRY_NOT_CONSISTENT.getInfo(new Object[]{itemName}));
            }
            long accumulatorId = dataEntity.getLong("accumulator.id");
            if ("accumulator".equals(fetchSrc) && accumulatorId != 0L && !validAccumulatorIds.contains(accumulatorId)) {
                this.addFatalErrorMessage(extendedDataEntity, HSBSErrorInfoEnum.BASE_FETCH_CFG_FOR_CREATE_ORG_NOR_CONSISTENT.getInfo());
            }
            if ((notAllowedModifyFieldMsg = (String)notAllowedModifyEntityDyMap.get(dataEntity)) == null) continue;
            this.addErrorMessage(extendedDataEntity, notAllowedModifyFieldMsg);
        }
    }
}

