/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.insurancemap;

import java.util.Arrays;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class InsuranceItemMappingSchemeValidator
extends SWCDataBaseValidator {
    public void validate() {
        super.validate();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String errorMsg = ResManager.loadKDString((String)"\u65e0\u6cd5\u64cd\u4f5c\u3002\u5df2\u5b58\u5728\u76f8\u540c\u56fd\u5bb6/\u5730\u533a\u4e0b\u5df2\u5ba1\u6838\u53ef\u7528\u7684\u793e\u4fdd\u9879\u76ee\u6620\u5c04\u65b9\u6848\u3002\u8bf7\u68c0\u67e5\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u662f\u5426\u76f8\u540c\u3002", (String)"InsuranceItemMappingSchemeValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject obj = dataEntity.getDataEntity();
            long orgId = obj.getLong("org.id");
            long countryId = obj.getLong("country.id");
            Long boId = obj.getLong("boid");
            long sameObj = 0L;
            String operateKey = this.getOperateKey();
            String status = dataEntity.getDataEntity().getString("status");
            if (SWCStringUtils.equals((String)operateKey, (String)"enable") && SWCStringUtils.equals((String)status, (String)"C") && SWCStringUtils.equals((String)dataEntity.getDataEntity().getString("enable"), (String)"0")) {
                sameObj = Arrays.stream(dataEntities).filter(entity -> entity.getDataEntity().getLong("org.id") == orgId && entity.getDataEntity().getLong("country.id") == countryId && SWCStringUtils.equals((String)entity.getDataEntity().getString("status"), (String)"C") && SWCStringUtils.equals((String)dataEntity.getDataEntity().getString("enable"), (String)"0")).count();
            } else if (SWCStringUtils.equals((String)operateKey, (String)"audit") && SWCStringUtils.equals((String)dataEntity.getDataEntity().getString("status"), (String)"B")) {
                sameObj = Arrays.stream(dataEntities).filter(entity -> entity.getDataEntity().getLong("org.id") == orgId && entity.getDataEntity().getLong("country.id") == countryId && SWCStringUtils.equals((String)entity.getDataEntity().getString("enable"), (String)"1") && SWCStringUtils.equals((String)dataEntity.getDataEntity().getString("status"), (String)"B")).count();
            } else if (!SWCStringUtils.equals((String)operateKey, (String)"auditconfirmchange") && !SWCStringUtils.equals((String)operateKey, (String)"audithisconfirmchange")) continue;
            if (sameObj > 1L) {
                this.addErrorMessage(dataEntity, errorMsg);
                continue;
            }
            DynamicObjectCollection taxItemMappingInfo = this.getInsuranceItemMappingInfo(orgId, countryId, boId);
            if (taxItemMappingInfo.size() <= 0) continue;
            this.addErrorMessage(dataEntity, errorMsg);
        }
    }

    private DynamicObjectCollection getInsuranceItemMappingInfo(Long orgId, Long countryId, Long boId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_insurproscheme");
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("country", "=", (Object)countryId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("country", "=", (Object)countryId);
        filter.and("boid", "!=", (Object)boId);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        return helper.queryOriginalCollection("id", new QFilter[]{filter});
    }
}

