/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.migrationtpl;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.common.constants.SWCConstants;
import kd.swc.hsbp.common.util.SWCDbUtil;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class MigrationQuoteCheckValidator
extends SWCDataBaseValidator {
    public static final String FIELD_ITEM_TYPE_SL = "1";
    public static final String FIELD_ITEM_TYPE_SP = "2";
    public static final String FIELD_ITEM_TYPE_BS = "3";
    public static final String FIELD_ITEM_TYPE_FT = "4";

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        if ("delete".equals(operateKey)) {
            ExtendedDataEntity[] dataEntities = this.getDataEntities();
            List itemIdList = Arrays.stream(dataEntities).map(dataEntity -> dataEntity.getDataEntity().getLong("id")).collect(Collectors.toList());
            String entity = this.getEntityKey();
            String itemType = null;
            if (SWCStringUtils.equals((String)entity, (String)"hsbs_salaryitem")) {
                itemType = FIELD_ITEM_TYPE_SL;
            } else if (SWCStringUtils.equals((String)entity, (String)"hsbs_bizitem")) {
                itemType = FIELD_ITEM_TYPE_BS;
            } else if (SWCStringUtils.equals((String)entity, (String)"hsbs_supportitem")) {
                itemType = FIELD_ITEM_TYPE_SP;
            } else if (SWCStringUtils.equals((String)entity, (String)"hsbs_fetchitem")) {
                itemType = FIELD_ITEM_TYPE_FT;
            } else {
                return;
            }
            StringBuilder selectSqlBuilder = new StringBuilder();
            Object[] params = new Object[itemIdList.size() + 1];
            selectSqlBuilder.append("SELECT FITEMID FROM T_HSAS_MIGRATIONTPLENT WHERE FITEMID IN (");
            for (int index = 0; index < itemIdList.size(); ++index) {
                if (index > 0) {
                    selectSqlBuilder.append(',');
                }
                selectSqlBuilder.append('?');
                params[index] = itemIdList.get(index);
            }
            selectSqlBuilder.append(") AND FITEMTYPE = ?");
            params[itemIdList.size()] = itemType;
            HashSet<Long> itemIdSet = new HashSet<Long>(itemIdList.size());
            try (DataSet dataSet = SWCDbUtil.queryDataSet((String)"checkItemMigrationQuoteService", (DBRoute)SWCConstants.SWC_ROUETE, (String)selectSqlBuilder.toString(), (Object[])params);){
                while (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    itemIdSet.add(row.getLong("fitemid"));
                }
            }
            for (ExtendedDataEntity dataEntity2 : dataEntities) {
                if (!itemIdSet.contains(dataEntity2.getDataEntity().getLong("id"))) continue;
                this.addFatalErrorMessage(dataEntity2, ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u88ab\u5386\u53f2\u6570\u636e\u8fc1\u79fb\u5f15\u7528\uff0c\u4e0d\u80fd\u5220\u9664\u3002", (String)"MigrationQuoteCheckValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            }
        }
    }
}

