/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.taxmap;

import com.google.common.collect.HashBasedTable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class TaxItemMappingSchemeValidator
extends SWCDataBaseValidator {
    private static final String CONFIRMCHANGE = "confirmchange";
    private static final Long SIT_CALTAXTYPE_SUBMITTAX = 1102850557313347584L;
    private static final Long SIT_CALTAXTYPE_TAXRETURN = 1102850747902521344L;

    public void validate() {
        super.validate();
        String operateKey = this.getOperateKey();
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        switch (operateKey) {
            case "save": 
            case "submit": 
            case "audit": 
            case "enable": 
            case "confirmchange": {
                this.saveValidator(dataEntities);
                break;
            }
            case "unaudit": {
                for (ExtendedDataEntity entity : dataEntities) {
                    String errorMsg = ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u53cd\u5ba1\u6838\u3002", (String)"TaxItemMappingSchemeValidator_8", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, errorMsg);
                }
                break;
            }
        }
    }

    private void checkDataOnlyOne(ExtendedDataEntity entity) {
        Long countryId;
        DynamicObject obj = entity.getDataEntity();
        Long boId = obj.getLong("boid");
        Long orgId = obj.getLong("org.id");
        DynamicObjectCollection taxItemMappingInfo = this.getTaxItemMappingInfo(orgId, countryId = Long.valueOf(obj.getLong("country.id")), boId);
        if (taxItemMappingInfo.size() > 0) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u4e0e\u56fd\u5bb6/\u5730\u533a\u4e0b\u5df2\u5b58\u5728\u5176\u4ed6\u6620\u5c04\u65b9\u6848\uff0c\u8bf7\u5207\u6362\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6216\u4fee\u6539\u5df2\u6709\u65b9\u6848\u3002", (String)"TaxItemMappingSchemeValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
        }
    }

    private void saveValidator(ExtendedDataEntity[] dataEntities) {
        boolean isImport = this.getOption().containsVariable("importtype");
        HashBasedTable orgIdAndCountryIdToSalaryItemIdSet = HashBasedTable.create();
        for (ExtendedDataEntity entity : dataEntities) {
            Set<Object> hasOrgPermsItemIdSet;
            boolean isSave;
            DynamicObject obj = entity.getDataEntity();
            DynamicObjectCollection salaryItemMapEntrys = obj.getDynamicObjectCollection("salarymapentry");
            DynamicObjectCollection taxItemMapEntrys = obj.getDynamicObjectCollection("taxmapentry");
            if (!isImport) {
                this.checkDataOnlyOne(entity);
            }
            Long orgId = obj.getLong("org.id");
            Long countryId = obj.getLong("country.id");
            boolean bl = isSave = "save".equals(this.getOperateKey()) || "submit".equals(this.getOperateKey()) || CONFIRMCHANGE.equals(this.getOperateKey());
            if (isSave) {
                hasOrgPermsItemIdSet = (Set)orgIdAndCountryIdToSalaryItemIdSet.get((Object)orgId, (Object)countryId);
                if (hasOrgPermsItemIdSet == null) {
                    hasOrgPermsItemIdSet = this.getSalaryItemWhitchHasOrgPerms(orgId, countryId);
                    orgIdAndCountryIdToSalaryItemIdSet.put((Object)orgId, (Object)countryId, hasOrgPermsItemIdSet);
                }
            } else {
                hasOrgPermsItemIdSet = new HashSet(0);
            }
            this.checkEntryMustInput(entity, salaryItemMapEntrys, taxItemMapEntrys);
            this.checkSalaryItemToTaxItemEntry(entity, salaryItemMapEntrys, isImport, hasOrgPermsItemIdSet, isSave);
            this.checkTaxItemToSalaryItemEntry(entity, taxItemMapEntrys, isImport, hasOrgPermsItemIdSet, isSave);
            if (!isSave || !isImport) continue;
            this.checkImportOverlap(entity, salaryItemMapEntrys, "presalaryitem.id", "pretaxcategory.taxpayertype.id", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_49", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e0e\u5df2\u6709\u6570\u636e\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_50", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            this.checkImportOverlap(entity, salaryItemMapEntrys, "pretaxcategory.id", "pretaxitem.id", ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u4e2a\u7a0e\u79cd\u7c7b\u548c\u4e2a\u7a0e\u9879\u76ee\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_51", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u4e2a\u7a0e\u79cd\u7c7b\u548c\u4e2a\u7a0e\u9879\u76ee\u4e0d\u80fd\u4e0e\u5df2\u6709\u6570\u636e\u5b8c\u5168\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_52", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            this.checkImportOverlap(entity, taxItemMapEntrys, "aftersalaryitem.id", "aftertaxcategory.taxpayertype.id", ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_53", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e0d\u80fd\u4e0e\u5df2\u6709\u6570\u636e\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_54", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            this.checkImportOverlap(entity, taxItemMapEntrys, "aftertaxcategory.id", "aftertaxitem.id", ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u4e2a\u7a0e\u79cd\u7c7b\u548c\u4e2a\u7a0e\u9879\u76ee\u5728\u5bfc\u5165\u6a21\u677f\u4e2d\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_55", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5bfc\u5165\u7684\u4e2a\u7a0e\u79cd\u7c7b\u548c\u4e2a\u7a0e\u9879\u76ee\u4e0d\u80fd\u4e0e\u5df2\u6709\u6570\u636e\u5b8c\u5168\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_56", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        }
    }

    private Set<Long> getSalaryItemWhitchHasOrgPerms(Long orgId, Long countryId) {
        QFilter useOrgFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", (Long)orgId);
        QFilter filter = new QFilter("enable", "=", (Object)"1");
        filter.and(new QFilter("status", "=", (Object)"C"));
        filter.and("country", "in", (Object)new Long[]{0L, countryId});
        filter.and(useOrgFilter);
        return this.getSalaryItemIdSet(filter);
    }

    private Set<Long> getSalaryItemIdSet(QFilter filter) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        DynamicObjectCollection result = helper.queryOriginalCollection("id", new QFilter[]{filter});
        return result.stream().map(obj -> obj.getLong("id")).collect(Collectors.toSet());
    }

    private void checkEntryMustInput(ExtendedDataEntity entity, DynamicObjectCollection salaryItemMapEntrys, DynamicObjectCollection taxItemMapEntrys) {
        if (salaryItemMapEntrys.size() == 0 || taxItemMapEntrys.size() == 0) {
            String errorMsg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u5206\u5f55\u6216\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u5206\u5f55\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u8fdb\u884c\u64cd\u4f5c\u3002", (String)"TaxItemMappingSchemeValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addErrorMessage(entity, errorMsg);
        }
    }

    private void checkTaxItemToSalaryItemEntry(ExtendedDataEntity entity, DynamicObjectCollection taxItemMapEntrys, boolean isImport, Set<Long> hasOrgPermsItemIdSet, boolean isSave) {
        HashBasedTable taxPayerTypeTable = HashBasedTable.create();
        ArrayList<Integer> taxPayerTypeSeqList = null;
        HashBasedTable taxItemTable = HashBasedTable.create();
        ArrayList<Integer> taxItemSeqList = null;
        long countryId = entity.getDataEntity().getLong("country.id");
        String orgName = entity.getDataEntity().getString("org.name");
        int index = 0;
        for (DynamicObject taxItemMapEntry : taxItemMapEntrys) {
            String errorMsg;
            String errorMsg2;
            ++index;
            Long salaryItemId = taxItemMapEntry.getLong("aftersalaryitem.id");
            Long taxPayerTypeId = taxItemMapEntry.getLong("aftertaxcategory.taxpayertype.id");
            String salaryItemName = taxItemMapEntry.getString("aftersalaryitem.name");
            String taxItemName = taxItemMapEntry.getString("aftertaxitem.name");
            if (isImport) {
                if ("2".equals(taxItemMapEntry.getString("aftersalaryitem.areatype")) && taxItemMapEntry.getLong("aftersalaryitem.country.id") != countryId) {
                    errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u85aa\u916c\u9879\u76ee{0}\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u6620\u5c04\u65b9\u6848\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_42", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemName));
                    continue;
                }
                if (!"2".equals(taxItemMapEntry.getString("aftersalaryitem.taxtag")) || !"1".equals(taxItemMapEntry.getString("aftersalaryitem.calblock"))) {
                    errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5e94\u4f7f\u7528\u4e2a\u7a0e\u6807\u7b7e\u4e3a\u4e2a\u7a0e\u7ed3\u679c\u9879\u76ee\u4e14\u8ba1\u7b97\u533a\u6bb5\u4e3a\u7a0e\u540e\u7684\u85aa\u916c\u9879\u76ee\uff0c\u85aa\u916c\u9879\u76ee{0}\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_43", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemName));
                    continue;
                }
                if (SIT_CALTAXTYPE_TAXRETURN.longValue() != taxItemMapEntry.getLong("aftertaxitem.caltaxtype.id")) {
                    errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5e94\u4f7f\u7528\u7528\u9014\u4e3a\u201c\u7a0e\u5c40\u8fd4\u56de\u201d\u7684\u4e2a\u7a0e\u9879\u76ee\uff0c\u4e2a\u7a0e\u9879\u76ee{0}\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_44", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, taxItemName));
                    continue;
                }
                if ("1".equals(taxItemMapEntry.getString("aftertaxitem.countrytype")) && taxItemMapEntry.getLong("aftertaxitem.country.id") != countryId) {
                    errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u4e2a\u7a0e\u9879\u76ee{0}\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u6620\u5c04\u65b9\u6848\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_45", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, taxItemName));
                    continue;
                }
                if (taxItemMapEntry.getLong("aftersalaryitem.datatype.id") != taxItemMapEntry.getLong("aftertaxitem.datatype.id")) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee{0}\u4e0e\u4e2a\u7a0e\u9879\u76ee{1}\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_46", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemName, taxItemName));
                    continue;
                }
                DynamicObjectCollection taxCategories = taxItemMapEntry.getDynamicObjectCollection("aftertaxitem.taxcategories");
                Set taxCategoryiesIdSet = taxCategories.stream().map(taxCategory -> taxCategory.getLong("fbasedataid_id")).collect(Collectors.toSet());
                if (!taxCategoryiesIdSet.contains(taxItemMapEntry.getLong("aftertaxcategory.id"))) {
                    errorMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u4e2a\u7a0e\u9879\u76ee{0}\u672a\u5305\u542b\u4e2a\u7a0e\u79cd\u7c7b{1}\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_47", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg, taxItemName, taxItemMapEntry.getString("aftertaxcategory.name")));
                    continue;
                }
            }
            if (isSave) {
                if (!"1".equals(taxItemMapEntry.getString("aftersalaryitem.enable")) || !"C".equals(taxItemMapEntry.getString("aftersalaryitem.status"))) {
                    errorMsg2 = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u85aa\u916c\u9879\u76ee\u7f16\u7801\u4e3a{0}\u7684\u85aa\u916c\u9879\u76ee\u3002\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u5df2\u5ba1\u6838\u5e76\u5904\u4e8e\u53ef\u7528\u72b6\u6001\u3002", (String)"TaxItemMappingSchemeValidator_24", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, taxItemMapEntry.getString("aftersalaryitem.number")));
                    continue;
                }
                if (!"1".equals(taxItemMapEntry.getString("aftertaxitem.enable")) || !"C".equals(taxItemMapEntry.getString("aftertaxitem.status"))) {
                    errorMsg2 = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u4e2a\u7a0e\u9879\u76ee\u7f16\u7801\u4e3a{0}\u7684\u4e2a\u7a0e\u9879\u76ee\u3002\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u5df2\u5ba1\u6838\u5e76\u5904\u4e8e\u53ef\u7528\u72b6\u6001\u3002", (String)"TaxItemMappingSchemeValidator_25", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, taxItemMapEntry.getString("aftertaxitem.number")));
                    continue;
                }
            }
            if (isSave && !hasOrgPermsItemIdSet.contains(salaryItemId)) {
                if (!isImport) {
                    errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\uff1a\u7b2c{0}\u884c\uff0c\u85aa\u916c\u9879\u76ee{1}\u4e0d\u5728\u5f53\u524d\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6743\u9650\u4e2d\uff0c\u8bf7\u66f4\u6362\u85aa\u916c\u9879\u76ee\u540e\u518d\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"TaxItemMappingSchemeValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    errorMsg2 = MessageFormat.format(errorMsg2, index, salaryItemName);
                } else {
                    errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u85aa\u916c\u9879\u76ee{0}\u4e0d\u5728\u521b\u5efa\u7ec4\u7ec7{1}\u6743\u9650\u5185\uff0c\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_41", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    errorMsg2 = MessageFormat.format(errorMsg2, salaryItemName, orgName);
                }
                this.addErrorMessage(entity, errorMsg2);
                continue;
            }
            if (isImport) continue;
            taxPayerTypeSeqList = (ArrayList<Integer>)taxPayerTypeTable.get((Object)salaryItemId, (Object)taxPayerTypeId);
            if (taxPayerTypeSeqList == null) {
                taxPayerTypeSeqList = new ArrayList<Integer>(10);
                taxPayerTypeSeqList.add(taxItemMapEntry.getInt("seq"));
            } else if (taxPayerTypeSeqList.size() > 0) {
                taxPayerTypeSeqList.add(taxItemMapEntry.getInt("seq"));
                errorMsg2 = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u7b2c{0}\u884c\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"TaxItemMappingSchemeValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, MessageFormat.format(errorMsg2, String.valueOf(taxPayerTypeSeqList)));
            }
            taxPayerTypeTable.put((Object)salaryItemId, (Object)taxPayerTypeId, taxPayerTypeSeqList);
            Long afterTaxCategoryId = taxItemMapEntry.getLong("aftertaxcategory.id");
            Long afterTaxItemId = taxItemMapEntry.getLong("aftertaxitem.id");
            taxItemSeqList = (ArrayList<Integer>)taxItemTable.get((Object)afterTaxCategoryId, (Object)afterTaxItemId);
            if (taxItemSeqList == null) {
                taxItemSeqList = new ArrayList<Integer>(10);
                taxItemSeqList.add(taxItemMapEntry.getInt("seq"));
            } else if (taxItemSeqList.size() > 0) {
                taxItemSeqList.add(taxItemMapEntry.getInt("seq"));
                errorMsg = ResManager.loadKDString((String)"\u4e2a\u7a0e\u9879\u76ee\u5230\u85aa\u916c\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u7b2c{0}\u884c\u4e2a\u7a0e\u79cd\u7c7b\u548c\u4e2a\u7a0e\u9879\u76ee\u4e0d\u80fd\u91cd\u590d\u3002", (String)"TaxItemMappingSchemeValidator_6", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, MessageFormat.format(errorMsg, String.valueOf(taxItemSeqList)));
            }
            taxItemTable.put((Object)afterTaxCategoryId, (Object)afterTaxItemId, taxItemSeqList);
        }
    }

    private void checkImportOverlap(ExtendedDataEntity entity, DynamicObjectCollection entrys, String key1, String key2, String importDataOverlapMsg, String totalDataOverlapMsg) {
        HashMap newMap = new HashMap(entrys.size());
        HashMap oldMap = new HashMap(entrys.size());
        boolean isImportDataOverlap = false;
        boolean isTotalDataOverlap = false;
        for (DynamicObject entry : entrys) {
            if (isImportDataOverlap && isTotalDataOverlap) break;
            Long value1 = entry.getLong(key1);
            Long value2 = entry.getLong(key2);
            HashSet<Long> newIdSet = (HashSet<Long>)newMap.get(value1);
            HashSet<Long> oldIdSet = (HashSet<Long>)oldMap.get(value1);
            if (newIdSet == null) {
                newIdSet = new HashSet<Long>(16);
                newMap.put(value1, newIdSet);
            }
            if (oldIdSet == null) {
                oldIdSet = new HashSet<Long>(16);
                oldMap.put(value1, oldIdSet);
            }
            if (entry.getLong("id") == 0L) {
                if (!newIdSet.add(value2)) {
                    isImportDataOverlap = true;
                }
                if (!oldIdSet.contains(value2)) continue;
                isTotalDataOverlap = true;
                continue;
            }
            oldIdSet.add(value2);
            if (!newIdSet.contains(value2)) continue;
            isTotalDataOverlap = true;
        }
        if (isImportDataOverlap) {
            this.addErrorMessage(entity, importDataOverlapMsg);
        }
        if (isTotalDataOverlap) {
            this.addErrorMessage(entity, totalDataOverlapMsg);
        }
    }

    private void checkSalaryItemToTaxItemEntry(ExtendedDataEntity entity, DynamicObjectCollection salaryItemMapEntrys, boolean isImport, Set<Long> hasOrgPermsItemIdSet, boolean isSave) {
        HashBasedTable taxPayerTypeTable = HashBasedTable.create();
        ArrayList<Integer> taxPayerTypeSeqList = null;
        HashBasedTable taxItemTable = HashBasedTable.create();
        ArrayList<Integer> taxItemSeqList = null;
        long countryId = entity.getDataEntity().getLong("country.id");
        String orgName = entity.getDataEntity().getString("org.name");
        int index = 0;
        for (DynamicObject salaryItemMapEntry : salaryItemMapEntrys) {
            String errorMsg;
            String errorMsg2;
            ++index;
            Long salaryItemId = salaryItemMapEntry.getLong("presalaryitem.id");
            Long taxPayerTypeId = salaryItemMapEntry.getLong("pretaxcategory.taxpayertype.id");
            String salaryItemName = salaryItemMapEntry.getString("presalaryitem.name");
            String taxItemName = salaryItemMapEntry.getString("pretaxitem.name");
            if (isImport) {
                if ("2".equals(salaryItemMapEntry.getString("presalaryitem.areatype")) && salaryItemMapEntry.getLong("presalaryitem.country.id") != countryId) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u85aa\u916c\u9879\u76ee{0}\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u6620\u5c04\u65b9\u6848\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_37", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemName));
                    continue;
                }
                if (!"1".equals(salaryItemMapEntry.getString("presalaryitem.taxtag")) || !"0".equals(salaryItemMapEntry.getString("presalaryitem.calblock"))) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5e94\u4f7f\u7528\u4e2a\u7a0e\u6807\u7b7e\u4e3a\u4e2a\u7a0e\u6e90\u9879\u76ee\u4e14\u8ba1\u7b97\u533a\u6bb5\u4e3a\u7a0e\u524d\u7684\u85aa\u916c\u9879\u76ee\uff0c\u85aa\u916c\u9879\u76ee{0}\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_38", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemName));
                    continue;
                }
                if (SIT_CALTAXTYPE_SUBMITTAX.longValue() != salaryItemMapEntry.getLong("pretaxitem.caltaxtype.id")) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u5e94\u4f7f\u7528\u7528\u9014\u4e3a\u201c\u63d0\u4ea4\u7a0e\u5c40\u201d\u7684\u4e2a\u7a0e\u9879\u76ee\uff0c\u4e2a\u7a0e\u9879\u76ee{0}\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_39", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, taxItemName));
                    continue;
                }
                if ("1".equals(salaryItemMapEntry.getString("pretaxitem.countrytype")) && salaryItemMapEntry.getLong("pretaxitem.country.id") != countryId) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u4e2a\u7a0e\u9879\u76ee{0}\u7684\u56fd\u5bb6/\u5730\u533a\u4e0e\u6620\u5c04\u65b9\u6848\u7684\u56fd\u5bb6/\u5730\u533a\u4e0d\u4e00\u81f4\uff0c\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_40", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, taxItemName));
                    continue;
                }
                if (salaryItemMapEntry.getLong("presalaryitem.datatype.id") != salaryItemMapEntry.getLong("pretaxitem.datatype.id")) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee{0}\u4e0e\u4e2a\u7a0e\u9879\u76ee{1}\u7684\u6570\u636e\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_46", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemName, taxItemName));
                    continue;
                }
                DynamicObjectCollection taxCategories = salaryItemMapEntry.getDynamicObjectCollection("pretaxitem.taxcategories");
                Set taxCategoryiesIdSet = taxCategories.stream().map(taxCategory -> taxCategory.getLong("fbasedataid_id")).collect(Collectors.toSet());
                if (!taxCategoryiesIdSet.contains(salaryItemMapEntry.getLong("pretaxcategory.id"))) {
                    errorMsg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u4e2a\u7a0e\u9879\u76ee{0}\u672a\u5305\u542b\u4e2a\u7a0e\u79cd\u7c7b{1}\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_48", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg, taxItemName, salaryItemMapEntry.getString("pretaxcategory.name")));
                    continue;
                }
            }
            if (isSave) {
                if (!"1".equals(salaryItemMapEntry.getString("presalaryitem.enable")) || !"C".equals(salaryItemMapEntry.getString("presalaryitem.status"))) {
                    errorMsg2 = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u85aa\u916c\u9879\u76ee\u7f16\u7801\u4e3a{0}\u7684\u85aa\u916c\u9879\u76ee\u3002\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u5df2\u5ba1\u6838\u5e76\u5904\u4e8e\u53ef\u7528\u72b6\u6001\u3002", (String)"TaxItemMappingSchemeValidator_24", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemMapEntry.getString("presalaryitem.number")));
                    continue;
                }
                if (!"1".equals(salaryItemMapEntry.getString("pretaxitem.enable")) || !"C".equals(salaryItemMapEntry.getString("pretaxitem.status"))) {
                    errorMsg2 = ResManager.loadKDString((String)"\u65e0\u6cd5\u627e\u5230\u4e2a\u7a0e\u9879\u76ee\u7f16\u7801\u4e3a{0}\u7684\u4e2a\u7a0e\u9879\u76ee\u3002\u8bf7\u786e\u8ba4\u8be5\u6570\u636e\u5df2\u5ba1\u6838\u5e76\u5904\u4e8e\u53ef\u7528\u72b6\u6001\u3002", (String)"TaxItemMappingSchemeValidator_25", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addErrorMessage(entity, MessageFormat.format(errorMsg2, salaryItemMapEntry.getString("pretaxitem.number")));
                }
            }
            if (isSave && !hasOrgPermsItemIdSet.contains(salaryItemId)) {
                if (!isImport) {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\uff1a\u7b2c{0}\u884c\uff0c\u85aa\u916c\u9879\u76ee{1}\u4e0d\u5728\u5f53\u524d\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u6743\u9650\u4e2d\u3002\u8bf7\u66f4\u6362\u85aa\u916c\u9879\u76ee\u540e\u91cd\u65b0\u64cd\u4f5c\u3002", (String)"TaxItemMappingSchemeValidator_9", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    errorMsg2 = MessageFormat.format(errorMsg2, index, salaryItemName);
                } else {
                    errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u85aa\u916c\u9879\u76ee{0}\u4e0d\u5728\u521b\u5efa\u7ec4\u7ec7{1}\u6743\u9650\u5185\uff0c\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u91cd\u65b0\u68c0\u67e5\u540e\u518d\u5bfc\u5165\u6570\u636e\u3002", (String)"TaxItemMappingSchemeValidator_36", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    errorMsg2 = MessageFormat.format(errorMsg2, salaryItemName, orgName);
                }
                this.addErrorMessage(entity, errorMsg2);
                continue;
            }
            if (isImport) continue;
            taxPayerTypeSeqList = (ArrayList<Integer>)taxPayerTypeTable.get((Object)salaryItemId, (Object)taxPayerTypeId);
            if (taxPayerTypeSeqList == null) {
                taxPayerTypeSeqList = new ArrayList<Integer>(10);
                taxPayerTypeSeqList.add(salaryItemMapEntry.getInt("seq"));
            } else if (taxPayerTypeSeqList.size() > 0) {
                taxPayerTypeSeqList.add(salaryItemMapEntry.getInt("seq"));
                errorMsg2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u7b2c{0}\u884c\u85aa\u916c\u9879\u76ee\u5bf9\u5e94\u7684\u7eb3\u7a0e\u4eba\u7c7b\u578b\u4e0d\u80fd\u76f8\u540c\u3002", (String)"TaxItemMappingSchemeValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, MessageFormat.format(errorMsg2, String.valueOf(taxPayerTypeSeqList)));
            }
            taxPayerTypeTable.put((Object)salaryItemId, (Object)taxPayerTypeId, taxPayerTypeSeqList);
            Long preTaxCategoryId = salaryItemMapEntry.getLong("pretaxcategory.id");
            Long preTaxItemId = salaryItemMapEntry.getLong("pretaxitem.id");
            taxItemSeqList = (ArrayList<Integer>)taxItemTable.get((Object)preTaxCategoryId, (Object)preTaxItemId);
            if (taxItemSeqList == null) {
                taxItemSeqList = new ArrayList<Integer>(10);
                taxItemSeqList.add(salaryItemMapEntry.getInt("seq"));
            } else if (taxItemSeqList.size() > 0) {
                taxItemSeqList.add(salaryItemMapEntry.getInt("seq"));
                errorMsg = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u5230\u4e2a\u7a0e\u9879\u76ee\u8bbe\u7f6e\u4e2d\uff0c\u7b2c{0}\u884c\u4e2a\u7a0e\u79cd\u7c7b\u548c\u4e2a\u7a0e\u9879\u76ee\u4e0d\u80fd\u5b8c\u5168\u76f8\u540c\u3002", (String)"TaxItemMappingSchemeValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addErrorMessage(entity, MessageFormat.format(errorMsg, String.valueOf(taxItemSeqList)));
            }
            taxItemTable.put((Object)preTaxCategoryId, (Object)preTaxItemId, taxItemSeqList);
        }
    }

    private DynamicObjectCollection getTaxItemMappingInfo(Long orgId, Long countryId, Long boId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_taxprojscheme");
        QFilter filter = new QFilter("org", "=", (Object)orgId);
        filter.and("country", "=", (Object)countryId);
        filter.and("boid", "!=", (Object)boId);
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        return helper.queryOriginalCollection("id", new QFilter[]{filter});
    }
}

