/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.view;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class SalarySlipPrintSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        HashSet<String> printTplIdSet = new HashSet<String>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            String printTplId = dataEntity.getDataEntity().getString("printtpl.id");
            printTplIdSet.add(printTplId);
        }
        QFilter filter = new QFilter("printtplid", "in", printTplIdSet);
        filter.and("billformid", "=", (Object)"hsas_calperson");
        filter.and("enable", "=", (Object)"1");
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"bos_manageprinttpl", (String)"printtplid.id", (QFilter[])new QFilter[]{filter});
        HashSet<String> printTplIdResultSet = new HashSet<String>(dynamicObjects.length);
        for (DynamicObject dynamicObject : dynamicObjects) {
            printTplIdResultSet.add(dynamicObject.getString("printtplid.id"));
        }
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject printSchemeObj = dynamicObject.getDataEntity();
            DynamicObjectCollection coll = printSchemeObj.getDynamicObjectCollection("entryentity");
            if (coll.size() == 0) {
                String errorMessage = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u85aa\u916c\u9879\u76ee\u3002", (String)"SalarySlipPrintSaveValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMessage);
                continue;
            }
            HashSet<String> displayNameSet = new HashSet<String>(16);
            HashSet<Long> salaryItemSet = new HashSet<Long>(16);
            for (DynamicObject dynamicObject2 : coll) {
                String errorMessage;
                String displayName = dynamicObject2.getString("displayname");
                DynamicObject salaryItemObj = dynamicObject2.getDynamicObject("salaryitem");
                if (displayNameSet.contains(displayName)) {
                    errorMessage = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u663e\u793a\u540d\u79f0\u201c{0}\u201d\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalarySlipPrintSaveValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[]{displayName});
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMessage);
                    continue;
                }
                displayNameSet.add(displayName);
                if (salaryItemObj == null) {
                    errorMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u85aa\u916c\u9879\u76ee\u3002", (String)"SalarySlipPrintSaveValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMessage);
                    continue;
                }
                Long salaryItemId = salaryItemObj.getLong("id");
                String salaryItemName = salaryItemObj.getString("name");
                if (salaryItemSet.contains(salaryItemId)) {
                    String errorMessage2 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u201c{0}\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalarySlipPrintSaveValidator_3", (String)"swc-hsbs-opplugin", (Object[])new Object[]{salaryItemName});
                    this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMessage2);
                    continue;
                }
                salaryItemSet.add(salaryItemId);
                Long conutryId = printSchemeObj.getLong("country.id");
                Long itemCountryId = salaryItemObj.getLong("country.id");
                if (itemCountryId == 0L || itemCountryId.equals(conutryId)) continue;
                String salaryItemNumber = salaryItemObj.getString("number");
                String errorMessage3 = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a\u201c{0}\u201d\u3002", (String)"SalarySlipPrintSaveValidator_4", (String)"swc-hsbs-opplugin", (Object[])new Object[]{salaryItemNumber});
                this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMessage3);
            }
            String printTplFormId = printSchemeObj.getString("printtpl.formid.number");
            String printTplId = printSchemeObj.getString("printtpl.id");
            if (StringUtils.equals((CharSequence)printTplFormId, (CharSequence)"hsas_calperson") && printTplIdResultSet.contains(printTplId)) continue;
            String printTplNumber = printSchemeObj.getString("printtpl.number");
            String errorMessage = ResManager.loadKDString((String)"\u6253\u5370\u6a21\u677f\u6570\u636e\u4e0d\u5b58\u5728\u6216\u8005\u4e0d\u7b26\u5408\u5b57\u6bb5\u7b5b\u9009\u6761\u4ef6\uff1a\u201c{0}\u201d\u3002", (String)"SalarySlipPrintSaveValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[]{printTplNumber});
            this.addFatalErrorMessage((ExtendedDataEntity)dynamicObject, errorMessage);
        }
    }
}

