/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.validator.view;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import org.apache.commons.lang.StringUtils;

public class SalarySlipViewSaveValidator
extends SWCDataBaseValidator {
    private static final String ENTRYENTITY = "entryentity";
    private static final String ITEMDISPLAYNAME = "itemdisplayname";
    private static final String GROUPDISPLAYNAME = "groupdisplayname";
    private static final String SUBENTRYENTITY = "subentryentity";

    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
            DynamicObject viewObj = dataEntity.getDataEntity();
            this.checkEmailContent(dataEntity, viewObj);
            DynamicObjectCollection entryEntity = this.checkEntryEntity(dataEntity, viewObj);
            if (entryEntity != null) {
                this.checkSubEntryEntity(dataEntity, entryEntity);
            }
            this.checkQueryDuration(dataEntity, viewObj);
            this.checkMsgTplMustInput(dataEntity, viewObj);
        }
    }

    private void checkMsgTplMustInput(ExtendedDataEntity dataEntity, DynamicObject viewObj) {
        DynamicObjectCollection msgtemplate;
        boolean ispushnotify = viewObj.getBoolean("ispushnotify");
        if (ispushnotify && ((msgtemplate = viewObj.getDynamicObjectCollection("msgtemplate")) == null || msgtemplate.size() == 0)) {
            String errorMessage = ResManager.loadKDString((String)"\u201c\u6d88\u606f\u6a21\u677f\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u586b\u5199\u3002", (String)"SalarySlipViewSaveValidator_15", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, errorMessage);
        }
    }

    private void checkQueryDuration(ExtendedDataEntity dataEntity, DynamicObject viewObj) {
        int validDuration;
        boolean isunlimited = viewObj.getBoolean("isunlimited");
        if (!isunlimited && (validDuration = viewObj.getInt("validduration")) == 0) {
            String errorMessage = ResManager.loadKDString((String)"\u201c\u67e5\u8be2\u65f6\u957f\u201d\u5b57\u6bb5\u8d85\u51fa\u6570\u503c\u8303\u56f4\uff080,366\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalarySlipViewSaveValidator_13", (String)"swc-hsbs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(dataEntity, errorMessage);
        }
    }

    private void checkSubEntryEntity(ExtendedDataEntity dataEntity, DynamicObjectCollection entryEntity) {
        String errorMessage;
        String emptyName;
        LinkedHashSet<String> emptyNameSet = new LinkedHashSet<String>();
        LinkedHashSet<String> emptySalaryItemSet = new LinkedHashSet<String>();
        ArrayList<DynamicObject> subDyObjList = new ArrayList<DynamicObject>();
        for (DynamicObject dynamicObject : entryEntity) {
            DynamicObjectCollection subEntryEntity = dynamicObject.getDynamicObjectCollection(SUBENTRYENTITY);
            if (subEntryEntity == null || subEntryEntity.isEmpty()) {
                String groupDisplayName = dynamicObject.getString(GROUPDISPLAYNAME);
                if (SWCStringUtils.isEmpty((String)groupDisplayName)) continue;
                String errorMessage2 = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u201c%s\u201d\u4e0b\u65e0\u5de5\u8d44\u6761\u9879\u76ee\uff0c\u8bf7\u6dfb\u52a0\u3002", (String)"SalarySlipViewSaveValidator_1", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), groupDisplayName);
                this.addFatalErrorMessage(dataEntity, errorMessage2);
                continue;
            }
            for (DynamicObject subDyObj : subEntryEntity) {
                String entryDisplayName;
                DynamicObject parentDyObj;
                if (SWCStringUtils.isEmpty((String)subDyObj.getString(ITEMDISPLAYNAME))) {
                    parentDyObj = (DynamicObject)subDyObj.getParent();
                    entryDisplayName = parentDyObj.getString(GROUPDISPLAYNAME);
                    emptyNameSet.add(entryDisplayName);
                    continue;
                }
                if (subDyObj.getDynamicObject("item") == null) {
                    parentDyObj = (DynamicObject)subDyObj.getParent();
                    entryDisplayName = parentDyObj.getString(GROUPDISPLAYNAME);
                    emptySalaryItemSet.add(entryDisplayName);
                    continue;
                }
                subDyObjList.add(subDyObj);
            }
        }
        if (!emptyNameSet.isEmpty()) {
            emptyName = StringUtils.join((Object[])emptyNameSet.toArray(), (String)"\uff0c");
            errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u201c%s\u201d\u4e0b\u5b58\u5728\u663e\u793a\u540d\u79f0\u4e3a\u7a7a\u7684\u5de5\u8d44\u6761\u9879\u76ee\uff0c\u8bf7\u586b\u5199\u3002", (String)"SalarySlipViewSaveValidator_5", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), emptyName);
            this.addFatalErrorMessage(dataEntity, errorMessage);
        }
        if (!emptySalaryItemSet.isEmpty()) {
            emptyName = StringUtils.join((Object[])emptySalaryItemSet.toArray(), (String)"\uff0c");
            errorMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u201c%s\u201d\u4e0b\u5b58\u5728\u5de5\u8d44\u6761\u9879\u76ee\u4e3a\u7a7a\u3002\u539f\u5de5\u8d44\u6761\u9879\u76ee\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"SalarySlipViewSaveValidator_14", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), emptyName);
            this.addFatalErrorMessage(dataEntity, errorMessage);
        }
        LinkedHashSet<String> duplicatedSet = new LinkedHashSet<String>();
        for (int i = 0; i < subDyObjList.size(); ++i) {
            DynamicObject element = (DynamicObject)subDyObjList.get(i);
            int elementIndex = this.findElement(subDyObjList, element, i, SUBENTRYENTITY);
            if (elementIndex == -1) continue;
            String duplicatedName = "\u201c" + element.getString(ITEMDISPLAYNAME) + "\u201d";
            duplicatedSet.add(duplicatedName);
        }
        if (!duplicatedSet.isEmpty()) {
            String duplicatedStr = StringUtils.join((Object[])duplicatedSet.toArray(), (String)"\uff0c");
            String tipMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u663e\u793a\u540d\u79f0%s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalarySlipViewSaveValidator_9", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), duplicatedStr);
            this.addFatalErrorMessage(dataEntity, tipMessage);
        }
    }

    private DynamicObjectCollection checkEntryEntity(ExtendedDataEntity dataEntity, DynamicObject viewObj) {
        DynamicObjectCollection entryEntity = viewObj.getDynamicObjectCollection(ENTRYENTITY);
        if (entryEntity == null || entryEntity.isEmpty()) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u6dfb\u52a0\u4e00\u4e2a\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u3002", (String)"SalarySlipViewSaveValidator_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
        } else {
            LinkedHashSet<String> duplicatedSet = new LinkedHashSet<String>();
            int count = 0;
            for (int i = 0; i < entryEntity.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(i);
                int elementIndex = this.findElement((List<DynamicObject>)entryEntity, dynamicObject, i, ENTRYENTITY);
                if (elementIndex != -1) {
                    String duplicatedName = "\u201c" + dynamicObject.getString(GROUPDISPLAYNAME) + "\u201d";
                    duplicatedSet.add(duplicatedName);
                }
                if (!((DynamicObject)entryEntity.get(i)).getBoolean("isautoendsummary") || !((DynamicObject)entryEntity.get(i)).getBoolean("isautoendtopshow")) continue;
                if (count >= 8) {
                    this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u81ea\u52a9\u7aef\u9876\u90e8\u6700\u591a\u53ef\u663e\u793a8\u4e2a\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u3002", (String)"SalarySlipViewSaveValidator_11", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
                }
                ++count;
            }
            if (!duplicatedSet.isEmpty()) {
                String duplicatedStr = StringUtils.join((Object[])duplicatedSet.toArray(), (String)"\uff0c");
                String tipMessage = String.format(Locale.ROOT, ResManager.loadKDString((String)"\u5de5\u8d44\u6761\u9879\u76ee\u5206\u7ec4\u663e\u793a\u540d\u79f0%s\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"SalarySlipViewSaveValidator_10", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), duplicatedStr);
                this.addFatalErrorMessage(dataEntity, tipMessage);
            }
        }
        return entryEntity;
    }

    private void checkEmailContent(ExtendedDataEntity dataEntity, DynamicObject viewObj) {
        String emailContent;
        boolean mailFlag = viewObj.getBoolean("issendbymail");
        if (mailFlag && SWCStringUtils.isEmpty((String)(emailContent = viewObj.getString("emailcontent")))) {
            this.addFatalErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u90ae\u4ef6\u6b63\u6587\u3002", (String)"SalarySlipViewSaveValidator_2", (String)"swc-hsbs-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private int findElement(List<DynamicObject> coll, DynamicObject element, int except, String findType) {
        block5: {
            block4: {
                if (coll == null) {
                    return -1;
                }
                if (!ENTRYENTITY.equals(findType)) break block4;
                String elementGroupName = element.getString(GROUPDISPLAYNAME);
                if (SWCStringUtils.isEmpty((String)elementGroupName)) break block5;
                int length = coll.size();
                for (int i = 0; i < length; ++i) {
                    DynamicObject dynamicObject = coll.get(i);
                    String entryDisplayName = dynamicObject.getString(GROUPDISPLAYNAME);
                    if (SWCStringUtils.isEmpty((String)entryDisplayName) || !elementGroupName.equals(entryDisplayName) || element.equals(dynamicObject)) continue;
                    return i;
                }
                break block5;
            }
            if (SUBENTRYENTITY.equals(findType)) {
                String elementItemName = element.getString(ITEMDISPLAYNAME);
                DynamicObject itemObj = element.getDynamicObject("item");
                int length = coll.size();
                for (int i = 0; i < length; ++i) {
                    DynamicObject dynamicObject = coll.get(i);
                    DynamicObject subEntrySalObj = dynamicObject.getDynamicObject("item");
                    String entryDisplayName = dynamicObject.getString(ITEMDISPLAYNAME);
                    if (!elementItemName.equals(entryDisplayName) && !itemObj.equals(subEntrySalObj) || dynamicObject.equals(element)) continue;
                    return i;
                }
            }
        }
        return -1;
    }
}

