/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.FormulaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.DataTypeEnum;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.basedata.SalaryItemSaveValidator;

public class SalaryItemSaveOp
extends SWCDataBaseOp {
    private static final String FIELD_SYSINSNAME = "sysinsname";
    private static final String[] mainFields = new String[]{"datatype", "datalength", "salaryitemtype"};
    private static final String[] areatypeFields = new String[]{"country", "areatype"};

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add(FIELD_SYSINSNAME);
        fieldKeys.add("uniquecode");
        fieldKeys.add("datatype");
        fieldKeys.add("dataprecision");
        fieldKeys.add("dataround");
        fieldKeys.add("datalength");
        fieldKeys.add("country.id");
        fieldKeys.add("taxtag");
        fieldKeys.add("ispayoutitem");
        fieldKeys.add("calblock");
        fieldKeys.add("iscostallot");
        fieldKeys.add("statisticstag.areatype");
        fieldKeys.add("statisticstag.country.id");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new SalaryItemSaveValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
        DynamicObject[] dynamicObjects = args.getDataEntities();
        HashSet<Long> ids = new HashSet<Long>();
        for (DynamicObject dynamicObject : dynamicObjects) {
            long id = dynamicObject.getLong("id");
            if (id != 0L) {
                ids.add(id);
            }
            if (dynamicObject.getLong("datatype.id") == 1030L) continue;
            dynamicObject.set("datalength", (Object)0);
        }
        if (!ids.isEmpty()) {
            long id;
            SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
            QFilter filter = new QFilter("id", "in", ids);
            HashSet<String> enableSet = new HashSet<String>();
            enableSet.add("1");
            enableSet.add("0");
            filter.and("enable", "in", enableSet);
            DynamicObject[] dataStorageColl = helper.query("id,datatype,datalength,dataprecision,dataround,enable,country,areatype,salaryitemtype", new QFilter[]{filter});
            HashMap<Long, DynamicObject> dataStorageMap = new HashMap<Long, DynamicObject>(dataStorageColl.length);
            for (DynamicObject dataStorage : dataStorageColl) {
                id = dataStorage.getLong("id");
                dataStorageMap.put(id, dataStorage);
            }
            for (DynamicObject dynamicObject : dynamicObjects) {
                id = dynamicObject.getLong("id");
                if (id == 0L || dataStorageMap.get(id) == null) continue;
                DynamicObject dataStorage = (DynamicObject)dataStorageMap.get(id);
                for (String field : mainFields) {
                    dynamicObject.set(field, dataStorage.get(field));
                }
                if (DataTypeEnum.AMOUNT.getDbId() != dataStorage.getLong("datatype.id")) continue;
                dynamicObject.set("dataprecision", dataStorage.get("dataprecision"));
            }
            this.filterCountryUpdate(ids, dynamicObjects);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if ("save".equals(operationKey) || "submit".equals(operationKey)) {
            HashMap uniqueCodeRelMap;
            DynamicObject[] dynamicObjects;
            for (DynamicObject dynamicObject : dynamicObjects = args.getDataEntities()) {
                String number = dynamicObject.getString("number");
                String uniqueCode = "SL_" + number;
                dynamicObject.set("uniquecode", (Object)uniqueCode);
                DynamicObject salaryItemTypeObj = dynamicObject.getDynamicObject("salaryitemtype");
                dynamicObject.set("calblock", salaryItemTypeObj.get("calblock"));
            }
            DynamicObject[] datas = args.getDataEntities();
            Map<Long, String> dataMap = Arrays.stream(datas).filter(data -> data.getLong("id") != 0L).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name")));
            Map changeMap = FormulaHelper.getChangeMap(dataMap, (String)"SL", uniqueCodeRelMap = new HashMap(16));
            if (!changeMap.isEmpty()) {
                FormulaHelper.updateCalElementName((Map)changeMap, uniqueCodeRelMap, (String)"SL");
            }
        }
    }

    private void filterCountryUpdate(Set<Long> ids, DynamicObject[] dynamicObjects) {
        long id;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_salaryitem");
        QFilter filter = new QFilter("id", "in", ids);
        DynamicObject[] dataStorageColl = helper.query("country,areatype", new QFilter[]{filter});
        HashMap<Long, DynamicObject> dataStorageMap = new HashMap<Long, DynamicObject>(dataStorageColl.length);
        for (DynamicObject dataStorage : dataStorageColl) {
            id = dataStorage.getLong("id");
            dataStorageMap.put(id, dataStorage);
        }
        for (DynamicObject dynamicObject : dynamicObjects) {
            id = dynamicObject.getLong("id");
            if (id == 0L || dataStorageMap.get(id) == null) continue;
            DynamicObject dataStorage = (DynamicObject)dataStorageMap.get(id);
            for (String field : areatypeFields) {
                dynamicObject.set(field, dataStorage.get(field));
            }
        }
    }
}

