/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.bizitem;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.business.cal.helper.FormulaHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.bizitem.BizItemValidator;

public class BizItemSaveOp
extends SWCDataBaseOp {
    private static final String UNIQUE_CODE_PREFIX = "BS_";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeyList = args.getFieldKeys();
        fieldKeyList.add("uniquecode");
        fieldKeyList.add("datatype");
        fieldKeyList.add("inputmaxval");
        fieldKeyList.add("inputminval");
        fieldKeyList.add("minvalue");
        fieldKeyList.add("maxvalue");
        fieldKeyList.add("isminvalnull");
        fieldKeyList.add("ismaxvalnull");
        fieldKeyList.add("datalength");
        fieldKeyList.add("enable");
        fieldKeyList.add("country");
        fieldKeyList.add("ctrlstrategy");
        fieldKeyList.add("earliestdate");
        fieldKeyList.add("lastdate");
        fieldKeyList.add("currency");
        fieldKeyList.add("maxinputtime");
        fieldKeyList.add("bizitemcategory");
        fieldKeyList.add("scalelimit");
        fieldKeyList.add("cycle");
        fieldKeyList.add("multipleinput");
        fieldKeyList.add("issalarystd");
        fieldKeyList.add("bizitempropentry");
        fieldKeyList.add("bizitempropentry.propisaudit");
        fieldKeyList.add("isextprop");
        fieldKeyList.add("oneoffconsume");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new BizItemValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dynamicObjects;
        boolean isAudit = SWCStringUtils.equals((String)args.getOperationKey(), (String)"audit");
        for (DynamicObject dynamicObject : dynamicObjects = args.getDataEntities()) {
            boolean isCycle;
            if (isAudit) {
                dynamicObject.set("enable", (Object)"1");
                DynamicObjectCollection propEntryColl = dynamicObject.getDynamicObjectCollection("bizitempropentry");
                for (DynamicObject propEntryObj : propEntryColl) {
                    propEntryObj.set("propisaudit", (Object)"1");
                }
                continue;
            }
            if (SWCStringUtils.equals((String)dynamicObject.getString("enable"), (String)"10")) {
                dynamicObject.set("uniquecode", (Object)(UNIQUE_CODE_PREFIX + dynamicObject.getString("number")));
            }
            this.dealDataType(dynamicObject);
            if (SWCStringUtils.isEmpty((String)dynamicObject.getString("ctrlstrategy"))) {
                dynamicObject.set("ctrlstrategy", (Object)"5");
            }
            if (isCycle = dynamicObject.getBoolean("cycle")) {
                dynamicObject.set("maxinputtime", (Object)0);
            } else {
                String multipleInput = dynamicObject.getString("multipleinput");
                if (SWCStringUtils.equals((String)multipleInput, (String)"0")) {
                    dynamicObject.set("maxinputtime", (Object)1);
                }
            }
            this.setValByDataType(dynamicObject);
        }
    }

    private void setValByDataType(DynamicObject bizItemObj) {
        Long dataTypeId = bizItemObj.getLong("datatype.id");
        if (dataTypeId == 1030L) {
            bizItemObj.set("maxvalue", null);
            bizItemObj.set("minvalue", null);
            bizItemObj.set("scalelimit", null);
            bizItemObj.set("earliestdate", null);
            bizItemObj.set("lastdate", null);
            bizItemObj.set("currency", null);
        } else if (dataTypeId == 1010L) {
            bizItemObj.set("datalength", null);
            bizItemObj.set("earliestdate", null);
            bizItemObj.set("lastdate", null);
            bizItemObj.set("currency", null);
        } else if (dataTypeId == 1020L) {
            bizItemObj.set("maxvalue", null);
            bizItemObj.set("minvalue", null);
            bizItemObj.set("scalelimit", null);
            bizItemObj.set("earliestdate", null);
            bizItemObj.set("lastdate", null);
            bizItemObj.set("datalength", null);
        } else if (dataTypeId == 1050L) {
            bizItemObj.set("maxvalue", null);
            bizItemObj.set("minvalue", null);
            bizItemObj.set("scalelimit", null);
            bizItemObj.set("currency", null);
            bizItemObj.set("datalength", null);
        }
    }

    private void dealDataType(DynamicObject dynamicObject) {
        long dataTypeId = dynamicObject.getLong("datatype.id");
        if (dataTypeId == 1010L) {
            dynamicObject.set("datalength", (Object)0);
            dynamicObject.set("earliestdate", null);
            dynamicObject.set("lastdate", null);
            dynamicObject.set("currency", null);
        } else if (dataTypeId == 1030L) {
            dynamicObject.set("minvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("maxvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("isminvalnull", (Object)"1");
            dynamicObject.set("ismaxvalnull", (Object)"1");
            dynamicObject.set("earliestdate", null);
            dynamicObject.set("lastdate", null);
            dynamicObject.set("currency", null);
            dynamicObject.set("scalelimit", null);
        } else if (dataTypeId == 1050L) {
            dynamicObject.set("datalength", (Object)0);
            dynamicObject.set("minvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("maxvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("isminvalnull", (Object)"1");
            dynamicObject.set("ismaxvalnull", (Object)"1");
            dynamicObject.set("currency", null);
            dynamicObject.set("scalelimit", null);
        } else if (dataTypeId == 1020L) {
            dynamicObject.set("datalength", (Object)0);
            dynamicObject.set("minvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("maxvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("isminvalnull", (Object)"1");
            dynamicObject.set("ismaxvalnull", (Object)"1");
            dynamicObject.set("earliestdate", null);
            dynamicObject.set("lastdate", null);
            dynamicObject.set("scalelimit", null);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        HashMap uniqueCodeRelMap;
        DynamicObject[] datas;
        Map<Long, String> dataMap;
        Map changeMap;
        super.beginOperationTransaction(args);
        String operationKey = args.getOperationKey();
        if (("save".equals(operationKey) || "submit".equals(operationKey)) && !(changeMap = FormulaHelper.getChangeMap(dataMap = Arrays.stream(datas = args.getDataEntities()).filter(data -> data.getLong("id") != 0L).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name"))), (String)"BS", uniqueCodeRelMap = new HashMap(16))).isEmpty()) {
            FormulaHelper.updateCalElementName((Map)changeMap, uniqueCodeRelMap, (String)"BS");
        }
    }
}

