/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.bizitemprop;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.cal.helper.FormulaHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.bizitemprop.BizItemPropValidator;

public class BizItemPropCheckOp
extends SWCDataBaseOp {
    private static final String UNIQUE_CODE_PREFIX = "BSP_";

    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeyList = args.getFieldKeys();
        fieldKeyList.add("propuniquecode");
        fieldKeyList.add("datatype");
        fieldKeyList.add("inputmaxval");
        fieldKeyList.add("inputminval");
        fieldKeyList.add("minvalue");
        fieldKeyList.add("maxvalue");
        fieldKeyList.add("isminvalnull");
        fieldKeyList.add("ismaxvalnull");
        fieldKeyList.add("datalength");
        fieldKeyList.add("enable");
        fieldKeyList.add("ctrlstrategy");
        fieldKeyList.add("earliestdate");
        fieldKeyList.add("lastdate");
        fieldKeyList.add("scalelimit");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new BizItemPropValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        DynamicObject[] dynamicObjects;
        boolean isAudit = SWCStringUtils.equals((String)args.getOperationKey(), (String)"audit");
        boolean isSubmit = SWCStringUtils.equals((String)args.getOperationKey(), (String)"submit");
        boolean isSave = SWCStringUtils.equals((String)args.getOperationKey(), (String)"save");
        for (DynamicObject dynamicObject : dynamicObjects = args.getDataEntities()) {
            if (isAudit) {
                dynamicObject.set("enable", (Object)"1");
                continue;
            }
            if (isSave || isSubmit) {
                dynamicObject.set("propuniquecode", (Object)(UNIQUE_CODE_PREFIX + dynamicObject.getString("number")));
            }
            this.dealDataType(dynamicObject);
        }
    }

    private void dealDataType(DynamicObject dynamicObject) {
        long dataTypeId = dynamicObject.getLong("datatype.id");
        if (dataTypeId == 1010L) {
            dynamicObject.set("datalength", (Object)0);
            dynamicObject.set("earliestdate", null);
            dynamicObject.set("lastdate", null);
        } else if (dataTypeId == 1030L) {
            dynamicObject.set("minvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("maxvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("isminvalnull", (Object)"1");
            dynamicObject.set("ismaxvalnull", (Object)"1");
            dynamicObject.set("earliestdate", null);
            dynamicObject.set("lastdate", null);
            dynamicObject.set("scalelimit", null);
        } else if (dataTypeId == 1050L) {
            dynamicObject.set("datalength", (Object)0);
            dynamicObject.set("minvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("maxvalue", (Object)BigDecimal.ZERO);
            dynamicObject.set("isminvalnull", (Object)"1");
            dynamicObject.set("ismaxvalnull", (Object)"1");
            dynamicObject.set("scalelimit", null);
        }
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        HashMap<String, String> uniqueCodeRelMap;
        DynamicObject[] datas;
        Map<Long, String> dataMap;
        Map<String, String> changeMap;
        String operationKey = args.getOperationKey();
        if (("save".equals(operationKey) || "submit".equals(operationKey)) && !(changeMap = this.getChangeMap(dataMap = Arrays.stream(datas = args.getDataEntities()).filter(data -> data.getLong("id") != 0L).collect(Collectors.toMap(data -> data.getLong("id"), data -> data.getString("name"))), uniqueCodeRelMap = new HashMap<String, String>(16))).isEmpty()) {
            FormulaHelper.updateCalElementName(changeMap, uniqueCodeRelMap, (String)"BSP");
        }
    }

    private Map<String, String> getChangeMap(Map<Long, String> dataMap, Map<String, String> uniqueCodeRelMap) {
        if (dataMap == null || dataMap.isEmpty()) {
            return new HashMap<String, String>(0);
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsbs_bizitemprop");
        DynamicObject[] oldDatas = helper.query("id,name,propuniquecode", new QFilter[]{new QFilter("id", "in", dataMap.keySet())});
        if (oldDatas == null || oldDatas.length <= 0) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> changeMap = new HashMap<String, String>(16);
        String keyFormat = ".[%s]";
        for (DynamicObject oldData : oldDatas) {
            String newName;
            String oldName = oldData.getString("name");
            if (SWCStringUtils.equals((String)oldName, (String)(newName = dataMap.get(oldData.getLong("id"))))) continue;
            changeMap.put(String.format(Locale.ROOT, keyFormat, oldName), String.format(Locale.ROOT, keyFormat, newName));
            uniqueCodeRelMap.put(String.format(Locale.ROOT, keyFormat, oldName), oldData.getString("propuniquecode"));
        }
        return changeMap;
    }
}

