/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.cal;

import java.util.List;
import java.util.Locale;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.enums.CalFrequencyEnum;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.opplugin.validator.basedata.cal.CalFrequencyValidator;

public class CalFrequencySaveOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("name");
        fieldKeys.add("enable");
        fieldKeys.add("type");
        fieldKeys.add("country");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CalFrequencyValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        String operationKey = args.getOperationKey();
        if (SWCStringUtils.equals((String)"save", (String)operationKey)) {
            SWCDataServiceHelper calFrequencyServiceHelper = new SWCDataServiceHelper("hsbs_calfrequency");
            for (DynamicObject calFrequency : args.getDataEntities()) {
                if (!SWCStringUtils.isEmpty((String)calFrequency.getString("number"))) continue;
                String type = calFrequency.getString("type");
                QFilter countryFilter = new QFilter("country", "=", (Object)calFrequency.getLong("country.id"));
                QFilter typeFilter = new QFilter("type", "=", (Object)type);
                countryFilter.and(typeFilter);
                int count = calFrequencyServiceHelper.count(countryFilter.toArray());
                String countryNumber = calFrequency.getString("country.number");
                if (countryNumber == null) {
                    countryNumber = "000";
                }
                calFrequency.set("number", (Object)(countryNumber + "_" + CalFrequencyEnum.valueOf((String)type).getCode() + "_" + String.format(Locale.ROOT, "%03d", count + 1)));
            }
        }
    }
}

