/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.calperiod;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;

public class CalPeriodSaveOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("entryentity");
        fieldKeys.add("monthday");
        fieldKeys.add("halfmonthfirstday");
        fieldKeys.add("halfmonthsecday");
        fieldKeys.add("weekday");
        fieldKeys.add("calfrequency");
        fieldKeys.add("periodnumberprefix");
        fieldKeys.add("periodnumbersubject");
        fieldKeys.add("periodnumbersuffix");
        fieldKeys.add("serialnumber");
        fieldKeys.add("periodnumber");
        fieldKeys.add("perioddate");
        fieldKeys.add("periodyear");
        fieldKeys.add("periodname");
        fieldKeys.add("creator");
        fieldKeys.add("createtime");
        fieldKeys.add("modifier");
        fieldKeys.add("modifytime");
        fieldKeys.add("disabler");
        fieldKeys.add("disabledate");
        fieldKeys.add("calperiodcount");
        fieldKeys.add("enddate");
        fieldKeys.add("entryentity.seq");
        fieldKeys.add("periodmasterid");
        fieldKeys.add("periodenable");
        fieldKeys.add("periodstatus");
        fieldKeys.add("periodcreator");
        fieldKeys.add("periodcreatetime");
        fieldKeys.add("periodmodifier");
        fieldKeys.add("periodmodifytime");
        fieldKeys.add("perioddisabler");
        fieldKeys.add("perioddisabledate");
        fieldKeys.add("periodissyspreset");
        fieldKeys.add("periodindex");
        fieldKeys.add("periodtypename");
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs args) {
        super.beforeExecuteOperationTransaction(args);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operationKey = args.getOperationKey();
        DynamicObject[] calPeriodTypes = args.getDataEntities();
        switch (operationKey) {
            case "save": 
            case "entrysave": 
            case "submit": 
            case "audit": {
                this.initCalPeriod(args, calPeriodTypes);
                break;
            }
        }
    }

    private void initCalPeriod(BeginOperationTransactionArgs args, DynamicObject[] calPeriodTypes) {
        DynamicObject calPeriodType = calPeriodTypes[0];
        DynamicObjectCollection calPeriods = calPeriodType.getDynamicObjectCollection("entryentity");
        this.calPeriodSort(calPeriods);
        this.setPeriodNumber(calPeriodType);
        DynamicObject creator = calPeriodType.getDynamicObject("creator");
        long periodCreator = creator == null ? 0L : creator.getLong("id");
        Date periodCreateTime = calPeriodType.getDate("createtime");
        DynamicObject modifier = calPeriodType.getDynamicObject("modifier");
        long periodModifier = modifier == null ? 0L : modifier.getLong("id");
        Date periodModifyTime = calPeriodType.getDate("modifytime");
        DynamicObject disAbler = calPeriodType.getDynamicObject("disabler");
        long periodDisAbler = disAbler == null ? 0L : disAbler.getLong("id");
        Date periodDisAbleDate = calPeriodType.getDate("disabledate");
        String name = calPeriodType.getString("name");
        HashMap<String, List<Integer>> periodNameMap = new HashMap<String, List<Integer>>(calPeriods.size());
        int index = 0;
        for (DynamicObject calPeriod : calPeriods) {
            this.setPeriodValue(name, periodCreator, periodCreateTime, periodModifier, periodModifyTime, periodDisAbler, periodDisAbleDate, calPeriod);
            if (!periodNameMap.containsKey(calPeriod.getString("periodname"))) {
                periodNameMap.put(calPeriod.getString("periodname"), new ArrayList(10));
            }
            periodNameMap.get(calPeriod.getString("periodname")).add(index + 1);
            ++index;
        }
        this.validateUniquePeriodName(args, calPeriodType, calPeriods, periodNameMap);
        calPeriodType.set("calperiodcount", (Object)calPeriods.size());
    }

    private void calPeriodSort(DynamicObjectCollection calPeriods) {
        calPeriods.sort((Comparator)new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(o1.getDate("perioddate"));
                calendar.set(5, 1);
                long o1PeriodDate = calendar.getTimeInMillis();
                calendar.setTime(o2.getDate("perioddate"));
                calendar.set(5, 1);
                long o2PeriodDate = calendar.getTimeInMillis();
                if (o1PeriodDate > o2PeriodDate) {
                    return -1;
                }
                if (o1PeriodDate < o2PeriodDate) {
                    return 1;
                }
                long o1EndDate = o1.getDate("enddate").getTime();
                long o2EndDate = o2.getDate("enddate").getTime();
                return Long.compare(o2EndDate, o1EndDate);
            }
        });
        for (int index = 0; index < calPeriods.size(); ++index) {
            ((DynamicObject)calPeriods.get(index)).set("seq", (Object)index);
        }
    }

    private void setPeriodValue(String name, long periodCreator, Date periodCreateTime, long periodModifier, Date periodModifyTime, long periodDisAbler, Date periodDisAbleDate, DynamicObject calPeriod) {
        calPeriod.set("periodmasterid", calPeriod.getPkValue());
        calPeriod.set("periodenable", (Object)"1");
        calPeriod.set("periodstatus", (Object)"C");
        calPeriod.set("periodtypename", (Object)name);
        calPeriod.set("periodindex", calPeriod.get("seq"));
        calPeriod.set("periodcreator", (Object)periodCreator);
        calPeriod.set("periodcreatetime", (Object)periodCreateTime);
        calPeriod.set("periodmodifier", (Object)periodModifier);
        calPeriod.set("periodmodifytime", (Object)periodModifyTime);
        calPeriod.set("perioddisabler", (Object)periodDisAbler);
        calPeriod.set("perioddisabledate", (Object)periodDisAbleDate);
        calPeriod.set("periodissyspreset", (Object)0);
        String calPeriodName = calPeriod.getString("periodname");
        if (SWCStringUtils.isEmpty((String)calPeriodName)) {
            calPeriodName = calPeriod.getString("periodnumber");
            calPeriod.set("periodname", (Object)calPeriodName);
        }
        this.setDate(calPeriod, "enddate");
        this.setDate(calPeriod, "ratedate");
        this.setDate(calPeriod, "paydate");
    }

    private void setDate(DynamicObject calPeriod, String field) {
        Date endDate = calPeriod.getDate(field);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(endDate);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calPeriod.set(field, (Object)calendar.getTime());
    }

    private void validateUniquePeriodName(BeginOperationTransactionArgs args, DynamicObject calPeriodType, DynamicObjectCollection calPeriods, HashMap<String, List<Integer>> periodNameMap) {
        for (Map.Entry<String, List<Integer>> entry : periodNameMap.entrySet()) {
            List<Integer> values = entry.getValue();
            if (values.size() <= 1) continue;
            String periodName = entry.getKey();
            StringBuilder stringBuilder = new StringBuilder();
            values.forEach(row -> stringBuilder.append(row).append(','));
            String failMessage = MessageFormat.format(ResManager.loadKDString((String)"{0} \u671f\u95f4\u4fe1\u606f\u7b2c{1}\u884c\uff0c \u671f\u95f4\u540d\u79f0\u91cd\u590d: {2}\u3002", (String)"CalPeriodSaveOp_0", (String)"swc-hsbs-opplugin", (Object[])new Object[0]), calPeriodType.getString("number"), stringBuilder.substring(0, stringBuilder.length() - 1), periodName);
            this.operationResult.setShowMessage(true);
            this.operationResult.setMessage(failMessage);
            this.operationResult.setSuccess(false);
            args.setCancelOperation(true);
        }
    }

    private void setPeriodNumber(DynamicObject calPeriodType) {
        String periodNumberPrefix = calPeriodType.getString("periodnumberprefix");
        String periodNumberSuffix = calPeriodType.getString("periodnumbersuffix");
        String subjectNumberField = calPeriodType.getString("periodnumbersubject");
        int serialnumberValue = calPeriodType.getInt("serialnumber");
        DynamicObjectCollection calPeriods = calPeriodType.getDynamicObjectCollection("entryentity");
        List<DynamicObject> resultCalPeriods = this.getGeneratePeriodNumberData(calPeriodType.getPkValue(), subjectNumberField, calPeriods);
        if (serialnumberValue == 0) {
            for (DynamicObject calPeriod : resultCalPeriods) {
                String subjectNumberValue = this.getSubjectNumberValue(calPeriod, subjectNumberField);
                String periodNumber = calPeriod.getString("periodnumber");
                if (!SWCStringUtils.isEmpty((String)periodNumber)) continue;
                calPeriod.set("periodnumber", (Object)(periodNumberPrefix + subjectNumberValue + periodNumberSuffix));
            }
        } else {
            HashMap<String, List<DynamicObject>> groupSubjectNumber = this.groupBySubjectNumber(periodNumberPrefix, periodNumberSuffix, subjectNumberField, resultCalPeriods);
            for (Map.Entry<String, List<DynamicObject>> entrySet : groupSubjectNumber.entrySet()) {
                String number = entrySet.getKey();
                List<DynamicObject> groupDynamicObject = entrySet.getValue();
                int max = this.getMaxSerialNumber((List<DynamicObject>)calPeriods, number);
                this.generatePeriodNumber(periodNumberPrefix, periodNumberSuffix, subjectNumberField, serialnumberValue, groupDynamicObject, max);
            }
        }
    }

    private void generatePeriodNumber(String periodNumberPrefix, String periodNumberSuffix, String subjectNumberField, int serialnumberValue, List<DynamicObject> groupDynamicObject, int max) {
        groupDynamicObject.sort(new Comparator<DynamicObject>(){

            @Override
            public int compare(DynamicObject o1, DynamicObject o2) {
                long o1EndDate = o1.getDate("startdate").getTime();
                long o2EndDate = o2.getDate("startdate").getTime();
                return Long.compare(o1EndDate, o2EndDate);
            }
        });
        for (DynamicObject dynamicObject : groupDynamicObject) {
            String subjectNumberValue = this.getSubjectNumberValue(dynamicObject, subjectNumberField);
            dynamicObject.set("periodnumber", (Object)(periodNumberPrefix + subjectNumberValue + periodNumberSuffix + String.format(Locale.ROOT, "%0" + serialnumberValue + 'd', ++max)));
        }
    }

    private List<DynamicObject> getGeneratePeriodNumberData(Object pk, String subjectNumberField, DynamicObjectCollection calPeriods) {
        DynamicObjectCollection resultCalPeriods = new ArrayList(calPeriods.size());
        SWCDataServiceHelper calPeriodTypeHelper = new SWCDataServiceHelper("hsbs_calperiodtype");
        DynamicObject calPeriodType = calPeriodTypeHelper.queryOne(pk);
        if (calPeriodType != null && !calPeriodType.getDynamicObjectCollection("entryentity").isEmpty()) {
            DynamicObjectCollection oldCalPeriods = calPeriodType.getDynamicObjectCollection("entryentity");
            HashMap<Long, DynamicObject> oldCalPeriodGroup = new HashMap<Long, DynamicObject>();
            for (DynamicObject oldCalPeriod : oldCalPeriods) {
                oldCalPeriodGroup.put((Long)oldCalPeriod.getPkValue(), oldCalPeriod);
            }
            for (DynamicObject calPeriod : calPeriods) {
                boolean fromDatabase = calPeriod.getDataEntityState().getFromDatabase();
                if (fromDatabase) {
                    DynamicObject oldCalPeriod;
                    String oldSubjectNumberValue;
                    String subjectNumberValue = this.getSubjectNumberValue(calPeriod, subjectNumberField);
                    if (SWCStringUtils.equals((String)subjectNumberValue, (String)(oldSubjectNumberValue = this.getSubjectNumberValue(oldCalPeriod = (DynamicObject)oldCalPeriodGroup.get((Long)calPeriod.getPkValue()), subjectNumberField)))) continue;
                    resultCalPeriods.add(calPeriod);
                    continue;
                }
                resultCalPeriods.add(calPeriod);
            }
        } else {
            resultCalPeriods = calPeriods;
        }
        return resultCalPeriods;
    }

    private int getMaxSerialNumber(List<DynamicObject> dynamicObjects, String number) {
        int max = 0;
        for (DynamicObject dynamicObject : dynamicObjects) {
            String periodNumber = dynamicObject.getString("periodnumber");
            if (!SWCStringUtils.isNotEmpty((String)periodNumber) || !SWCStringUtils.equals((String)number, (String)periodNumber.substring(0, number.length()))) continue;
            int order = Integer.parseInt(periodNumber.substring(number.length()));
            max = Integer.max(max, order);
        }
        return max;
    }

    private HashMap<String, List<DynamicObject>> groupBySubjectNumber(String periodNumberPrefix, String periodNumberSuffix, String subjectNumberField, List<DynamicObject> calPeriods) {
        HashMap<String, List<DynamicObject>> groupSubjectNumber = new HashMap<String, List<DynamicObject>>(16);
        for (DynamicObject calPeriod : calPeriods) {
            String subjectNumber = this.getSubjectNumberValue(calPeriod, subjectNumberField);
            String number = periodNumberPrefix + subjectNumber + periodNumberSuffix;
            List groupCalPeriods = groupSubjectNumber.computeIfAbsent(number, val -> new ArrayList(10));
            groupCalPeriods.add(calPeriod);
        }
        return groupSubjectNumber;
    }

    private String getSubjectNumberValue(DynamicObject calPeriod, String subjectNumberField) {
        switch (subjectNumberField) {
            case "perioddate": {
                return SWCDateTimeUtils.format((Date)calPeriod.getDate("perioddate"), (String)"yyyyMM");
            }
            case "startdate": {
                return SWCDateTimeUtils.format((Date)calPeriod.getDate("startdate"), (String)"yyyyMMdd");
            }
            case "enddate": {
                return SWCDateTimeUtils.format((Date)calPeriod.getDate("enddate"), (String)"yyyyMMdd");
            }
        }
        return "";
    }
}

