/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.fetchconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;
import kd.swc.hsbs.opplugin.validator.basedata.fetchconfig.CustFetchConfigValidator;

public class CustFetchConfigOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs eventArgs) {
        List fieldKeys = eventArgs.getFieldKeys();
        fieldKeys.add("fetchfieldentry");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new CustFetchConfigValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String opKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getLong("id")).collect(Collectors.toList());
        switch (opKey) {
            case "save": {
                this.doSaveFetchConfigItem(args.getDataEntities()[0]);
                break;
            }
            case "disable": {
                FetchConfigHelper.batchUpdateFetchConfigItemEnable((String)"0", pkIds, (String)"2");
                break;
            }
            case "enable": {
                FetchConfigHelper.batchUpdateFetchConfigItemEnable((String)"1", pkIds, (String)"2");
                break;
            }
            case "delete": {
                FetchConfigHelper.deleteResultFetchConfigItem((long)args.getDataEntities()[0].getLong("id"));
                break;
            }
        }
    }

    private void doSaveFetchConfigItem(DynamicObject object) {
        String enable = object.getString("enable");
        ArrayList list = new ArrayList(10);
        long custFetchConfig = object.getLong("id");
        DynamicObjectCollection objects = object.getDynamicObjectCollection("fetchfieldentry");
        for (DynamicObject obj : objects) {
            HashMap<String, Object> map = new HashMap<String, Object>(5);
            long fetchFieldEntryId = obj.getLong("id");
            long fetchItemId = obj.getLong("fetchitem.id");
            if (fetchItemId == 0L) continue;
            map.put("custfetchconfig", custFetchConfig);
            map.put("fetchfieldentry", fetchFieldEntryId);
            map.put("fetchitem", fetchItemId);
            map.put("enable", enable);
            map.put("configType", "2");
            list.add(map);
        }
        FetchConfigHelper.updateFetchConfigItem(list, (String)"custfetchconfig");
    }
}

