/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.hsbs.opplugin.web.basedata.fetchconfig;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.opplugin.web.SWCDataBaseOp;
import kd.swc.hsbs.business.basedata.fetchconfig.FetchConfigHelper;
import kd.swc.hsbs.opplugin.validator.basedata.fetchconfig.FetchConfigValidator;

public class FetchConfigOp
extends SWCDataBaseOp {
    public void onPreparePropertys(PreparePropertysEventArgs args) {
        List fieldKeys = args.getFieldKeys();
        fieldKeys.add("fetchfieldentry");
        fieldKeys.add("fetchfieldentry.id");
        fieldKeys.add("enable");
    }

    public void onAddValidators(AddValidatorsEventArgs args) {
        args.addValidator((AbstractValidator)new FetchConfigValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String opKey = args.getOperationKey();
        DynamicObject[] dataEntities = args.getDataEntities();
        List pkIds = Arrays.stream(dataEntities).map(param -> param.getLong("id")).collect(Collectors.toList());
        switch (opKey) {
            case "save": {
                this.doSaveFetchConfigItem(args.getDataEntities()[0]);
                break;
            }
            case "disable": {
                FetchConfigHelper.batchUpdateFetchConfigItemEnable((String)"0", pkIds, (String)"0");
                break;
            }
            case "enable": {
                FetchConfigHelper.batchUpdateFetchConfigItemEnable((String)"1", pkIds, (String)"0");
                break;
            }
            case "delete": {
                FetchConfigHelper.deleteFetchConfig(pkIds, (String)"10");
                break;
            }
        }
    }

    private void doSaveFetchConfigItem(DynamicObject dynamicObject) {
        String enable = dynamicObject.getString("enable");
        ArrayList list = new ArrayList(10);
        long fetchConfigId = dynamicObject.getLong("id");
        DynamicObjectCollection objects = dynamicObject.getDynamicObjectCollection("fetchfieldentry");
        if (SWCListUtils.isEmpty((List)objects)) {
            return;
        }
        for (DynamicObject obj : objects) {
            HashMap<String, Object> map = new HashMap<String, Object>(3);
            long fetchFieldEntryId = obj.getLong("id");
            long fetchItemId = obj.getLong("fetchitem.id");
            if (fetchItemId == 0L) continue;
            map.put("fetchconfig", fetchConfigId);
            map.put("fetchfieldentry", fetchFieldEntryId);
            map.put("fetchitem", fetchItemId);
            map.put("enable", enable);
            map.put("configType", "0");
            list.add(map);
        }
        FetchConfigHelper.updateFetchConfigItem(list, (String)"fetchconfig");
    }
}

